/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.craft.generator.type.create;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.content.kinetics.mixer.MixingRecipe;
import com.simibubi.create.content.processing.recipe.HeatCondition;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import studio.fantasyit.maid_storage_manager.craft.context.common.CommonUseAction;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideStepData;
import studio.fantasyit.maid_storage_manager.craft.generator.algo.ICachableGeneratorGraph;
import studio.fantasyit.maid_storage_manager.craft.generator.type.create.GeneratorCreate;
import studio.fantasyit.maid_storage_manager.data.InventoryItem;
import studio.fantasyit.maid_storage_manager.storage.Target;

public class GeneratorCreateMix
extends GeneratorCreate<MixingRecipe, RecipeType<MixingRecipe>, Container, BlockPos> {
    @Override
    @NotNull
    public ResourceLocation getType() {
        return AllRecipeTypes.MIXING.getId();
    }

    @Override
    public boolean isBlockValid(Level level, BlockPos pos) {
        return level.m_8055_(pos).m_60713_((Block)AllBlocks.BASIN.get()) && level.m_8055_(pos.m_7494_().m_7494_()).m_60713_((Block)AllBlocks.MECHANICAL_MIXER.get());
    }

    @Override
    public boolean allowMultiPosition() {
        return true;
    }

    @Override
    RecipeType<MixingRecipe> getRecipeType() {
        return AllRecipeTypes.MIXING.getType();
    }

    @Override
    public void transformAllIngredients(MixingRecipe recipe, List<Ingredient> all, List<Integer> counts) {
        if (recipe.getRequiredHeat() == HeatCondition.HEATED) {
            all.add(Ingredient.m_204132_((TagKey)ItemTags.f_13160_));
            counts.add(1);
        } else if (recipe.getRequiredHeat() == HeatCondition.SUPERHEATED) {
            all.add(Ingredient.m_43929_((ItemLike[])new ItemLike[]{AllItems.BLAZE_CAKE}));
            counts.add(1);
        }
    }

    @Override
    protected BlockPos getState(Level level, BlockPos pos, MixingRecipe recipe, ICachableGeneratorGraph graph) {
        return pos.m_7495_();
    }

    @Override
    protected void transformSteps(MixingRecipe recipe, List<ItemStack> items, BlockPos state, List<CraftGuideStepData> step, GeneratorCreate.StepGenerateStep generateStep) {
        if (recipe.getRequiredHeat() != HeatCondition.NONE && generateStep == GeneratorCreate.StepGenerateStep.INPUT_ITEM) {
            step.add(new CraftGuideStepData(Target.virtual(state, null), List.of(items.get(items.size() - 1)), List.of(), CommonUseAction.TYPE, true, new CompoundTag()));
        }
    }

    @Override
    public void generate(List<InventoryItem> inventory, Level level, BlockPos pos, ICachableGeneratorGraph graph, Map<ResourceLocation, List<BlockPos>> recognizedTypePositions) {
        boolean hasBurner = level.m_8055_(pos.m_7495_()).m_60713_((Block)AllBlocks.BLAZE_BURNER.get());
        this.addRecipeForPos(level, pos, this.getRecipeType(), graph, t -> t.getRequiredHeat() == HeatCondition.NONE || hasBurner);
    }

    @Override
    public Component getConfigName() {
        return Component.m_237115_((String)"config.maid_storage_manager.crafting.generating.create.mixing");
    }
}

