/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.craft.generator.type.create;

import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.content.kinetics.deployer.ManualApplicationRecipe;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import oshi.util.tuples.Pair;
import studio.fantasyit.maid_storage_manager.craft.context.common.CommonAttackAction;
import studio.fantasyit.maid_storage_manager.craft.context.common.CommonIdleAction;
import studio.fantasyit.maid_storage_manager.craft.context.common.CommonUseAction;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideData;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideStepData;
import studio.fantasyit.maid_storage_manager.craft.generator.algo.ICachableGeneratorGraph;
import studio.fantasyit.maid_storage_manager.craft.generator.type.base.IAutoCraftGuideGenerator;
import studio.fantasyit.maid_storage_manager.craft.generator.util.GenerateCondition;
import studio.fantasyit.maid_storage_manager.craft.generator.util.GenerateIngredientUtil;
import studio.fantasyit.maid_storage_manager.craft.type.CommonType;
import studio.fantasyit.maid_storage_manager.data.InventoryItem;
import studio.fantasyit.maid_storage_manager.registry.ItemRegistry;
import studio.fantasyit.maid_storage_manager.storage.ItemHandler.ItemHandlerStorage;
import studio.fantasyit.maid_storage_manager.storage.Target;
import studio.fantasyit.maid_storage_manager.util.PosUtil;
import studio.fantasyit.maid_storage_manager.util.StorageAccessUtil;

public class GeneratorCreateUse
implements IAutoCraftGuideGenerator {
    @Override
    @NotNull
    public ResourceLocation getType() {
        return AllRecipeTypes.ITEM_APPLICATION.getId();
    }

    @Override
    public boolean isBlockValid(Level level, BlockPos pos) {
        return level.m_8055_(pos).m_60838_((BlockGetter)level, pos) && StorageAccessUtil.getMarksForPosSet((Level)((ServerLevel)level), Target.virtual(pos, null), List.of(pos.m_122029_(), pos.m_122024_(), pos.m_122012_(), pos.m_122019_())).stream().map(Pair::getB).anyMatch(t -> t.m_150930_((Item)ItemRegistry.ALLOW_ACCESS.get())) && PosUtil.findInUpperSquare(pos.m_7494_(), 1, 3, 1, t -> level.m_8055_(t).m_60795_() ? null : Boolean.valueOf(true)) == null;
    }

    @Override
    public void generate(List<InventoryItem> inventory, Level level, BlockPos pos, ICachableGeneratorGraph graph, Map<ResourceLocation, List<BlockPos>> recognizedTypePositions) {
        StorageAccessUtil.Filter posFilter = GenerateCondition.getFilterOn(level, pos);
        level.m_7465_().m_44013_(AllRecipeTypes.ITEM_APPLICATION.getType()).forEach(recipe -> {
            Recipe patt3530$temp = recipe;
            if (patt3530$temp instanceof ManualApplicationRecipe) {
                ManualApplicationRecipe manualApplicationRecipe = (ManualApplicationRecipe)patt3530$temp;
                if (manualApplicationRecipe.getRequiredHeldItem().m_43947_()) {
                    return;
                }
                ItemStack resultItem = manualApplicationRecipe.m_8043_(level.m_9598_());
                if (!posFilter.isAvailable(resultItem)) {
                    return;
                }
                ArrayList<Ingredient> ingredients = new ArrayList<Ingredient>((Collection<Ingredient>)manualApplicationRecipe.m_7527_());
                Optional<Ingredient> toolOptional = GenerateIngredientUtil.optionalIngredient(GenerateIngredientUtil.getIngredientForDestroyBlockItem(resultItem));
                toolOptional.ifPresent(ingredients::add);
                graph.addRecipe(manualApplicationRecipe.m_6423_(), ingredients, ingredients.stream().map(t -> 1).toList(), resultItem, items -> {
                    ArrayList<CraftGuideStepData> craftGuideData = new ArrayList<CraftGuideStepData>();
                    craftGuideData.add(new CraftGuideStepData(new Target(ItemHandlerStorage.TYPE, pos, Direction.UP), List.of((ItemStack)items.get(0)), List.of(), CommonUseAction.TYPE, false, new CompoundTag()));
                    craftGuideData.add(new CraftGuideStepData(new Target(ItemHandlerStorage.TYPE, pos.m_7494_(), Direction.UP), List.of((ItemStack)items.get(1)), List.of(), CommonUseAction.TYPE, false, new CompoundTag()));
                    craftGuideData.add(new CraftGuideStepData(new Target(ItemHandlerStorage.TYPE, pos.m_7494_()), items.size() > 2 ? List.of((ItemStack)items.get(2)) : List.of(), List.of(resultItem), CommonAttackAction.TYPE, false, new CompoundTag()));
                    if (items.size() > 2) {
                        craftGuideData.add(new CraftGuideStepData(new Target(ItemHandlerStorage.TYPE, pos.m_7494_()), List.of(), List.of((ItemStack)items.get(2)), CommonIdleAction.TYPE, false, new CompoundTag()));
                    }
                    return new CraftGuideData(craftGuideData, CommonType.TYPE);
                });
            }
        });
    }

    @Override
    public void onCache(RecipeManager manager) {
    }

    @Override
    public Component getConfigName() {
        return Component.m_237115_((String)"config.maid_storage_manager.crafting.generating.create.application");
    }
}

