/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.craft.generator.type.mekanism;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import mekanism.api.recipes.ItemStackToItemStackRecipe;
import mekanism.common.content.blocktype.FactoryType;
import mekanism.common.recipe.MekanismRecipeType;
import mekanism.common.recipe.lookup.cache.InputRecipeCache;
import mekanism.common.tile.component.config.DataType;
import mekanism.common.tile.factory.TileEntityItemStackToItemStackFactory;
import mekanism.common.tile.machine.TileEntityEnergizedSmelter;
import mekanism.common.tile.prefab.TileEntityConfigurableMachine;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import studio.fantasyit.maid_storage_manager.craft.context.common.CommonPlaceItemAction;
import studio.fantasyit.maid_storage_manager.craft.context.common.CommonTakeItemAction;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideData;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideStepData;
import studio.fantasyit.maid_storage_manager.craft.generator.algo.ICachableGeneratorGraph;
import studio.fantasyit.maid_storage_manager.craft.generator.config.ConfigTypes;
import studio.fantasyit.maid_storage_manager.craft.generator.type.mekanism.GeneratorMek;
import studio.fantasyit.maid_storage_manager.craft.generator.util.GenerateCondition;
import studio.fantasyit.maid_storage_manager.craft.generator.util.RecipeUtil;
import studio.fantasyit.maid_storage_manager.craft.type.CommonType;
import studio.fantasyit.maid_storage_manager.craft.type.FurnaceType;
import studio.fantasyit.maid_storage_manager.data.InventoryItem;
import studio.fantasyit.maid_storage_manager.storage.ItemHandler.ItemHandlerStorage;
import studio.fantasyit.maid_storage_manager.storage.Target;
import studio.fantasyit.maid_storage_manager.util.StorageAccessUtil;

public class GeneratorMekSmelter
extends GeneratorMek<ItemStackToItemStackRecipe, InputRecipeCache.SingleItem<ItemStackToItemStackRecipe>> {
    ConfigTypes.ConfigType<Boolean> FACTORY_PARALLEL = new ConfigTypes.ConfigType<Boolean>("factory_parallel", true, (Component)Component.m_237115_((String)"config.maid_storage_manager.crafting.generating.mekanism.general.use_factory_parallel"), ConfigTypes.ConfigTypeEnum.Boolean);
    ConfigTypes.ConfigType<Boolean> REPLACE_FURNACE = new ConfigTypes.ConfigType<Boolean>("replace_furnace", true, (Component)Component.m_237115_((String)"config.maid_storage_manager.crafting.generating.mekanism.smelter.replace_furnace"), ConfigTypes.ConfigTypeEnum.Boolean);

    @Override
    protected MekanismRecipeType<ItemStackToItemStackRecipe, InputRecipeCache.SingleItem<ItemStackToItemStackRecipe>> getRecipeType() {
        return (MekanismRecipeType)MekanismRecipeType.SMELTING.get();
    }

    @Override
    public void generate(List<InventoryItem> inventory, Level level, BlockPos pos, ICachableGeneratorGraph graph, Map<ResourceLocation, List<BlockPos>> recognizedTypePositions) {
        StorageAccessUtil.Filter posFilter = GenerateCondition.getFilterOn(level, pos);
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof TileEntityConfigurableMachine) {
            TileEntityConfigurableMachine machine = (TileEntityConfigurableMachine)blockEntity;
            level.m_7465_().m_44013_(this.getRecipeType()).forEach(recipe -> this.generate(recipe, machine, level, pos, graph, recognizedTypePositions, posFilter));
            level.m_7465_().m_44013_(RecipeType.f_44108_).forEach(recipe -> {
                int count = this.FACTORY_PARALLEL.getValue() != false ? this.getFactoryParallel((BlockEntity)machine) : 1;
                ItemStack _output = recipe.m_8043_(level.m_9598_());
                ItemStack output = _output.m_255036_(_output.m_41613_() * count);
                graph.addRecipe(this.wrapId(recipe.m_6423_()), (List<Ingredient>)recipe.m_7527_(), recipe.m_7527_().stream().map(t -> count).toList(), output, items -> {
                    ArrayList<CraftGuideStepData> step = new ArrayList<CraftGuideStepData>();
                    if (this.addSteps(pos, machine, (List<ItemStack>)items, List.of(output), (List<CraftGuideStepData>)step)) {
                        return new CraftGuideData(step, CommonType.TYPE);
                    }
                    return null;
                });
            });
        }
        if (this.REPLACE_FURNACE.getValue().booleanValue()) {
            graph.blockType(FurnaceType.TYPE);
        }
    }

    @Override
    List<Ingredient> getRecipeIngredients(ItemStackToItemStackRecipe recipe, RecipeManager level, Map<ResourceLocation, List<BlockPos>> recognizedTypePositions) {
        return List.of(Ingredient.m_43921_(recipe.getInput().getRepresentations().stream()));
    }

    @Override
    protected boolean addSteps(BlockPos pos, TileEntityConfigurableMachine machine, ItemStackToItemStackRecipe recipe, List<ItemStack> inputs, List<ItemStack> outputs, List<CraftGuideStepData> steps) {
        return this.addSteps(pos, machine, inputs, outputs, steps);
    }

    private boolean addSteps(BlockPos pos, TileEntityConfigurableMachine machine, List<ItemStack> inputs, List<ItemStack> outputs, List<CraftGuideStepData> steps) {
        Direction inputSide = this.getTypeDirection(machine, List.of(DataType.INPUT, DataType.INPUT_OUTPUT));
        Direction outputSide = this.getTypeDirection(machine, List.of(DataType.OUTPUT, DataType.INPUT_OUTPUT));
        if (inputSide == null || outputSide == null) {
            return false;
        }
        steps.add(new CraftGuideStepData(new Target(ItemHandlerStorage.TYPE, pos, inputSide), inputs, List.of(), CommonPlaceItemAction.TYPE, false, new CompoundTag()));
        steps.add(new CraftGuideStepData(new Target(ItemHandlerStorage.TYPE, pos, outputSide), List.of(), outputs, CommonTakeItemAction.TYPE, false, new CompoundTag()));
        return true;
    }

    @Override
    public boolean isBlockValid(Level level, BlockPos pos) {
        TileEntityItemStackToItemStackFactory factory;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof TileEntityItemStackToItemStackFactory && (factory = (TileEntityItemStackToItemStackFactory)blockEntity).getFactoryType() == FactoryType.SMELTING) {
            return true;
        }
        return level.m_7702_(pos) instanceof TileEntityEnergizedSmelter;
    }

    @Override
    public Component getConfigName() {
        return Component.m_237115_((String)"config.maid_storage_manager.crafting.generating.mekanism.smelter");
    }

    private ResourceLocation wrapId(ResourceLocation id) {
        return RecipeUtil.wrapLocation(this.getType(), id);
    }

    @Override
    public List<ConfigTypes.ConfigType<?>> getConfigurations() {
        return List.of(this.REPLACE_FURNACE, this.FACTORY_PARALLEL);
    }

    @Override
    protected int getRecipeMultiplier(BlockEntity machine, ItemStackToItemStackRecipe recipe) {
        if (this.FACTORY_PARALLEL.getValue().booleanValue()) {
            return this.getFactoryParallel(machine);
        }
        return 1;
    }
}

