/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.maid.behavior.cowork;

import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidCheckRateTask;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import java.util.List;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.fantasyit.maid_storage_manager.items.WorkCardItem;
import studio.fantasyit.maid_storage_manager.maid.behavior.ScheduleBehavior;
import studio.fantasyit.maid_storage_manager.registry.MemoryModuleRegistry;
import studio.fantasyit.maid_storage_manager.storage.MaidStorage;
import studio.fantasyit.maid_storage_manager.storage.Target;
import studio.fantasyit.maid_storage_manager.storage.base.IMaidStorage;
import studio.fantasyit.maid_storage_manager.storage.base.IStorageContext;
import studio.fantasyit.maid_storage_manager.storage.base.IStorageInteractContext;
import studio.fantasyit.maid_storage_manager.util.MemoryUtil;
import studio.fantasyit.maid_storage_manager.util.StorageAccessUtil;

public class CoWorkChestView
extends MaidCheckRateTask {
    Target target;
    IStorageContext context;
    int currentHoldingContainerId = -1;
    int holdStamp = -1;

    public CoWorkChestView() {
        super(Map.of((MemoryModuleType)MemoryModuleRegistry.CO_WORK_TARGET_STORAGE.get(), MemoryStatus.VALUE_PRESENT));
        this.setMaxCheckRate(20);
    }

    protected boolean checkExtraStartConditions(ServerLevel worldIn, EntityMaid maid) {
        if (!super.checkExtraStartConditions(worldIn, maid)) {
            return false;
        }
        return MemoryUtil.getCurrentlyWorking(maid) == ScheduleBehavior.Schedule.CO_WORK;
    }

    protected boolean canStillUse(ServerLevel p_22545_, EntityMaid p_22546_, long p_22547_) {
        return this.context != null && !this.context.isDone();
    }

    protected void start(@NotNull ServerLevel level, @NotNull EntityMaid maid, long p_22542_) {
        ServerPlayer sp;
        Target interactedTarget = MemoryUtil.getCoWorkTargetStorage(maid);
        if (interactedTarget == null) {
            maid.m_6274_().m_21936_((MemoryModuleType)MemoryModuleRegistry.CO_WORK_TARGET_STORAGE.get());
            this.context = null;
            return;
        }
        List<Target> possibleTargets = StorageAccessUtil.findTargetRewrite(level, maid, interactedTarget.withoutSide(), false);
        if (possibleTargets.contains(interactedTarget)) {
            this.target = interactedTarget;
        } else if (possibleTargets.size() > 0) {
            this.target = possibleTargets.get(0);
        } else {
            this.context = null;
            return;
        }
        this.target = MemoryUtil.getViewedInventory(maid).ambitiousPos(level, this.target);
        MemoryUtil.getViewedInventory(maid).resetViewedInvForPos(this.target);
        MemoryUtil.getViewedInventory(maid).lockAmbitiousPos(level, this.target);
        @Nullable IMaidStorage storageType = MaidStorage.getInstance().getStorage(this.target.getType());
        this.context = storageType != null ? storageType.onStartView(level, maid, this.target) : null;
        if (this.context == null) {
            maid.m_6274_().m_21936_((MemoryModuleType)MemoryModuleRegistry.CO_WORK_TARGET_STORAGE.get());
            this.context = null;
            return;
        }
        this.currentHoldingContainerId = -1;
        LivingEntity livingEntity = maid.m_269323_();
        if (livingEntity instanceof ServerPlayer && (sp = (ServerPlayer)livingEntity).m_242612_()) {
            this.currentHoldingContainerId = sp.f_36096_.f_38840_;
        }
        this.context.start(maid, level, this.target);
        MemoryUtil.setLookAt(maid, this.target.pos);
        this.holdStamp = level.m_7654_().m_129921_();
    }

    protected void tick(ServerLevel p_22551_, EntityMaid maid, long p_22553_) {
        ServerPlayer sp;
        MemoryUtil.setLookAt(maid, this.target.pos);
        IStorageContext iStorageContext = this.context;
        if (iStorageContext instanceof IStorageInteractContext) {
            IStorageInteractContext context = (IStorageInteractContext)iStorageContext;
            context.tick(itemStack -> {
                MemoryUtil.getViewedInventory(maid).addItem(this.target, (ItemStack)itemStack);
                return itemStack;
            });
        }
        if (this.context.isDone() && (iStorageContext = maid.m_269323_()) instanceof ServerPlayer && (sp = (ServerPlayer)iStorageContext).m_242612_() && sp.f_36096_.f_38840_ == this.currentHoldingContainerId) {
            this.context.reset();
            MemoryUtil.getViewedInventory(maid).resetViewedInvForPos(this.target);
        }
    }

    protected void stop(ServerLevel p_22548_, EntityMaid maid, long p_22550_) {
        ServerPlayer sp;
        LivingEntity livingEntity;
        if (MemoryUtil.getCoWorkTargetStorage(maid) != null) {
            this.setNextCheckTickCount(5);
        }
        if (this.context != null) {
            this.context.finish();
            this.context = null;
        }
        if (this.target != null) {
            WorkCardItem.syncStorageOn(maid, this.target, this.holdStamp);
            MemoryUtil.getViewedInventory(maid).clearLock();
        }
        if ((livingEntity = maid.m_269323_()) instanceof ServerPlayer && (sp = (ServerPlayer)livingEntity).m_242612_()) {
            return;
        }
        maid.m_6274_().m_21936_((MemoryModuleType)MemoryModuleRegistry.CO_WORK_TARGET_STORAGE.get());
    }

    protected boolean m_7773_(long p_22537_) {
        return false;
    }
}

