/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.menu.container;

import java.util.Arrays;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.INBTSerializable;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.NotNull;
import studio.fantasyit.maid_storage_manager.menu.container.ISaveFilter;
import studio.fantasyit.maid_storage_manager.util.ItemStackUtil;

public class FilterContainer
implements Container,
INBTSerializable<ListTag> {
    private final AbstractContainerMenu menu;
    protected int size;
    ItemStack[] items;
    public MutableInt[] count;
    public MutableInt[] collected;
    public MutableInt[] done;

    public FilterContainer(int size, AbstractContainerMenu menu) {
        int i;
        this.menu = menu;
        this.size = size;
        this.items = new ItemStack[size];
        for (i = 0; i < size; ++i) {
            this.items[i] = ItemStack.f_41583_;
        }
        this.count = new MutableInt[size];
        this.collected = new MutableInt[size];
        this.done = new MutableInt[size];
        for (i = 0; i < size; ++i) {
            this.count[i] = new MutableInt(1);
            this.collected[i] = new MutableInt(0);
            this.done[i] = new MutableInt(0);
        }
    }

    public void reset() {
        for (int i = 0; i < this.size; ++i) {
            this.collected[i].setValue(0);
            this.done[i].setValue(0);
        }
        AbstractContainerMenu abstractContainerMenu = this.menu;
        if (abstractContainerMenu instanceof ISaveFilter) {
            ISaveFilter isf = (ISaveFilter)abstractContainerMenu;
            isf.save();
        }
    }

    public int m_6643_() {
        return this.size;
    }

    public boolean m_7983_() {
        return Arrays.stream(this.items).allMatch(ItemStack::m_41619_);
    }

    public ItemStack m_8020_(int p_18941_) {
        return this.items[p_18941_];
    }

    @NotNull
    public ItemStack m_7407_(int p_18942_, int p_18943_) {
        if (!this.items[p_18942_].m_41619_()) {
            ItemStack ret = this.items[p_18942_].m_41620_(p_18943_);
            this.m_6596_();
            return ret;
        }
        return ItemStack.f_41583_;
    }

    @NotNull
    public ItemStack m_8016_(int p_18951_) {
        if (!this.items[p_18951_].m_41619_()) {
            ItemStack itemStack = this.items[p_18951_];
            this.items[p_18951_] = ItemStack.f_41583_;
            return itemStack;
        }
        return ItemStack.f_41583_;
    }

    public void m_6836_(int p_18944_, ItemStack p_18945_) {
        this.setItemNoTrigger(p_18944_, p_18945_);
        this.m_6596_();
    }

    public void setItemNoTrigger(int p_18944_, ItemStack p_18945_) {
        this.items[p_18944_] = p_18945_.m_255036_(1);
        this.count[p_18944_].setValue(1);
    }

    public void m_6596_() {
        AbstractContainerMenu abstractContainerMenu = this.menu;
        if (abstractContainerMenu instanceof ISaveFilter) {
            ISaveFilter isf = (ISaveFilter)abstractContainerMenu;
            isf.save();
        }
    }

    public boolean m_6542_(Player p_18946_) {
        return true;
    }

    public void m_6211_() {
        Arrays.fill(this.items, ItemStack.f_41583_);
        for (int i = 0; i < this.size; ++i) {
            this.count[i].setValue(1);
        }
        this.m_6596_();
    }

    public ListTag serializeNBT() {
        ListTag tag = new ListTag();
        for (int i = 0; i < this.size; ++i) {
            CompoundTag tmp = new CompoundTag();
            tmp.m_128365_("item", (Tag)this.items[i].serializeNBT());
            tmp.m_128405_("requested", this.count[i].getValue().intValue());
            tag.add((Object)tmp);
        }
        return tag;
    }

    public void setCount(int index, int count) {
        if (count != this.count[index].getValue()) {
            this.count[index].setValue(count);
        }
    }

    public MutableInt getCountMutable(int index) {
        return this.count[index];
    }

    public int getCount(int index) {
        return this.count[index].getValue();
    }

    public void deserializeNBT(ListTag nbt) {
        for (int i = 0; i < this.size; ++i) {
            CompoundTag tmp = nbt.m_128728_(i);
            this.items[i] = ItemStackUtil.parseStack(tmp.m_128469_("item"));
            this.count[i].setValue(tmp.m_128451_("requested"));
            this.collected[i].setValue(tmp.m_128451_("collected"));
            this.done[i].setValue(tmp.m_128451_("done"));
        }
    }
}

