/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.menu.craft.common;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideData;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideRenderData;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideStepData;
import studio.fantasyit.maid_storage_manager.menu.container.FilterContainer;
import studio.fantasyit.maid_storage_manager.menu.container.FilterSlot;
import studio.fantasyit.maid_storage_manager.menu.container.ISaveFilter;
import studio.fantasyit.maid_storage_manager.menu.container.NoPlaceFilterSlot;
import studio.fantasyit.maid_storage_manager.menu.craft.base.ICraftGuiPacketReceiver;
import studio.fantasyit.maid_storage_manager.menu.craft.common.CommonStepDataContainer;
import studio.fantasyit.maid_storage_manager.network.CraftGuideGuiPacket;
import studio.fantasyit.maid_storage_manager.registry.GuiRegistry;
import studio.fantasyit.maid_storage_manager.util.ItemStackUtil;

public class CommonCraftMenu
extends AbstractContainerMenu
implements ISaveFilter,
ICraftGuiPacketReceiver {
    Player player;
    ItemStack target;
    CraftGuideData craftGuideData;
    List<CommonStepDataContainer> steps;
    List<List<FilterSlot>> pageSlots = new ArrayList<List<FilterSlot>>();
    List<NoPlaceFilterSlot> targetBlockSlots = new ArrayList<NoPlaceFilterSlot>();
    public int page = 0;
    private static final int[] SLOT_Y = new int[]{28, 71, 114};
    private static final int[] SLOT_X = new int[]{38, 56, 74, 94, 113};

    public CommonCraftMenu(int p_38852_, Player player) {
        super((MenuType)GuiRegistry.CRAFT_GUIDE_MENU_COMMON.get(), p_38852_);
        this.player = player;
        this.target = player.m_21205_();
        this.craftGuideData = CraftGuideData.fromItemStack(this.target);
        this.steps = new ArrayList<CommonStepDataContainer>();
        for (int i = 0; i < this.craftGuideData.getSteps().size(); ++i) {
            CraftGuideStepData step = this.craftGuideData.getSteps().get(i);
            this.steps.add(new CommonStepDataContainer(step, (AbstractContainerMenu)this));
        }
        this.addFilterSlots();
        this.addPlayerSlots();
        this.addSpecialSlots();
    }

    private void addFilterSlots() {
        for (int i = 0; i < this.craftGuideData.getSteps().size(); ++i) {
            FilterSlot slot;
            CommonStepDataContainer commonStepDataContainer = this.steps.get(i);
            int index = this.pageSlots.size();
            this.pageSlots.add(new ArrayList());
            int c = 0;
            for (int j = 0; j < 3; ++j) {
                slot = (FilterSlot)this.m_38897_(new FilterSlot(commonStepDataContainer, c++, SLOT_X[j], SLOT_Y[i % 3]));
                this.pageSlots.get(index).add(slot);
                if (j == 1 && this.steps.get((int)i).inputCount > 0 && this.steps.get((int)i).outputCount > 0) {
                    slot.setActive(false);
                }
                if (index < 3) continue;
                slot.setActive(false);
            }
            BlockState state = this.craftGuideData.getStepByIdx(i).getStorage().getBlockStateInLevel(this.player.m_9236_());
            slot = (NoPlaceFilterSlot)this.m_38897_(new NoPlaceFilterSlot(SLOT_X[4], SLOT_Y[i % 3], state.m_60734_().m_5456_().m_7968_(), i));
            this.targetBlockSlots.add((NoPlaceFilterSlot)slot);
            if (index < 3) continue;
            slot.setActive(false);
        }
    }

    private void addPlayerSlots() {
        int i;
        int cellHeight = 18;
        int cellWidth = 18;
        int startY = 164;
        int startX = 8;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)this.player.m_150109_(), 9 + i * 9 + j, 8 + j * 18, 164 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)this.player.m_150109_(), i, 8 + i * 18, 222));
        }
    }

    private void addSpecialSlots() {
        for (int i = 0; i < this.craftGuideData.getSteps().size(); ++i) {
            CommonStepDataContainer commonStepDataContainer = this.steps.get(i);
            int j = 0;
            while (j < 3) {
                int finalJ = j++;
                this.m_38895_(new SimpleSlot(t -> commonStepDataContainer.setCount(finalJ, (int)t), () -> commonStepDataContainer.getCount(finalJ)));
            }
        }
        this.m_38895_(new SimpleSlot(t -> {
            if (this.page != t) {
                this.setPage((int)t);
            }
        }, () -> this.page));
    }

    /*
     * Enabled aggressive block sorting
     */
    public void m_150399_(int slotId, int dragType, ClickType clickTypeIn, Player player) {
        Slot slot;
        Slot slot2;
        if (slotId >= 0 && (slot2 = this.m_38853_(slotId)) instanceof NoPlaceFilterSlot) {
            NoPlaceFilterSlot fs = (NoPlaceFilterSlot)slot2;
            fs.m_5852_(ItemStack.f_41583_);
            this.save();
            return;
        }
        if (slotId >= 0 && (slot = this.m_38853_(slotId)) instanceof FilterSlot) {
            FilterSlot fs = (FilterSlot)slot;
            slot = fs.f_40218_;
            if (slot instanceof CommonStepDataContainer) {
                ItemStack insert;
                CommonStepDataContainer container = (CommonStepDataContainer)slot;
                int slot3 = fs.m_150661_();
                if (clickTypeIn == ClickType.THROW) {
                    return;
                }
                ItemStack held = this.m_142621_();
                if (clickTypeIn == ClickType.CLONE) {
                    if (!player.m_7500_()) return;
                    if (!held.m_41619_()) return;
                    ItemStack stackInSlot = container.m_8020_(slot3).m_41777_();
                    stackInSlot.m_41764_(stackInSlot.m_41741_());
                    this.m_142503_(stackInSlot);
                    this.save();
                    return;
                }
                if (held.m_41619_()) {
                    insert = ItemStack.f_41583_;
                } else {
                    insert = held.m_41777_();
                    insert.m_41764_(1);
                }
                container.setItemNoTrigger(slot3, insert);
                container.setCount(slot3, 1);
                this.m_38853_(slotId).m_6654_();
                this.save();
                return;
            }
        }
        super.m_150399_(slotId, dragType, clickTypeIn, player);
    }

    public void m_6199_(Container p_38868_) {
        super.m_6199_(p_38868_);
        this.save();
    }

    @NotNull
    public ItemStack m_7648_(Player p_38941_, int p_38942_) {
        Slot slot = this.m_38853_(p_38942_);
        if (slot.m_6657_()) {
            if (slot instanceof FilterSlot) {
                FilterSlot fs = (FilterSlot)slot;
                fs.m_5852_(ItemStack.f_41583_);
            } else {
                boolean found = false;
                FilterContainer target = null;
                int toPlace = 0;
                for (int i = 0; i < this.steps.size(); ++i) {
                    CraftGuideStepData step = this.steps.get((int)i).step;
                    for (int j = 0; j < this.steps.get(i).m_6643_(); ++j) {
                        if (this.steps.get(i).m_8020_(j).m_41619_()) {
                            if (target != null) continue;
                            target = this.steps.get(i);
                            toPlace = j;
                            continue;
                        }
                        if (!ItemStackUtil.isSameInCrafting(this.steps.get(i).m_8020_(j), slot.m_7993_())) continue;
                        found = true;
                    }
                }
                if (!found && target != null) {
                    target.setItemNoTrigger(toPlace, slot.m_7993_().m_255036_(1));
                    this.save();
                }
            }
        }
        return ItemStack.f_41583_;
    }

    public boolean m_6875_(Player player) {
        return player.m_21205_() == this.target;
    }

    public boolean m_5622_(Slot p_38945_) {
        return !(p_38945_ instanceof FilterSlot);
    }

    @Override
    public void save() {
        if (this.player.m_9236_().f_46443_) {
            return;
        }
        for (CommonStepDataContainer commonStepDataContainer : this.steps) {
            commonStepDataContainer.save();
        }
        this.craftGuideData.saveToItemStack(this.target);
        CraftGuideRenderData.recalculateItemStack(this.target);
    }

    @Override
    public void handleGuiPacket(CraftGuideGuiPacket.Type type, int key, int value, @Nullable CompoundTag data) {
        switch (type) {
            case PAGE_UP: {
                this.setPage(this.page - 1);
                break;
            }
            case PAGE_DOWN: {
                this.setPage(this.page + 1);
                break;
            }
            case REMOVE: {
                this.pageSlots.get(key).forEach(slot -> slot.setActive(false));
                this.targetBlockSlots.remove(key);
                this.pageSlots.remove(key);
                this.steps.remove(key);
                this.craftGuideData.getSteps().remove(key);
                if (this.page * 3 >= this.steps.size()) {
                    this.setPage(this.page - 1);
                }
                this.save();
                break;
            }
            case DOWN: {
                if (key >= this.steps.size() - 1) break;
                this.swapStep(key, key + 1);
                break;
            }
            case UP: {
                if (key <= 0) break;
                this.swapStep(key, key - 1);
                break;
            }
            case SET_MODE: {
                if (data == null) break;
                ResourceLocation action = new ResourceLocation(data.m_128461_("ns"), data.m_128461_("id"));
                this.steps.get(key).setAction(action);
                this.save();
                break;
            }
            case OPTIONAL: {
                this.steps.get((int)key).optional = !this.steps.get((int)key).optional;
                this.save();
                break;
            }
            case SET_ITEM: {
                if (data == null) break;
                this.m_38853_(key).m_5852_(ItemStackUtil.parseStack(data));
                this.save();
                break;
            }
            case COUNT: {
                Container container = this.m_38853_((int)key).f_40218_;
                if (!(container instanceof CommonStepDataContainer)) break;
                CommonStepDataContainer commonStepDataContainer = (CommonStepDataContainer)container;
                commonStepDataContainer.setCount(this.m_38853_(key).m_150661_(), value);
                commonStepDataContainer.m_6596_();
                break;
            }
            case EXTRA: {
                if (data == null) break;
                this.steps.get((int)key).step.setExtraData(data);
                this.save();
                break;
            }
            case SIDE: {
                this.steps.get((int)key).step.storage.side = value == -1 ? null : Direction.values()[value];
                this.save();
                break;
            }
            case SET_ALL_INPUT: {
                ListTag inputTag = data.m_128437_("inputs", 10);
                ListTag outputTag = data.m_128437_("outputs", 10);
                int inputId = 0;
                int outputId = 0;
                for (CommonStepDataContainer step : this.steps) {
                    int i;
                    for (i = 0; i < step.step.actionType.inputCount(); ++i) {
                        if (inputId >= inputTag.size()) continue;
                        ItemStack tmp = ItemStackUtil.parseStack(inputTag.m_128728_(inputId));
                        step.setItemNoTrigger(i, tmp);
                        step.setCount(i, tmp.m_41613_());
                        ++inputId;
                    }
                    for (i = 0; i < step.step.actionType.outputCount(); ++i) {
                        if (outputId >= outputTag.size()) continue;
                        int inputOffset = step.padCount + step.inputCount;
                        ItemStack tmp = ItemStackUtil.parseStack(outputTag.m_128728_(outputId));
                        step.setItemNoTrigger(inputOffset + i, tmp);
                        step.setCount(inputOffset + i, tmp.m_41613_());
                        ++outputId;
                    }
                }
                this.save();
            }
        }
        this.recalculateSlots();
    }

    private void recalculateSlots() {
        for (int i = 0; i < this.steps.size(); ++i) {
            List<FilterSlot> filterSlots = this.pageSlots.get(i);
            for (FilterSlot filterSlot : filterSlots) {
                filterSlot.f_40221_ = SLOT_Y[i % 3];
                filterSlot.setActive(this.isIdCurrentPage(i));
            }
            this.targetBlockSlots.get((int)i).f_40221_ = SLOT_Y[i % 3];
            if (this.steps.get((int)i).inputCount <= 0 || this.steps.get((int)i).outputCount <= 0) continue;
            this.pageSlots.get(i).get(1).setActive(false);
        }
    }

    private void swapStep(int i, int j) {
        if (i == j) {
            return;
        }
        CommonStepDataContainer tmpStep = this.steps.get(i);
        this.steps.set(i, this.steps.get(j));
        this.steps.set(j, tmpStep);
        List<FilterSlot> tmpPageSlot = this.pageSlots.get(i);
        this.pageSlots.set(i, this.pageSlots.get(j));
        this.pageSlots.set(j, tmpPageSlot);
        CraftGuideStepData tmpStepData = this.craftGuideData.getSteps().get(i);
        this.craftGuideData.getSteps().set(i, this.craftGuideData.getSteps().get(j));
        this.craftGuideData.getSteps().set(j, tmpStepData);
        NoPlaceFilterSlot noPlaceFilterSlot = this.targetBlockSlots.get(i);
        this.targetBlockSlots.set(i, this.targetBlockSlots.get(j));
        this.targetBlockSlots.set(j, noPlaceFilterSlot);
        this.save();
    }

    private void setPage(int page) {
        if (page * 3 - 3 >= this.steps.size()) {
            page = this.steps.size() / 3;
        }
        if (page < 0) {
            page = 0;
        }
        this.page = page;
        this.recalculateSlots();
    }

    public boolean isIdCurrentPage(int id) {
        return id >= this.page * 3 && id < this.page * 3 + 3;
    }

    public static class SimpleSlot
    extends DataSlot {
        Consumer<Integer> set;
        Supplier<Integer> get;

        public SimpleSlot(Consumer<Integer> set, Supplier<Integer> get) {
            this.set = set;
            this.get = get;
        }

        public int m_6501_() {
            return this.get.get();
        }

        public void m_6422_(int p_39402_) {
            this.set.accept(p_39402_);
        }
    }
}

