/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.menu.craft.common;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.PacketDistributor;
import org.anti_ad.mc.ipn.api.IPNIgnore;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.fantasyit.maid_storage_manager.craft.action.CraftAction;
import studio.fantasyit.maid_storage_manager.craft.context.common.CommonIdleAction;
import studio.fantasyit.maid_storage_manager.menu.base.AbstractFilterScreen;
import studio.fantasyit.maid_storage_manager.menu.base.ImageAsset;
import studio.fantasyit.maid_storage_manager.menu.container.FilterSlot;
import studio.fantasyit.maid_storage_manager.menu.container.NoPlaceFilterSlot;
import studio.fantasyit.maid_storage_manager.menu.container.SelectButtonWidget;
import studio.fantasyit.maid_storage_manager.menu.craft.base.ICraftGuiPacketReceiver;
import studio.fantasyit.maid_storage_manager.menu.craft.common.CommonActionSelectionWidget;
import studio.fantasyit.maid_storage_manager.menu.craft.common.CommonCraftAssets;
import studio.fantasyit.maid_storage_manager.menu.craft.common.CommonCraftMenu;
import studio.fantasyit.maid_storage_manager.menu.craft.common.CommonStepDataContainer;
import studio.fantasyit.maid_storage_manager.network.CraftGuideGuiPacket;
import studio.fantasyit.maid_storage_manager.network.Network;
import studio.fantasyit.maid_storage_manager.storage.Target;
import studio.fantasyit.maid_storage_manager.util.ItemStackUtil;
import yalter.mousetweaks.api.MouseTweaksDisableWheelTweak;

@MouseTweaksDisableWheelTweak
@IPNIgnore
public class CommonCraftScreen
extends AbstractFilterScreen<CommonCraftMenu>
implements ICraftGuiPacketReceiver {
    private final ResourceLocation background = new ResourceLocation("maid_storage_manager", "textures/gui/craft/type/common.png");
    public final List<HashMap<BUTTON_TYPE_COMMON, SelectButtonWidget<?>>> buttonsByRow = new ArrayList();
    public final List<EditBox> editBoxes = new ArrayList<EditBox>();
    public final List<HashMap<BUTTON_TYPE_SPECIAL, AbstractButton>> otherButton = new ArrayList<HashMap<BUTTON_TYPE_SPECIAL, AbstractButton>>();
    public final List<List<Integer>> buttonYOffset = new ArrayList<List<Integer>>();
    SelectButtonWidget<?> pageUpBtn;
    SelectButtonWidget<?> pageDownBtn;
    CommonActionSelectionWidget actionSelector;
    private static final int[] SLOT_Y = new int[]{28, 71, 114};

    public CommonCraftScreen(CommonCraftMenu p_97741_, Inventory p_97742_, Component p_97743_) {
        super(p_97741_, p_97742_, p_97743_);
        this.f_97726_ = 176;
        this.f_97727_ = 245;
        this.f_97731_ = this.f_97727_ - 94;
        this.f_97730_ = 8;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.addButtons();
    }

    private void addButtons() {
        this.buttonsByRow.clear();
        this.buttonYOffset.clear();
        this.otherButton.clear();
        this.editBoxes.clear();
        for (int i = 0; i < ((CommonCraftMenu)this.f_97732_).steps.size(); ++i) {
            HashMap objects = new HashMap();
            ArrayList<Integer> yOffsets = new ArrayList<Integer>();
            this.addActionButton(objects, yOffsets, SLOT_Y[i % 3] - 5, i);
            this.addSortButtons(objects, yOffsets, SLOT_Y[i % 3] - 5, i);
            this.addOptionButtons(objects, yOffsets, SLOT_Y[i % 3] - 5, i);
            this.addTimeButton(objects, yOffsets, SLOT_Y[i % 3] - 5, i);
            HashMap<BUTTON_TYPE_SPECIAL, AbstractButton> objectsSpecial = new HashMap<BUTTON_TYPE_SPECIAL, AbstractButton>();
            this.addBlockButton(objectsSpecial, yOffsets, SLOT_Y[i % 3] - 5, i);
            this.otherButton.add(objectsSpecial);
            this.buttonsByRow.add(objects);
            this.buttonYOffset.add(yOffsets);
        }
        this.addPageButton();
        this.updateButtons();
    }

    private void addBlockButton(HashMap<BUTTON_TYPE_SPECIAL, AbstractButton> objects, ArrayList<Integer> yOffsets, int sy, final int i) {
        yOffsets.add(1);
        objects.put(BUTTON_TYPE_SPECIAL.BLOCK, (AbstractButton)this.m_142416_((GuiEventListener)new AbstractButton(this.f_97735_ + ((CommonCraftMenu)this.f_97732_).targetBlockSlots.get((int)i).f_40220_ + 1, this.f_97736_ + ((CommonCraftMenu)this.f_97732_).targetBlockSlots.get((int)i).f_40221_ - 3, 20, 20, (Component)Component.m_237113_((String)"")){

            protected void m_168797_(NarrationElementOutput p_259858_) {
                if (((CommonCraftMenu)((CommonCraftScreen)CommonCraftScreen.this).f_97732_).targetBlockSlots.size() > i && ((CommonCraftMenu)((CommonCraftScreen)CommonCraftScreen.this).f_97732_).steps.size() > i) {
                    p_259858_.m_169146_(NarratedElementType.HINT, ((CommonCraftMenu)((CommonCraftScreen)CommonCraftScreen.this).f_97732_).targetBlockSlots.get(i).m_7993_().m_41611_());
                    p_259858_.m_169146_(NarratedElementType.HINT, CommonCraftScreen.this.getStorageSideTranslate(((CommonCraftMenu)((CommonCraftScreen)CommonCraftScreen.this).f_97732_).steps.get((int)i).step.storage));
                }
            }

            protected void m_87963_(GuiGraphics graphics, int x, int y, float p_282542_) {
                if (this.m_5953_(x, y)) {
                    graphics.m_280168_().m_85836_();
                    graphics.m_280168_().m_252880_(0.0f, 0.0f, 200.0f);
                    int n = this.m_252754_();
                    int n2 = this.m_252907_();
                    int n3 = this.m_252754_() + this.f_93618_;
                    int n4 = this.m_252907_();
                    Objects.requireNonNull(CommonCraftScreen.this.f_96547_);
                    graphics.m_280509_(n, n2, n3, n4 + 9, Integer.MIN_VALUE);
                    graphics.m_280430_(CommonCraftScreen.this.f_96547_, CommonCraftScreen.this.getStorageSideTranslate(((CommonCraftMenu)((CommonCraftScreen)CommonCraftScreen.this).f_97732_).steps.get((int)i).step.storage), this.m_252754_(), this.m_252907_(), -1);
                    graphics.m_280168_().m_85849_();
                }
            }

            public void m_5691_() {
                Optional<Direction> currentSide = ((CommonCraftMenu)((CommonCraftScreen)CommonCraftScreen.this).f_97732_).steps.get((int)i).step.storage.getSide();
                int nextOri = currentSide.isEmpty() ? 0 : (currentSide.get().ordinal() + 1 == Direction.values().length ? -1 : currentSide.get().ordinal() + 1);
                CommonCraftScreen.this.sendAndTriggerLocalPacket(new CraftGuideGuiPacket(CraftGuideGuiPacket.Type.SIDE, i, nextOri));
            }
        }));
    }

    private void addTimeButton(HashMap<BUTTON_TYPE_COMMON, SelectButtonWidget<?>> objects, ArrayList<Integer> yOffsets, int sy, int i1) {
        int dy = 24;
        yOffsets.add(dy);
        objects.put(BUTTON_TYPE_COMMON.TIME, (SelectButtonWidget)this.m_142416_((GuiEventListener)new SelectButtonWidget<Integer>(121, sy + dy - 1, value -> {
            CompoundTag extraData = ((CommonCraftMenu)this.f_97732_).steps.get((int)i1).step.getExtraData();
            int v = ((CommonCraftMenu)this.f_97732_).steps.get((int)i1).actionType.type().equals((Object)CommonIdleAction.TYPE) ? (extraData.m_128441_("u") ? extraData.m_128451_("u") : 0) : 0;
            if (value != null) {
                v = value == 0 ? 1 : 0;
                this.editBoxes.get(i1).m_93692_(true);
                int finalV = v;
                this.sendExtra(i1, t -> t.m_128405_("u", finalV));
            }
            return new SelectButtonWidget.Option<Integer>(v, CommonCraftAssets.SMALL_BUTTON, CommonCraftAssets.SMALL_BUTTON_HOVER, (Component)(v == 0 ? Component.m_237115_((String)"gui.maid_storage_manager.craft_guide.common.idle_tick") : Component.m_237115_((String)"gui.maid_storage_manager.craft_guide.common.idle_second")));
        }, this)));
        EditBox editBox = (EditBox)this.m_142416_((GuiEventListener)new EditBox(this.f_96547_, this.getGuiLeft() + 90, this.getGuiTop() + sy + dy, 30, 8, (Component)Component.m_237113_((String)"")));
        editBox.m_94144_("0");
        editBox.m_94182_(false);
        editBox.m_94199_(3);
        editBox.m_94153_(s -> StringUtils.isNumeric((CharSequence)s) && Integer.parseInt(s) <= 999);
        editBox.m_94151_(t -> this.sendExtra(i1, c -> c.m_128405_("time", Integer.parseInt(t))));
        this.editBoxes.add(editBox);
    }

    private void addActionButton(Map<BUTTON_TYPE_COMMON, SelectButtonWidget<?>> buttons, List<Integer> yOffsets, int sy, int i) {
        this.actionSelector = new CommonActionSelectionWidget(0, 0, this);
        this.m_7787_((GuiEventListener)this.actionSelector);
        buttons.put(BUTTON_TYPE_COMMON.ACTION, (SelectButtonWidget)this.m_142416_((GuiEventListener)new SelectButtonWidget<CraftAction>(94, SLOT_Y[i % 3], value -> {
            if (value == null) {
                value = ((CommonCraftMenu)this.f_97732_).craftGuideData.steps.get((int)i).actionType;
            } else {
                this.startSelectActionFor(i);
            }
            return new SelectButtonWidget.Option<CraftAction>((CraftAction)value, CommonCraftAssets.BUTTON_ACTION, CommonCraftAssets.BUTTON_ACTION_HOVER, CommonCraftAssets.translationForAction(value.type()));
        }, this)));
        yOffsets.add(0);
    }

    private void addOptionButtons(Map<BUTTON_TYPE_COMMON, SelectButtonWidget<?>> buttons, List<Integer> yOffsets, int sy, int i) {
        yOffsets.add(5);
        buttons.put(BUTTON_TYPE_COMMON.OPTIONAL, (SelectButtonWidget)this.m_142416_((GuiEventListener)new SelectButtonWidget<Boolean>(137, sy + 5, value -> {
            if (value == null) {
                value = !((CommonCraftMenu)this.f_97732_).steps.get((int)i).optional;
            } else {
                value = value == false;
                this.sendAndTriggerLocalPacket(new CraftGuideGuiPacket(CraftGuideGuiPacket.Type.OPTIONAL, i, value != false ? 1 : 0));
            }
            return new SelectButtonWidget.Option<Boolean>((Boolean)value, value != false ? CommonCraftAssets.BUTTON_OPTIONAL_POSI : CommonCraftAssets.BUTTON_OPTIONAL_NEGI, value != false ? CommonCraftAssets.BUTTON_OPTIONAL_POSI_HOVER : CommonCraftAssets.BUTTON_OPTIONAL_NEGI_HOVER, (Component)(value != false ? Component.m_237115_((String)"gui.maid_storage_manager.craft_guide.common.required") : Component.m_237115_((String)"gui.maid_storage_manager.craft_guide.common.optional")));
        }, this)));
    }

    private void addSortButtons(Map<BUTTON_TYPE_COMMON, SelectButtonWidget<?>> buttons, List<Integer> yOffsets, int sy, int i) {
        buttons.put(BUTTON_TYPE_COMMON.SORT_UP, (SelectButtonWidget)this.m_142416_((GuiEventListener)new SelectButtonWidget<Integer>(23, sy, value -> {
            if (value != null) {
                this.sendAndTriggerLocalPacket(new CraftGuideGuiPacket(CraftGuideGuiPacket.Type.UP, i));
            }
            return new SelectButtonWidget.Option<Integer>(1, CommonCraftAssets.BUTTON_UP, CommonCraftAssets.BUTTON_UP_HOVER, (Component)Component.m_237115_((String)"gui.maid_storage_manager.craft_guide.common.up"));
        }, this)));
        yOffsets.add(-5);
        buttons.put(BUTTON_TYPE_COMMON.SORT_REMOVE, (SelectButtonWidget)this.m_142416_((GuiEventListener)new SelectButtonWidget<Integer>(23, sy + 10, value -> {
            if (value != null) {
                this.sendAndTriggerLocalPacket(new CraftGuideGuiPacket(CraftGuideGuiPacket.Type.REMOVE, i));
            }
            return new SelectButtonWidget.Option<Integer>(1, CommonCraftAssets.BUTTON_REMOVE, CommonCraftAssets.BUTTON_REMOVE_HOVER, (Component)Component.m_237115_((String)"gui.maid_storage_manager.craft_guide.common.remove"));
        }, this)));
        yOffsets.add(5);
        buttons.put(BUTTON_TYPE_COMMON.SORT_DOWN, (SelectButtonWidget)this.m_142416_((GuiEventListener)new SelectButtonWidget<Integer>(23, sy + 23, value -> {
            if (value != null) {
                this.sendAndTriggerLocalPacket(new CraftGuideGuiPacket(CraftGuideGuiPacket.Type.DOWN, i));
            }
            return new SelectButtonWidget.Option<Integer>(1, CommonCraftAssets.BUTTON_DOWN, CommonCraftAssets.BUTTON_DOWN_HOVER, (Component)Component.m_237115_((String)"gui.maid_storage_manager.craft_guide.common.down"));
        }, this)));
        yOffsets.add(15);
    }

    private void addPageButton() {
        this.pageUpBtn = (SelectButtonWidget)this.m_142416_((GuiEventListener)new SelectButtonWidget<Integer>(122, 151, value -> {
            if (value != null) {
                this.sendAndTriggerLocalPacket(new CraftGuideGuiPacket(CraftGuideGuiPacket.Type.PAGE_UP, (int)value));
            }
            return new SelectButtonWidget.Option<Integer>(1, CommonCraftAssets.BUTTON_PREV_PAGE, CommonCraftAssets.BUTTON_PREV_PAGE_HOVER, (Component)Component.m_237115_((String)"gui.maid_storage_manager.craft_guide.common.page_up"));
        }, this));
        this.pageDownBtn = (SelectButtonWidget)this.m_142416_((GuiEventListener)new SelectButtonWidget<Integer>(140, 151, value -> {
            if (value != null) {
                this.sendAndTriggerLocalPacket(new CraftGuideGuiPacket(CraftGuideGuiPacket.Type.PAGE_DOWN, (int)value));
            }
            return new SelectButtonWidget.Option<Integer>(1, CommonCraftAssets.BUTTON_NEXT_PAGE, CommonCraftAssets.BUTTON_NEXT_PAGE_HOVER, (Component)Component.m_237115_((String)"gui.maid_storage_manager.craft_guide.common.page_down"));
        }, this));
    }

    private void sendAndTriggerLocalPacket(CraftGuideGuiPacket packet) {
        Network.INSTANCE.send(PacketDistributor.SERVER.noArg(), (Object)packet);
        ((CommonCraftMenu)this.f_97732_).handleGuiPacket(packet.type, packet.key, packet.value, packet.data);
        this.handleGuiPacket(packet.type, packet.key, packet.value, packet.data);
    }

    protected void m_7286_(GuiGraphics guiGraphics, float p_97788_, int p_97789_, int p_97790_) {
        this.m_280273_(guiGraphics);
        int relX = (this.f_96543_ - this.f_97726_) / 2;
        int relY = (this.f_96544_ - this.f_97727_) / 2;
        guiGraphics.m_280398_(this.background, relX, relY, 0, 0.0f, 0.0f, this.f_97726_, this.f_97727_, 256, 256);
        for (Slot slot : ((CommonCraftMenu)this.m_6262_()).f_38839_) {
            ImageAsset back;
            if (!(slot instanceof FilterSlot)) continue;
            FilterSlot filterSlot = (FilterSlot)slot;
            Container container = filterSlot.f_40218_;
            if (!(container instanceof CommonStepDataContainer)) continue;
            CommonStepDataContainer container2 = (CommonStepDataContainer)container;
            if (!filterSlot.m_6659_()) continue;
            if ((back = (switch (filterSlot.m_150661_()) {
                case 0 -> CommonCraftAssets.SLOT_L;
                case 1 -> {
                    if (container2.m_6643_() == 2) {
                        yield CommonCraftAssets.SLOT_M;
                    }
                    yield CommonCraftAssets.SLOT_R;
                }
                case 2 -> CommonCraftAssets.SLOT_R;
                default -> null;
            })) == null) continue;
            back.blit(guiGraphics, relX + slot.f_40220_ - 1, relY + slot.f_40221_ - 1);
        }
        this.renderSeparator(guiGraphics);
    }

    protected void m_280072_(@NotNull GuiGraphics graphics, int x, int y) {
        if (this.actionSelector.visible) {
            return;
        }
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_(0.0f, 0.0f, 400.0f);
        RenderSystem.enableDepthTest();
        if (((CommonCraftMenu)this.f_97732_).m_142621_().m_41619_()) {
            int inGuiX = x - this.getGuiLeft();
            int inGuiY = y - this.getGuiTop();
            for (Slot slot : ((CommonCraftMenu)this.m_6262_()).f_38839_) {
                FilterSlot filterSlot;
                if (slot.f_40220_ > inGuiX || slot.f_40220_ + 16 < inGuiX || slot.f_40221_ > inGuiY || slot.f_40221_ + 16 < inGuiY || !(slot instanceof FilterSlot) || !(filterSlot = (FilterSlot)slot).m_6659_()) continue;
                if (!filterSlot.m_7993_().m_41619_()) {
                    graphics.m_280153_(this.f_96547_, filterSlot.m_7993_(), x, y);
                }
                return;
            }
            this.m_6702_().forEach(renderable -> {
                SelectButtonWidget buttonWidget;
                if (renderable.m_5953_((double)x, (double)y) && renderable instanceof SelectButtonWidget && (buttonWidget = (SelectButtonWidget)((Object)renderable)).m_142518_()) {
                    graphics.m_280557_(this.f_96547_, buttonWidget.getTooltipComponent(), x, y);
                }
            });
        }
        super.m_280072_(graphics, x, y);
        graphics.m_280262_();
        graphics.m_280168_().m_85849_();
    }

    public void m_88315_(GuiGraphics graphics, int p_283661_, int p_281248_, float p_281886_) {
        RenderSystem.disableDepthTest();
        this.renderUnderLine(graphics);
        RenderSystem.disableDepthTest();
        this.renderBlockIndicator(graphics);
        RenderSystem.disableDepthTest();
        super.m_88315_(graphics, p_283661_, p_281248_, p_281886_);
        RenderSystem.disableDepthTest();
        this.renderNumberLabel(graphics);
        RenderSystem.disableDepthTest();
        this.renderButtonIcon(graphics);
        RenderSystem.disableDepthTest();
        this.renderArrow(graphics);
        RenderSystem.disableDepthTest();
        this.m_280072_(graphics, p_283661_, p_281248_);
        RenderSystem.disableDepthTest();
        this.actionSelector.m_88315_(graphics, p_283661_, p_281248_, p_281886_);
        RenderSystem.enableDepthTest();
    }

    private void renderUnderLine(@NotNull GuiGraphics graphics) {
        for (EditBox editBox : this.editBoxes) {
            if (!editBox.m_94213_()) continue;
            graphics.m_280218_(this.background, editBox.m_252754_(), editBox.m_252907_() + editBox.m_93694_(), 197, 100, editBox.m_5711_() + 1, 1);
        }
        graphics.m_280262_();
    }

    private void renderArrow(@NotNull GuiGraphics graphics) {
        for (int i = 0; i < ((CommonCraftMenu)this.f_97732_).steps.size(); ++i) {
            if (!((CommonCraftMenu)this.f_97732_).isIdCurrentPage(i) || ((CommonCraftMenu)this.f_97732_).steps.get((int)i).inputCount <= 0 || ((CommonCraftMenu)this.f_97732_).steps.get((int)i).outputCount <= 0) continue;
            CommonCraftAssets.ARROW.blit(graphics, this.getGuiLeft() + 59, this.getGuiTop() + SLOT_Y[i % 3] + 5);
        }
        graphics.m_280262_();
    }

    private void renderNumberLabel(@NotNull GuiGraphics graphics) {
        int relX = (this.f_96543_ - this.f_97726_) / 2;
        int relY = (this.f_96544_ - this.f_97727_) / 2;
        for (Slot slot : ((CommonCraftMenu)this.m_6262_()).f_38839_) {
            if (!(slot instanceof FilterSlot)) continue;
            FilterSlot filterSlot = (FilterSlot)slot;
            Container container = filterSlot.f_40218_;
            if (!(container instanceof CommonStepDataContainer)) continue;
            CommonStepDataContainer sdc = (CommonStepDataContainer)container;
            if (!filterSlot.m_6659_() || !filterSlot.m_6657_()) continue;
            int count = sdc.getCount(filterSlot.m_150661_());
            String text = String.valueOf(count);
            if (count == -1) {
                text = "*";
            }
            graphics.m_280168_().m_85836_();
            graphics.m_280168_().m_85841_(0.6f, 0.6f, 1.0f);
            graphics.m_280168_().m_252880_(0.0f, 0.0f, 350.0f);
            RenderSystem.enableDepthTest();
            int n = (int)(((double)(relX + filterSlot.f_40220_ + 16) - (double)this.f_96547_.m_92895_(text) * 0.6) / (double)0.6f);
            double d = relY + filterSlot.f_40221_ + 16;
            Objects.requireNonNull(this.f_96547_);
            graphics.m_280488_(this.f_96547_, text, n, (int)((d - 9.0 * 0.6) / (double)0.6f), 0xFFFFFF);
            graphics.m_280168_().m_85849_();
        }
        graphics.m_280262_();
    }

    private void renderButtonIcon(@NotNull GuiGraphics graphics) {
        for (int i = 0; i < this.buttonsByRow.size(); ++i) {
            if (!((CommonCraftMenu)this.f_97732_).isIdCurrentPage(i)) continue;
            SelectButtonWidget<?> cab = this.buttonsByRow.get(i).get((Object)BUTTON_TYPE_COMMON.ACTION);
            CommonCraftAssets.imageForAction(((CraftAction)cab.getData()).type()).blit(graphics, cab.m_252754_() + 2, cab.m_252907_() + 2);
            SelectButtonWidget<?> timeBtn = this.buttonsByRow.get(i).get((Object)BUTTON_TYPE_COMMON.TIME);
            if (!timeBtn.isVisible()) continue;
            graphics.m_280168_().m_85836_();
            graphics.m_280168_().m_252880_((float)(timeBtn.m_252754_() + 3), (float)(timeBtn.m_252907_() + 3), 0.0f);
            graphics.m_280168_().m_85841_(0.7f, 0.7f, 1.0f);
            graphics.m_280488_(this.f_96547_, (Integer)timeBtn.getData() == 0 ? "T" : "S", 0, 0, 0xFFFFFF);
            RenderSystem.disableDepthTest();
            graphics.m_280168_().m_85849_();
        }
        graphics.m_280262_();
    }

    private void renderBlockIndicator(@NotNull GuiGraphics graphics) {
        graphics.m_280168_().m_85836_();
        float scale = 1.3f;
        graphics.m_280168_().m_85841_(scale, scale, 1.0f);
        for (int i = 0; i < ((CommonCraftMenu)this.f_97732_).targetBlockSlots.size(); ++i) {
            if (!((CommonCraftMenu)this.f_97732_).isIdCurrentPage(i)) continue;
            RenderSystem.disableDepthTest();
            graphics.m_280480_(((CommonCraftMenu)this.f_97732_).targetBlockSlots.get(i).m_7993_(), (int)((float)(this.f_97735_ + ((CommonCraftMenu)this.f_97732_).targetBlockSlots.get((int)i).f_40220_ + 1) / scale), (int)(((float)(this.f_97736_ + ((CommonCraftMenu)this.f_97732_).targetBlockSlots.get((int)i).f_40221_) - (scale - 1.0f) * 18.0f / 2.0f) / scale));
        }
        graphics.m_280262_();
        graphics.m_280168_().m_85849_();
    }

    private void renderSeparator(GuiGraphics graphics) {
        int relX = (this.f_96543_ - this.f_97726_) / 2;
        int relY = (this.f_96544_ - this.f_97727_) / 2;
        int lineCount = ((CommonCraftMenu)this.f_97732_).steps.size() - ((CommonCraftMenu)this.f_97732_).page * 3;
        for (int i = 0; i < lineCount && i < 2; ++i) {
            CommonCraftAssets.SEPARATOR.blit(graphics, relX + 24, relY + SLOT_Y[i] + 28);
        }
        graphics.m_280262_();
    }

    public boolean m_6050_(double x, double y, double p_94688_) {
        EditBox eb;
        Optional child;
        Object count;
        if (this.actionSelector.visible) {
            return this.actionSelector.m_6050_(x, y, p_94688_);
        }
        @Nullable Slot slot = this.getSlotUnderMouse();
        if (slot instanceof FilterSlot) {
            FilterSlot filterSlot = (FilterSlot)slot;
            Container container = filterSlot.f_40218_;
            if (container instanceof CommonStepDataContainer) {
                CommonStepDataContainer sdc = (CommonStepDataContainer)container;
                count = new MutableInt(sdc.getCount(filterSlot.m_150661_()));
                int dv = (int)(Math.abs(p_94688_) / p_94688_);
                if (InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)340)) {
                    dv *= 10;
                }
                if (dv > 0) {
                    if (count.addAndGet(dv) == 0) {
                        count.addAndGet(1);
                    }
                } else if (count.addAndGet(dv) <= 0) {
                    count.setValue(1);
                }
                this.sendAndTriggerLocalPacket(new CraftGuideGuiPacket(CraftGuideGuiPacket.Type.COUNT, filterSlot.f_40219_, count.getValue()));
                return true;
            }
        }
        if ((child = this.m_94729_(x, y)).isPresent() && (count = child.get()) instanceof EditBox && (eb = (EditBox)count).m_94213_()) {
            int dv = (int)(Math.abs(p_94688_) / p_94688_);
            if (InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)340)) {
                dv *= 10;
            }
            Integer ov = Integer.valueOf(eb.m_94155_());
            eb.m_94144_(String.valueOf(ov + dv));
            return true;
        }
        if (x - (double)this.getGuiLeft() > 14.0 && y - (double)this.getGuiTop() > 18.0 && x - (double)this.getGuiLeft() < 158.0 && y - (double)this.getGuiTop() < 145.0) {
            if (p_94688_ < 0.0 && ((CommonCraftMenu)this.f_97732_).page < (((CommonCraftMenu)this.f_97732_).steps.size() + 2) / 3 - 1) {
                this.sendAndTriggerLocalPacket(new CraftGuideGuiPacket(CraftGuideGuiPacket.Type.PAGE_DOWN, 0));
            }
            if (p_94688_ > 0.0 && ((CommonCraftMenu)this.f_97732_).page > 0) {
                this.sendAndTriggerLocalPacket(new CraftGuideGuiPacket(CraftGuideGuiPacket.Type.PAGE_UP, 0));
            }
        }
        return super.m_6050_(x, y, p_94688_);
    }

    @Override
    public void accept(FilterSlot slot, ItemStack item) {
        if (slot instanceof NoPlaceFilterSlot) {
            return;
        }
        if (!slot.m_6659_()) {
            return;
        }
        slot.m_5852_(item);
        this.sendAndTriggerLocalPacket(new CraftGuideGuiPacket(CraftGuideGuiPacket.Type.SET_ITEM, slot.f_40219_, 0, ItemStackUtil.saveStack(item)));
    }

    @Override
    public List<FilterSlot> getSlots() {
        return ((CommonCraftMenu)this.f_97732_).f_38839_.stream().filter(slot -> {
            if (!(slot instanceof FilterSlot)) return false;
            FilterSlot fs = (FilterSlot)((Object)slot);
            if (slot instanceof NoPlaceFilterSlot) return false;
            if (!slot.m_6659_()) return false;
            return true;
        }).map(slot -> (FilterSlot)((Object)slot)).toList();
    }

    @Override
    public void handleGuiPacket(CraftGuideGuiPacket.Type type, int key, int value, @Nullable CompoundTag data) {
        switch (type) {
            case REMOVE: {
                this.buttonsByRow.get(this.buttonsByRow.size() - 1).values().forEach(button -> button.setVisible(false));
                this.otherButton.get(this.otherButton.size() - 1).values().forEach(button -> {
                    button.f_93623_ = false;
                });
                this.buttonsByRow.remove(this.buttonsByRow.size() - 1);
            }
        }
        this.updateButtons();
    }

    private void updateButtons() {
        for (HashMap<BUTTON_TYPE_COMMON, SelectButtonWidget<?>> buttons : this.buttonsByRow) {
            buttons.get((Object)BUTTON_TYPE_COMMON.ACTION).setOption(null);
            buttons.get((Object)BUTTON_TYPE_COMMON.OPTIONAL).setOption(null);
        }
        for (int i = 0; i < ((CommonCraftMenu)this.f_97732_).steps.size(); ++i) {
            HashMap<BUTTON_TYPE_COMMON, SelectButtonWidget<?>> buttons;
            buttons = this.buttonsByRow.get(i);
            int finalI = i;
            buttons.values().forEach(button -> button.setVisible(((CommonCraftMenu)this.f_97732_).isIdCurrentPage(finalI)));
            this.otherButton.get(i).values().forEach(button -> {
                button.f_93623_ = ((CommonCraftMenu)this.f_97732_).isIdCurrentPage(finalI);
            });
            if (((CommonCraftMenu)this.f_97732_).steps.get((int)i).actionType.type() == CommonIdleAction.TYPE) {
                buttons.get((Object)BUTTON_TYPE_COMMON.TIME).setVisible(((CommonCraftMenu)this.f_97732_).isIdCurrentPage(i));
                buttons.get((Object)BUTTON_TYPE_COMMON.TIME).setOption(null);
                String newTime = String.valueOf(((CommonCraftMenu)this.f_97732_).steps.get((int)i).step.extraData.m_128451_("time"));
                if (!newTime.equals(this.editBoxes.get(i).m_94155_())) {
                    this.editBoxes.get(i).m_94144_(newTime);
                }
                this.editBoxes.get((int)i).f_93624_ = ((CommonCraftMenu)this.f_97732_).isIdCurrentPage(i);
                this.editBoxes.get((int)i).f_93623_ = ((CommonCraftMenu)this.f_97732_).isIdCurrentPage(i);
                continue;
            }
            buttons.get((Object)BUTTON_TYPE_COMMON.TIME).setVisible(false);
            this.editBoxes.get((int)i).f_93624_ = false;
            this.editBoxes.get((int)i).f_93623_ = false;
        }
        this.pageUpBtn.setVisible(((CommonCraftMenu)this.f_97732_).page > 0);
        this.pageDownBtn.setVisible(((CommonCraftMenu)this.f_97732_).page < (((CommonCraftMenu)this.f_97732_).steps.size() + 2) / 3 - 1);
    }

    protected void m_181908_() {
        super.m_181908_();
        for (EditBox eb : this.editBoxes) {
            Object value = eb.m_94155_();
            if (((String)value).length() < 3) {
                value = (String)value + "_";
            }
            int width1 = Math.max(Math.min(this.f_96547_.m_92895_((String)value), 30), 8);
            eb.m_93674_(width1);
            eb.m_252865_(this.getGuiLeft() + 90 + 30 - width1);
        }
    }

    private void sendExtra(int i, @Nullable Consumer<CompoundTag> transformer) {
        CompoundTag tag = new CompoundTag();
        if (((CommonCraftMenu)this.f_97732_).steps.get((int)i).actionType.type().equals((Object)CommonIdleAction.TYPE)) {
            tag.m_128405_("time", Integer.parseInt(this.editBoxes.get(i).m_94155_()));
            tag.m_128405_("u", ((Integer)this.buttonsByRow.get(i).get((Object)BUTTON_TYPE_COMMON.TIME).getData()).intValue());
        }
        if (transformer != null) {
            transformer.accept(tag);
        }
        this.sendAndTriggerLocalPacket(new CraftGuideGuiPacket(CraftGuideGuiPacket.Type.EXTRA, i, 0, tag));
    }

    private Component getStorageSideTranslate(Target target) {
        return Component.m_237110_((String)"gui.maid_storage_manager.craft_guide.common.side", (Object[])new Object[]{Component.m_237115_((String)("gui.maid_storage_manager.craft_guide.common.side_" + target.getSide().map(t -> t.name().toLowerCase()).orElse("none")))});
    }

    private void startSelectActionFor(int i) {
        SelectButtonWidget<?> btn = this.buttonsByRow.get(i).get((Object)BUTTON_TYPE_COMMON.ACTION);
        this.actionSelector.setSelectedAction((CraftAction)btn.getData());
        this.actionSelector.setCallback(value -> {
            CompoundTag data = new CompoundTag();
            data.m_128359_("ns", value.type().m_135827_());
            data.m_128359_("id", value.type().m_135815_());
            this.sendAndTriggerLocalPacket(new CraftGuideGuiPacket(CraftGuideGuiPacket.Type.SET_MODE, i, data));
            btn.setOption(null);
        });
        this.actionSelector.expandFrom(btn);
    }

    public boolean m_6375_(double p_97748_, double p_97749_, int p_97750_) {
        if (this.actionSelector.visible) {
            if (!this.actionSelector.m_5953_(p_97748_, p_97749_)) {
                this.actionSelector.hide();
            } else {
                return this.actionSelector.m_6375_(p_97748_, p_97749_, p_97750_);
            }
        }
        return super.m_6375_(p_97748_, p_97749_, p_97750_);
    }

    protected static enum BUTTON_TYPE_SPECIAL {
        BLOCK;

    }

    protected static enum BUTTON_TYPE_COMMON {
        ACTION,
        SORT_UP,
        SORT_REMOVE,
        SORT_DOWN,
        OPTIONAL,
        TIME;

    }
}

