/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.recipe;

import com.google.gson.JsonObject;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import oshi.util.tuples.Pair;
import studio.fantasyit.maid_storage_manager.items.RequestListItem;
import studio.fantasyit.maid_storage_manager.registry.ItemRegistry;

public class CopyConfigRecipe
extends ShapelessRecipe {
    public CopyConfigRecipe(ShapelessRecipe recipe) {
        super(recipe.m_6423_(), recipe.m_6076_(), recipe.m_245232_(), recipe.m_8043_((RegistryAccess)RegistryAccess.f_243945_), recipe.m_7527_());
    }

    @Nullable
    protected Pair<ItemStack, ItemStack> getToCopyItem(CraftingContainer inv) {
        ItemStack first = null;
        ItemStack second = null;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (first == null) {
                first = stack;
                continue;
            }
            if (second == null) {
                second = stack;
                continue;
            }
            return null;
        }
        if (first == null || second == null) {
            return null;
        }
        return new Pair(first, second);
    }

    @NotNull
    public ItemStack m_5874_(@NotNull CraftingContainer inv, @NotNull RegistryAccess p_267165_) {
        Pair<ItemStack, ItemStack> toCopyItem = this.getToCopyItem(inv);
        if (toCopyItem != null) {
            return this.applyCopy(((ItemStack)toCopyItem.getB()).m_41777_(), (ItemStack)toCopyItem.getA());
        }
        return ItemStack.f_41583_;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer p_44004_) {
        NonNullList nonnulllist = NonNullList.m_122780_((int)p_44004_.m_6643_(), (Object)ItemStack.f_41583_);
        Pair<ItemStack, ItemStack> toCopyItem = this.getToCopyItem(p_44004_);
        if (toCopyItem == null) {
            return nonnulllist;
        }
        for (int i = 0; i < p_44004_.m_6643_(); ++i) {
            if (p_44004_.m_8020_(i).m_41619_()) continue;
            ItemStack itemStack = p_44004_.m_8020_(i).m_41777_();
            nonnulllist.set(i, (Object)itemStack);
            break;
        }
        return nonnulllist;
    }

    public ItemStack applyCopy(ItemStack newStack, ItemStack toCopy) {
        if (newStack.m_150930_((Item)ItemRegistry.STORAGE_DEFINE_BAUBLE.get()) || newStack.m_150930_((Item)ItemRegistry.FILTER_LIST.get()) || newStack.m_150930_((Item)ItemRegistry.CHANGE_FLAG.get())) {
            if (!newStack.m_150930_(toCopy.m_41720_())) {
                return ItemStack.f_41583_;
            }
            CompoundTag tag = toCopy.m_41784_();
            newStack.m_41751_(tag.m_6426_());
            return newStack;
        }
        if (newStack.m_150930_((Item)ItemRegistry.REQUEST_LIST_ITEM.get())) {
            if (!toCopy.m_150930_((Item)ItemRegistry.REQUEST_LIST_ITEM.get()) || RequestListItem.isVirtual(toCopy) || RequestListItem.isVirtual(newStack)) {
                return ItemStack.f_41583_;
            }
            CompoundTag tag = toCopy.m_41784_();
            newStack.m_41751_(tag.m_6426_());
            RequestListItem.clearItemProcess(newStack);
            return newStack;
        }
        if (newStack.m_150930_((Item)ItemRegistry.CRAFT_GUIDE.get()) && toCopy.m_150930_(newStack.m_41720_())) {
            CompoundTag tag = toCopy.m_41784_();
            newStack.m_41751_(tag.m_6426_());
            return newStack;
        }
        return ItemStack.f_41583_;
    }

    public static class Serializer
    implements RecipeSerializer<CopyConfigRecipe> {
        public CopyConfigRecipe fromJson(ResourceLocation p_44103_, JsonObject p_44104_) {
            return new CopyConfigRecipe((ShapelessRecipe)RecipeSerializer.f_44077_.m_6729_(p_44103_, p_44104_));
        }

        @Nullable
        public CopyConfigRecipe fromNetwork(ResourceLocation p_44105_, FriendlyByteBuf p_44106_) {
            @Nullable ShapelessRecipe compose = (ShapelessRecipe)RecipeSerializer.f_44077_.m_8005_(p_44105_, p_44106_);
            return compose == null ? null : new CopyConfigRecipe(compose);
        }

        public void toNetwork(FriendlyByteBuf p_44101_, CopyConfigRecipe p_44102_) {
            RecipeSerializer.f_44077_.m_6178_(p_44101_, (Recipe)p_44102_);
        }
    }
}

