/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.util;

import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideData;
import studio.fantasyit.maid_storage_manager.data.InventoryItem;
import studio.fantasyit.maid_storage_manager.data.InventoryListDataClient;
import studio.fantasyit.maid_storage_manager.registry.ItemRegistry;
import studio.fantasyit.maid_storage_manager.util.ItemStackUtil;

@OnlyIn(value=Dist.CLIENT)
public class InventoryListUtil {
    @Nullable
    public static UUID getInventoryListUUIDFromPlayerInv(List<ItemStack> inv) {
        return inv.stream().filter(i -> i.m_150930_((Item)ItemRegistry.WRITTEN_INVENTORY_LIST.get()) && i.m_41782_() && i.m_41784_().m_128441_("uuid")).map(ItemStack::m_41784_).max(Comparator.comparingLong(i -> i.m_128454_("time"))).map(i -> i.m_128342_("uuid")).orElse(null);
    }

    @Nullable
    public static ItemStack getMatchingFromInventory(UUID uuid, List<ItemStack> itemStack) {
        for (ItemStack itemStack1 : itemStack) {
            Optional<CraftGuideData> craftable = InventoryListDataClient.getInstance().get(uuid).stream().filter(i -> i.itemStack.m_150930_((Item)ItemRegistry.CRAFT_GUIDE.get())).map(i -> CraftGuideData.fromItemStack(i.itemStack)).filter(i -> i.getOutput().stream().anyMatch(ii -> ii.m_150930_(itemStack1.m_41720_()))).findFirst();
            if (!craftable.isPresent()) continue;
            return itemStack1;
        }
        for (ItemStack itemStack1 : itemStack) {
            Optional<InventoryItem> inventoryItemStream = InventoryListDataClient.getInstance().get(uuid).stream().filter(i -> ItemStackUtil.isSame(i.itemStack, itemStack1, false)).max(Comparator.comparingInt(i -> i.totalCount));
            if (!inventoryItemStream.isPresent()) continue;
            return itemStack1;
        }
        return null;
    }

    public static ItemStack getMatchingForPlayer(List<ItemStack> itemStack) {
        if (itemStack.isEmpty()) {
            return ItemStack.f_41583_;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return itemStack.get(0);
        }
        return InventoryListUtil.getMatchingForPlayerOrFirst(player, itemStack);
    }

    public static ItemStack getMatchingForPlayerOrFirst(LocalPlayer player, List<ItemStack> itemStack) {
        if (itemStack.isEmpty()) {
            return ItemStack.f_41583_;
        }
        UUID uuid = InventoryListUtil.getInventoryListUUIDFromPlayerInv((List<ItemStack>)player.m_150109_().f_35974_);
        if (uuid == null) {
            return itemStack.get(0);
        }
        ItemStack matchingFromInventory = InventoryListUtil.getMatchingFromInventory(uuid, itemStack);
        return matchingFromInventory == null ? itemStack.get(0) : matchingFromInventory;
    }
}

