/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.craft.algo;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import oshi.util.tuples.Pair;
import studio.fantasyit.maid_storage_manager.Config;
import studio.fantasyit.maid_storage_manager.craft.algo.base.AbstractBiCraftGraph;
import studio.fantasyit.maid_storage_manager.craft.algo.base.BiCraftCountCalculator;
import studio.fantasyit.maid_storage_manager.craft.algo.base.ICraftGraphLike;
import studio.fantasyit.maid_storage_manager.craft.algo.graph.FlattenSearchGraph;
import studio.fantasyit.maid_storage_manager.craft.algo.graph.SimpleSearchGraph;
import studio.fantasyit.maid_storage_manager.craft.algo.graph.ThreadedSearchGraph;
import studio.fantasyit.maid_storage_manager.craft.algo.graph.TopologyCraftGraph;
import studio.fantasyit.maid_storage_manager.craft.algo.misc.ItemListStepSum;
import studio.fantasyit.maid_storage_manager.craft.algo.utils.RequestListSplitter;
import studio.fantasyit.maid_storage_manager.craft.algo.utils.ResultListOptimizer;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideData;
import studio.fantasyit.maid_storage_manager.craft.debug.CraftingDebugContext;
import studio.fantasyit.maid_storage_manager.craft.debug.IDebugContextSetter;
import studio.fantasyit.maid_storage_manager.craft.generator.AutoGraphGenerator;
import studio.fantasyit.maid_storage_manager.craft.work.CraftLayer;
import studio.fantasyit.maid_storage_manager.craft.work.CraftLayerChain;
import studio.fantasyit.maid_storage_manager.items.PortableCraftCalculatorBauble;
import studio.fantasyit.maid_storage_manager.items.RequestListItem;
import studio.fantasyit.maid_storage_manager.maid.ChatTexts;
import studio.fantasyit.maid_storage_manager.maid.data.StorageManagerConfigData;
import studio.fantasyit.maid_storage_manager.maid.memory.CraftMemory;
import studio.fantasyit.maid_storage_manager.maid.memory.ViewedInventoryMemory;
import studio.fantasyit.maid_storage_manager.storage.Target;
import studio.fantasyit.maid_storage_manager.util.InvUtil;
import studio.fantasyit.maid_storage_manager.util.ItemStackUtil;
import studio.fantasyit.maid_storage_manager.util.MemoryUtil;
import studio.fantasyit.maid_storage_manager.util.StorageAccessUtil;

public class MaidCraftPlanner
implements IDebugContextSetter {
    private final CraftMemory craftingMemory;
    ICraftGraphLike currentAvailableGraph;
    boolean done = false;
    int success = 0;
    int count = 0;
    ServerLevel level;
    EntityMaid maid;
    List<Pair<ItemStack, Integer>> notDone;
    Queue<Pair<Queue<Pair<ItemStack, Integer>>, ICraftGraphLike.CraftAlgorithmInit<?>>> craftJobs = new LinkedList();
    Queue<Pair<ItemStack, Integer>> tmpNextJob = new LinkedList<Pair<ItemStack, Integer>>();
    ItemListStepSum futureSteps;
    AutoGraphGenerator autoGraphGenerator;
    private List<CraftGuideData> craftGuides;
    private CraftingDebugContext debugContext = CraftingDebugContext.Dummy.INSTANCE;
    CraftLayerChain plan;
    BiCraftCountCalculator biCalc = null;
    Pair<ItemStack, Integer> currentWork = null;

    public MaidCraftPlanner(ServerLevel level, EntityMaid maid) {
        this.craftingMemory = MemoryUtil.getCrafting(maid);
        this.maid = maid;
        this.level = level;
        this.count = 0;
        if (!this.precheck()) {
            this.done = true;
            return;
        }
        for (ICraftGraphLike.CraftAlgorithmInit<?> craftAlgorithmInit : this.initGraphList()) {
            this.craftJobs.add(new Pair(new LinkedList(), craftAlgorithmInit));
        }
        this.craftGuides = new ArrayList<CraftGuideData>(MemoryUtil.getCrafting(maid).getCraftGuides());
        this.notDone = RequestListItem.getItemStacksNotDone(maid.m_21205_());
        if (Config.craftingGenerateCraftGuide) {
            this.autoGraphGenerator = new AutoGraphGenerator(maid, this.notDone.stream().map(itemStack -> (ItemStack)itemStack.getA()).toList(), this.craftGuides);
            this.autoGraphGenerator.setDebugContext(this.debugContext);
        } else {
            this.initItems();
        }
        this.plan = new CraftLayerChain(maid);
    }

    protected boolean precheck() {
        if (PortableCraftCalculatorBauble.getCalculator(this.maid).m_41619_() && !Config.craftingNoCalculator) {
            this.debugContext.logNoLevel(CraftingDebugContext.TYPE.PLANNER, "No Calculator found", new Object[0]);
            return false;
        }
        if (RequestListItem.isBlackMode(this.maid.m_21205_())) {
            this.debugContext.logNoLevel(CraftingDebugContext.TYPE.PLANNER, "Black list, no crafting", new Object[0]);
            return false;
        }
        return true;
    }

    protected List<ICraftGraphLike.CraftAlgorithmInit<?>> initGraphList() {
        return Config.craftingSolver.stream().map(craftSolver -> switch (craftSolver) {
            default -> throw new IncompatibleClassChangeError();
            case Config.CraftSolver.TOPOLOGY -> TopologyCraftGraph::new;
            case Config.CraftSolver.DFS -> SimpleSearchGraph::new;
            case Config.CraftSolver.DFS_QUEUED -> FlattenSearchGraph::new;
            case Config.CraftSolver.DFS_THREADED -> ThreadedSearchGraph::new;
        }).toList();
    }

    protected boolean initItems() {
        this.debugContext.logNoLevel(CraftingDebugContext.TYPE.PLANNER, "[REQUEST_CRAFT]Start. Calculate tree", new Object[0]);
        if (this.notDone.isEmpty()) {
            return false;
        }
        Target storage = RequestListItem.getStorageBlock(this.maid.m_21205_());
        ArrayList<Pair<ItemStack, Integer>> items = new ArrayList<Pair<ItemStack, Integer>>();
        MemoryUtil.getViewedInventory(this.maid).positionFlatten().forEach((pos, itemStacks) -> {
            if (pos.equals(storage)) {
                return;
            }
            if (StorageAccessUtil.findTargetRewrite(this.level, this.maid, pos, false).isEmpty()) {
                return;
            }
            for (ViewedInventoryMemory.ItemCount itemStack : itemStacks) {
                boolean flag = false;
                for (int i = 0; i < items.size(); ++i) {
                    if (!ItemStackUtil.isSameInCrafting(itemStack.getFirst(), (ItemStack)((Pair)items.get(i)).getA())) continue;
                    items.set(i, new Pair((Object)((ItemStack)((Pair)items.get(i)).getA()), (Object)((Integer)((Pair)items.get(i)).getB() + itemStack.getSecond())));
                    flag = true;
                    break;
                }
                if (flag) continue;
                items.add(new Pair((Object)itemStack.getFirst(), (Object)itemStack.getSecond()));
                this.debugContext.logNoLevel(CraftingDebugContext.TYPE.PLANNER, "Adding Stock ItemStack %s * %s;", itemStack.getFirst(), itemStack.getSecond());
            }
        });
        this.futureSteps = new ItemListStepSum(this.notDone);
        ((Queue)this.craftJobs.peek().getA()).addAll(this.notDone);
        this.currentAvailableGraph = ((ICraftGraphLike.CraftAlgorithmInit)this.craftJobs.peek().getB()).init(items, this.craftGuides);
        this.debugContext.convey(this.currentAvailableGraph);
        this.notDone.forEach(itemStack -> this.currentAvailableGraph.setItemCount((ItemStack)itemStack.getA(), 0));
        this.notDone.forEach(itemStack -> this.debugContext.logNoLevel(CraftingDebugContext.TYPE.PLANNER, "Adding Craft ItemStack %s * %s;", itemStack.getA(), itemStack.getB()));
        return true;
    }

    public boolean done() {
        return this.done;
    }

    public void tick(long tick) {
        this.sendMaidProgressBubble();
        if (this.autoGraphGenerator != null) {
            if (this.autoGraphGenerator.process()) {
                List<CraftGuideData> craftGuideData = this.autoGraphGenerator.getCraftGuideData();
                craftGuideData = craftGuideData.stream().filter(c -> {
                    if (!c.getOutput().stream().findFirst().map(i1 -> this.craftGuides.stream().anyMatch(c2 -> c2.getOutput().stream().findFirst().map(i -> ItemStackUtil.isSameInCrafting(i, i1)).orElse(false))).orElse(false).booleanValue()) {
                        return true;
                    }
                    this.debugContext.logNoLevel(CraftingDebugContext.TYPE.PLANNER, "Craft Guide %s is overlapped with user added craft guide", c);
                    return false;
                }).toList();
                this.craftGuides.addAll(craftGuideData);
                this.autoGraphGenerator.cache();
                this.autoGraphGenerator = null;
                this.initItems();
            }
            return;
        }
        if (this.craftJobs.isEmpty()) {
            this.done = true;
            return;
        }
        if (this.biCalc == null && ((Queue)this.craftJobs.peek().getA()).isEmpty()) {
            this.craftJobs.poll();
            if (!this.craftJobs.isEmpty()) {
                while (!this.tmpNextJob.isEmpty()) {
                    ((Queue)this.craftJobs.peek().getA()).add(this.tmpNextJob.poll());
                }
                this.currentAvailableGraph = this.currentAvailableGraph.createGraphWithItem((ICraftGraphLike.CraftAlgorithmInit)this.craftJobs.peek().getB());
                this.debugContext.convey(this.currentAvailableGraph);
            }
            this.count = 0;
            return;
        }
        if (this.currentWork == null) {
            this.currentWork = (Pair)((Queue)this.craftJobs.peek().getA()).poll();
            if (this.currentWork != null && (Integer)this.currentWork.getB() == 0) {
                this.currentWork = null;
            }
            if (this.currentWork == null) {
                return;
            }
        }
        if (this.biCalc == null) {
            ICraftGraphLike iCraftGraphLike = this.currentAvailableGraph;
            if (iCraftGraphLike instanceof AbstractBiCraftGraph) {
                AbstractBiCraftGraph abstractGraph = (AbstractBiCraftGraph)iCraftGraphLike;
                this.debugContext.saveGraph(abstractGraph, (ItemStack)this.currentWork.getA(), (Integer)this.currentWork.getB());
            }
            this.biCalc = new BiCraftCountCalculator(this.currentAvailableGraph, (ItemStack)this.currentWork.getA(), (Integer)this.currentWork.getB(), InvUtil.freeSlots((IItemHandler)this.maid.getAvailableInv(true)));
            this.debugContext.convey(this.biCalc);
        }
        boolean finish = false;
        for (int i = 0; i < 5; ++i) {
            if (this.biCalc.tick()) continue;
            finish = true;
            break;
        }
        if (finish) {
            this.handleResult();
            this.biCalc = null;
        }
    }

    protected void handleResult() {
        List<CraftLayer> results = this.biCalc.getResults();
        if (results.isEmpty()) {
            this.debugContext.logNoLevel(CraftingDebugContext.TYPE.PLANNER, "[REQUEST_CRAFT] Failed to find recipe for %s", ((ItemStack)this.currentWork.getA()).m_41786_().getString());
            if (this.biCalc.hasAnySuccessCraftingCalc()) {
                RequestListItem.setFailAddition(this.maid.m_21205_(), (ItemStack)this.currentWork.getA(), "tooltip.maid_storage_manager.request_list.fail_backpack_full");
            }
            RequestListItem.markDone(this.maid.m_21205_(), (ItemStack)this.currentWork.getA());
        } else {
            List<CraftLayer> optimize = ResultListOptimizer.optimize(results);
            optimize = RequestListSplitter.splitLayerMax(optimize, StorageManagerConfigData.get(this.maid).maxCraftingLayerRepeatCount());
            optimize.forEach(craftLayer -> this.plan.addLayer((CraftLayer)craftLayer));
            this.debugContext.logEntryNewLevel(CraftingDebugContext.TYPE.PLANNER, "[REQUEST_CRAFT] %s tree with %d layers", ((ItemStack)this.currentWork.getA()).m_41786_().getString(), results.size());
            optimize.forEach(t -> this.debugContext.log(CraftingDebugContext.TYPE.PLANNER, "Layer g:%s * %s", t.getCraftData(), t.getCount()));
            this.debugContext.exitLogLevel(CraftingDebugContext.TYPE.PLANNER, "[REQUEST_CRAFT] layers", new Object[0]);
            ++this.success;
        }
        List<Pair<ItemStack, Integer>> fails = this.biCalc.getFails();
        if (!fails.isEmpty()) {
            RequestListItem.setMissingItem(this.maid.m_21205_(), (ItemStack)this.currentWork.getA(), fails.stream().map(e -> ((ItemStack)e.getA()).m_255036_(((Integer)e.getB()).intValue())).toList());
        }
        int restCount = this.biCalc.getNotCraftedCount();
        this.tmpNextJob.add((Pair<ItemStack, Integer>)new Pair((Object)((ItemStack)this.currentWork.getA()), (Object)restCount));
        this.biCalc = null;
        this.currentWork = null;
        ++this.count;
    }

    private void sendMaidProgressBubble() {
        if (this.autoGraphGenerator != null) {
            ChatTexts.progress(this.maid, (Component)Component.m_237110_((String)"chat_bubbles.maid_storage_manager.craft_generating", (Object[])new Object[]{this.autoGraphGenerator.getDone(), this.autoGraphGenerator.getTotal()}), this.autoGraphGenerator.getProgress());
            this.craftingMemory.calculatingProgress = this.autoGraphGenerator.getDone();
            this.craftingMemory.calculatingTotal = this.autoGraphGenerator.getTotal();
            return;
        }
        if (this.biCalc == null) {
            return;
        }
        int restSteps = this.futureSteps.getStep(this.count) + this.biCalc.getWorstRestSteps();
        ChatTexts.progress(this.maid, (Component)Component.m_237110_((String)"chat_bubbles.maid_storage_manager.craft_calculated", (Object[])new Object[]{String.valueOf(this.futureSteps.getTotalStep() - restSteps), String.valueOf(this.futureSteps.getTotalStep())}), (double)this.futureSteps.getTotalStep() / (double)(this.futureSteps.getTotalStep() - restSteps));
        this.craftingMemory.calculatingProgress = this.futureSteps.getTotalStep() - restSteps;
        this.craftingMemory.calculatingTotal = this.futureSteps.getTotalStep();
    }

    public boolean anySuccess() {
        return this.success > 0;
    }

    public CraftLayerChain getPlan() {
        return this.plan;
    }

    @Override
    public void setDebugContext(CraftingDebugContext context) {
        this.debugContext = context;
        context.convey(this.currentAvailableGraph);
        context.convey(this.autoGraphGenerator);
    }
}

