/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.craft.algo.misc;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import oshi.util.tuples.Pair;
import studio.fantasyit.maid_storage_manager.craft.algo.base.AbstractBiCraftGraph;
import studio.fantasyit.maid_storage_manager.craft.algo.base.node.ItemNodeBasic;
import studio.fantasyit.maid_storage_manager.craft.algo.base.node.Node;
import studio.fantasyit.maid_storage_manager.craft.algo.misc.StronglyConnected;
import studio.fantasyit.maid_storage_manager.craft.debug.CraftingDebugContext;
import studio.fantasyit.maid_storage_manager.craft.debug.IDebugContextSetter;

public class PrefilterByChunk
implements IDebugContextSetter {
    private final StronglyConnected tarjon;
    private final AbstractBiCraftGraph graph;
    private int[] sccTotalInputs;
    private List<Integer>[] sccToOtherSccs;
    private CraftingDebugContext debugContext = CraftingDebugContext.Dummy.INSTANCE;

    public PrefilterByChunk(AbstractBiCraftGraph graph) {
        this.tarjon = new StronglyConnected(graph);
        this.graph = graph;
    }

    public void process() {
        int i;
        this.tarjon.process();
        this.sccTotalInputs = new int[this.tarjon.maxSccId() + 1];
        this.sccToOtherSccs = new List[this.tarjon.maxSccId() + 1];
        boolean[] sccNotVisitable = new boolean[this.tarjon.maxSccId() + 1];
        for (i = 0; i < this.sccToOtherSccs.length; ++i) {
            this.sccToOtherSccs[i] = new ArrayList<Integer>();
        }
        for (i = 0; i < this.graph.getNodeCount(); ++i) {
            Node node = this.graph.getNode(i);
            if (node instanceof ItemNodeBasic) {
                Iterator<Integer> in = (ItemNodeBasic)node;
                int n = ((ItemNodeBasic)((Object)in)).sccId;
                this.sccTotalInputs[n] = this.sccTotalInputs[n] + ((ItemNodeBasic)((Object)in)).count;
            }
            for (Pair pair : node.edges) {
                if (node.sccId == this.graph.getNode((int)((Integer)pair.getA()).intValue()).sccId) continue;
                this.sccToOtherSccs[node.sccId].add(this.graph.getNode((int)((Integer)pair.getA()).intValue()).sccId);
            }
        }
        LinkedList<Integer> queue = new LinkedList<Integer>();
        for (int i2 = 0; i2 < this.sccTotalInputs.length; ++i2) {
            if (this.sccTotalInputs[i2] != 0 || !this.sccToOtherSccs[i2].isEmpty()) continue;
            queue.add(i2);
        }
        while (!queue.isEmpty()) {
            int tSccId = (Integer)queue.poll();
            sccNotVisitable[tSccId] = true;
            for (int n : this.sccToOtherSccs[tSccId]) {
                if (!this.sccToOtherSccs[n].stream().allMatch(sccId -> sccNotVisitable[sccId])) continue;
                queue.add(n);
            }
        }
        int count = 0;
        for (int i3 = 0; i3 < this.graph.getNodeCount(); ++i3) {
            Node node = this.graph.getNode(i3);
            if (!sccNotVisitable[node.sccId]) continue;
            node.maxSuccess = 0;
            ++count;
        }
        this.debugContext.logNoLevel(CraftingDebugContext.TYPE.PREFILTER, "%s nodes are not visitable", count);
    }

    @Override
    public void setDebugContext(CraftingDebugContext context) {
        this.debugContext = context;
    }
}

