/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.craft.algo.utils;

import java.util.ArrayList;
import java.util.List;
import studio.fantasyit.maid_storage_manager.craft.work.CraftLayer;

public class RequestListSplitter {
    public static List<CraftLayer> splitLayerMax(List<CraftLayer> layers, int maxSize) {
        ArrayList<CraftLayer> result = new ArrayList<CraftLayer>();
        for (CraftLayer layer : layers) {
            if (layer.getCraftData().isEmpty()) {
                result.add(layer);
                continue;
            }
            int oCount = layer.getCount();
            boolean placeBefore = layer.shouldPlaceBefore();
            if (layer.getItems().stream().anyMatch(t -> t.m_41613_() < layer.getCount())) {
                result.add(layer);
                continue;
            }
            for (int rest = oCount; rest > 0; rest -= maxSize) {
                int currentSize = Math.min(rest, maxSize);
                CraftLayer newLayer = layer.copyWithNoState();
                newLayer.setCount(currentSize);
                newLayer.setItems(newLayer.getItems().stream().map(itemStack -> itemStack.m_255036_(itemStack.m_41613_() * currentSize / oCount)).toList());
                if (placeBefore) {
                    newLayer.setPlaceBefore();
                    placeBefore = false;
                }
                result.add(newLayer);
            }
        }
        return result;
    }
}

