/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.craft.algo.utils;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideData;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideStepData;
import studio.fantasyit.maid_storage_manager.craft.work.CraftLayer;
import studio.fantasyit.maid_storage_manager.util.ItemStackUtil;

public class ResultListOptimizer {
    public static List<CraftLayer> optimize(List<CraftLayer> layers) {
        layers = ResultListOptimizer.mergeSame(layers);
        return layers;
    }

    public static List<CraftLayer> mergeSame(List<CraftLayer> layers) {
        if (layers.isEmpty()) {
            return layers;
        }
        ArrayList<CraftLayer> result = new ArrayList<CraftLayer>();
        CraftLayer tmp = layers.get(0);
        ArrayList<ItemStack> tItemStack = new ArrayList<ItemStack>(tmp.getItems().stream().map(ItemStack::m_41777_).toList());
        for (int i = 1; i < layers.size(); ++i) {
            CraftLayer layer = layers.get(i);
            if (layer.getCraftData().isEmpty()) {
                result.add(tmp);
                result.add(layer);
                if (++i < layers.size()) {
                    tmp = layers.get(i);
                    tItemStack = new ArrayList<ItemStack>(tmp.getItems().stream().map(ItemStack::m_41777_).toList());
                    continue;
                }
                tmp = null;
                continue;
            }
            CraftGuideData cgd = layer.getCraftData().get();
            CraftGuideData lastCgd = tmp.getCraftData().get();
            boolean equal = true;
            if (cgd.getType().equals((Object)lastCgd.getType()) && cgd.steps.size() == lastCgd.steps.size()) {
                for (int j = 0; j < cgd.steps.size(); ++j) {
                    CraftGuideStepData step2;
                    CraftGuideStepData step1 = cgd.steps.get(j);
                    if (step1.equals(step2 = lastCgd.steps.get(j))) continue;
                    equal = false;
                    break;
                }
            } else {
                equal = false;
            }
            if (layer.shouldPlaceBefore()) {
                equal = false;
            }
            if (equal) {
                ItemStack itemStack12;
                ArrayList<ItemStack> nextInputs = new ArrayList<ItemStack>(layer.getItems());
                ArrayList<ItemStack> nextOutputs = new ArrayList<ItemStack>(cgd.getOutput().stream().map(ii -> ii.m_255036_(ii.m_41613_() * layer.getCount())).toList());
                CraftLayer finalTmp = tmp;
                ArrayList<ItemStack> oldOutputs = new ArrayList<ItemStack>(lastCgd.getOutput().stream().map(ii -> ii.m_255036_(ii.m_41613_() * finalTmp.getCount())).toList());
                ArrayList<ItemStack> oldOutputsToDetect = new ArrayList<ItemStack>(lastCgd.getOutput().stream().map(ii -> ii.m_255036_(ii.m_41613_() * finalTmp.getCount())).toList());
                boolean exceed = false;
                for (ItemStack itemStack : nextInputs) {
                    itemStack12 = ItemStackUtil.removeIsMatchInList(oldOutputsToDetect, itemStack.m_41777_(), ItemStackUtil::isSameInCrafting);
                    if (itemStack12.m_41619_()) continue;
                    ItemStackUtil.addToList(tItemStack, itemStack12, ItemStackUtil::isSameInCrafting);
                }
                for (ItemStack itemStack13 : nextOutputs) {
                    ItemStackUtil.addToList(oldOutputsToDetect, itemStack13, ItemStackUtil::isSameInCrafting);
                }
                if (tItemStack.stream().anyMatch(itemStack1 -> itemStack1.m_41613_() > itemStack1.m_41741_())) {
                    exceed = true;
                }
                if (oldOutputsToDetect.stream().anyMatch(itemStack1 -> itemStack1.m_41613_() > itemStack1.m_41741_())) {
                    exceed = true;
                }
                if (!exceed) {
                    for (ItemStack itemStack : nextInputs) {
                        itemStack12 = ItemStackUtil.removeIsMatchInList(oldOutputs, itemStack, ItemStackUtil::isSameInCrafting);
                        if (itemStack12.m_41619_()) continue;
                        ItemStackUtil.addToList(tmp.getItems(), itemStack12, ItemStackUtil::isSameInCrafting);
                    }
                    tmp.setCount(tmp.getCount() + layer.getCount());
                    continue;
                }
            }
            result.add(tmp);
            tmp = layer;
            tItemStack = new ArrayList<ItemStack>(tmp.getItems().stream().map(ItemStack::m_41777_).toList());
        }
        if (tmp != null) {
            result.add(tmp);
        }
        return result;
    }
}

