/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.craft.data;

import com.google.common.collect.ImmutableCollection;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import studio.fantasyit.maid_storage_manager.craft.CraftManager;
import studio.fantasyit.maid_storage_manager.craft.action.ActionOption;
import studio.fantasyit.maid_storage_manager.craft.action.ActionOptionSet;
import studio.fantasyit.maid_storage_manager.craft.action.CraftAction;
import studio.fantasyit.maid_storage_manager.storage.Target;
import studio.fantasyit.maid_storage_manager.util.ItemStackUtil;

public class CraftGuideStepData {
    public static final ResourceLocation SPECIAL_ACTION = new ResourceLocation("maid_storage_manager", "special");
    public static Codec<CraftGuideStepData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Target.CODEC.fieldOf("storage").forGetter(CraftGuideStepData::getStorage), (App)Codec.list((Codec)ItemStack.f_41582_).fieldOf("input").forGetter(CraftGuideStepData::getInput), (App)Codec.list((Codec)ItemStack.f_41582_).fieldOf("output").forGetter(CraftGuideStepData::getOutput), (App)ResourceLocation.f_135803_.fieldOf("action").forGetter(CraftGuideStepData::getActionType), (App)CompoundTag.f_128325_.fieldOf("extra").forGetter(CraftGuideStepData::getExtraData)).apply((Applicative)instance, CraftGuideStepData::new));
    public Target storage;
    public List<ItemStack> input;
    public List<ItemStack> output;
    public ResourceLocation action;
    public CraftAction actionType;
    public CompoundTag extraData;

    public CraftGuideStepData(Target storage, List<ItemStack> input, List<ItemStack> output, ResourceLocation action, CompoundTag extraData) {
        this.storage = storage;
        this.action = action;
        this.actionType = CraftManager.getInstance().getAction(action);
        if (this.actionType == null) {
            this.actionType = CraftManager.getInstance().getDefaultAction();
            this.action = this.actionType.type();
        }
        if (input.size() < this.actionType.inputCount()) {
            input = new ArrayList<ItemStack>(input);
        }
        while (input.size() < this.actionType.inputCount()) {
            input.add(ItemStack.f_41583_);
        }
        if (output.size() < this.actionType.outputCount()) {
            output = new ArrayList<ItemStack>(output);
        }
        while (output.size() < this.actionType.outputCount()) {
            output.add(ItemStack.f_41583_);
        }
        this.input = input;
        this.output = output;
        this.extraData = extraData;
    }

    public CraftGuideStepData(Target storage, List<ItemStack> input, List<ItemStack> output, ResourceLocation action) {
        this(storage, input, output, action, new CompoundTag());
    }

    public CraftGuideStepData(Target storage, List<ItemStack> input, List<ItemStack> output, ResourceLocation action, ActionOptionSet options) {
        this(storage, input, output, action, new CompoundTag());
        options.applyTo(this);
    }

    @Deprecated
    public CraftGuideStepData(Target storage, List<ItemStack> input, List<ItemStack> output, ResourceLocation action, boolean optional, CompoundTag extraData) {
        this(storage, input, output, action, extraData);
        if (this.actionType != null && this.actionType.hasOption(ActionOption.OPTIONAL) && optional) {
            this.extraData = this.extraData.m_6426_();
            ActionOption.OPTIONAL.setOptionSelection(this, true);
        }
    }

    public static CraftGuideStepData createFromTypeStorage(Target storage, ResourceLocation action) {
        CraftAction action1 = CraftManager.getInstance().getAction(action);
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        for (int i = 0; i < action1.inputCount(); ++i) {
            inputs.add(ItemStack.f_41583_);
        }
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
        for (int i = 0; i < action1.outputCount(); ++i) {
            outputs.add(ItemStack.f_41583_);
        }
        return new CraftGuideStepData(storage, inputs, outputs, action, new CompoundTag());
    }

    public static CraftGuideStepData fromCompound(CompoundTag tag) {
        Target storage = null;
        ResourceLocation action = null;
        CompoundTag extraData = new CompoundTag();
        if (tag.m_128441_("storage")) {
            storage = Target.fromNbt(tag.m_128469_("storage"));
        }
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        if (storage != null && tag.m_128441_("input")) {
            ListTag list = tag.m_128437_("input", 10);
            for (int i = 0; i < list.size(); ++i) {
                inputs.add(ItemStackUtil.parseStack(list.m_128728_(i).m_128469_("item")).m_255036_(list.m_128728_(i).m_128451_("requested")));
            }
        }
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
        if (storage != null && tag.m_128441_("output")) {
            ListTag list = tag.m_128437_("output", 10);
            for (int i = 0; i < list.size(); ++i) {
                outputs.add(ItemStackUtil.parseStack(list.m_128728_(i).m_128469_("item")).m_255036_(list.m_128728_(i).m_128451_("requested")));
            }
        }
        if (tag.m_128441_("action")) {
            action = ResourceLocation.m_135820_((String)tag.m_128461_("action"));
        }
        if (tag.m_128441_("extra")) {
            extraData = tag.m_128469_("extra");
        }
        if (tag.m_128441_("optional")) {
            extraData.m_128365_(ActionOption.OPTIONAL.id().toString(), (Tag)new CompoundTag());
            extraData.m_128469_(ActionOption.OPTIONAL.id().toString()).m_128405_(ActionOption.OPTIONAL.id().toString(), tag.m_128471_("optional") ? 1 : 0);
            extraData.m_128469_(ActionOption.OPTIONAL.id().toString()).m_128359_(ActionOption.OPTIONAL.id().toString(), "type");
        }
        return new CraftGuideStepData(storage, inputs, outputs, action, extraData);
    }

    public CompoundTag toCompound() {
        CompoundTag itemTag;
        ListTag list;
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("storage", (Tag)this.storage.toNbt());
        if (this.input.size() > 0) {
            list = new ListTag();
            for (ItemStack itemStack : this.input) {
                itemTag = new CompoundTag();
                itemTag.m_128365_("item", (Tag)ItemStackUtil.saveStack(itemStack));
                itemTag.m_128405_("requested", itemStack.m_41613_());
                list.add((Object)itemTag);
            }
            tag.m_128365_("input", (Tag)list);
        }
        if (this.output.size() > 0) {
            list = new ListTag();
            for (ItemStack itemStack : this.output) {
                itemTag = new CompoundTag();
                itemTag.m_128365_("item", (Tag)ItemStackUtil.saveStack(itemStack));
                itemTag.m_128405_("requested", itemStack.m_41613_());
                list.add((Object)itemTag);
            }
            tag.m_128365_("output", (Tag)list);
        }
        tag.m_128359_("action", this.action.toString());
        tag.m_128365_("extra", (Tag)this.extraData);
        return tag;
    }

    public Target getStorage() {
        return this.storage;
    }

    public ResourceLocation getActionType() {
        return this.action;
    }

    public boolean isOptional() {
        return this.actionType.hasOption(ActionOption.OPTIONAL) && ActionOption.OPTIONAL.getOptionSelection(this).orElse(false) != false;
    }

    public List<ItemStack> getItems() {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        items.addAll(this.getInput());
        items.addAll(this.getOutput());
        return items;
    }

    public List<ItemStack> getNonEmptyItems() {
        return this.getItems().stream().filter(itemStack -> !itemStack.m_41619_()).toList();
    }

    public List<ItemStack> getInput() {
        return this.input.subList(0, this.actionType.inputCount());
    }

    public void setInput(int i, ItemStack itemStack) {
        if (this.input instanceof ImmutableCollection) {
            this.input = new ArrayList<ItemStack>(this.input);
        }
        this.input.set(i, itemStack);
    }

    public void clearInput() {
        if (this.input instanceof ImmutableCollection) {
            this.input = new ArrayList<ItemStack>(this.input);
        }
        this.input.clear();
    }

    public List<ItemStack> getNonEmptyInput() {
        return this.getInput().stream().filter(itemStack -> !itemStack.m_41619_()).toList();
    }

    public List<ItemStack> getOutput() {
        return this.output.subList(0, this.actionType.outputCount());
    }

    public void setOutput(int i, ItemStack itemStack) {
        if (this.output instanceof ImmutableCollection) {
            this.output = new ArrayList<ItemStack>(this.output);
        }
        this.output.set(i, itemStack);
    }

    public void clearOutput() {
        if (this.output instanceof ImmutableCollection) {
            this.output = new ArrayList<ItemStack>(this.output);
        }
        this.output.clear();
    }

    public List<ItemStack> getNonEmptyOutput() {
        return this.getOutput().stream().filter(itemStack -> !itemStack.m_41619_()).toList();
    }

    public boolean equals(Object obj) {
        if (obj instanceof CraftGuideStepData) {
            CraftGuideStepData craftGuideStepData = (CraftGuideStepData)obj;
            if (craftGuideStepData.storage.equals(this.storage) && craftGuideStepData.input.size() == this.input.size() && craftGuideStepData.output.size() == this.output.size()) {
                int i;
                for (i = 0; i < craftGuideStepData.output.size(); ++i) {
                    if (ItemStack.m_41656_((ItemStack)craftGuideStepData.output.get(i), (ItemStack)this.output.get(i))) continue;
                    return false;
                }
                for (i = 0; i < craftGuideStepData.input.size(); ++i) {
                    if (ItemStack.m_41656_((ItemStack)craftGuideStepData.input.get(i), (ItemStack)this.input.get(i))) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public void setAction(ResourceLocation action) {
        int i;
        this.action = action;
        this.actionType = CraftManager.getInstance().getAction(action);
        if (this.input.size() < this.actionType.inputCount()) {
            if (this.input instanceof ImmutableCollection) {
                this.input = new ArrayList<ItemStack>(this.input);
            }
            for (i = this.input.size(); i < this.actionType.inputCount(); ++i) {
                this.input.add(ItemStack.f_41583_);
            }
        }
        if (this.output.size() < this.actionType.outputCount()) {
            if (this.output instanceof ImmutableCollection) {
                this.output = new ArrayList<ItemStack>(this.output);
            }
            for (i = this.output.size(); i < this.actionType.outputCount(); ++i) {
                this.output.add(ItemStack.f_41583_);
            }
        }
    }

    public CompoundTag getExtraData() {
        return this.extraData;
    }

    public void setExtraData(CompoundTag extraData) {
        this.extraData = extraData;
    }

    public void setOptionValue(ActionOption<?> option, String value) {
        option.setOptionValue(this, value);
    }

    public String getOptionValue(ActionOption<?> option) {
        return option.getOptionValue(this);
    }

    public <T> void setOptionSelection(ActionOption<T> option, T selection) {
        option.setOptionSelection(this, selection);
    }

    public <T> Optional<T> getOptionSelection(ActionOption<T> option) {
        return option.getOptionSelection(this);
    }

    public Optional<Integer> getOptionSelectionId(ActionOption<?> option) {
        return option.getOptionSelectionId(this);
    }
}

