/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.craft.type;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.fantasyit.maid_storage_manager.craft.WorkBlockTags;
import studio.fantasyit.maid_storage_manager.craft.action.ActionOption;
import studio.fantasyit.maid_storage_manager.craft.action.ActionOptionSet;
import studio.fantasyit.maid_storage_manager.craft.context.common.CommonPlaceItemAction;
import studio.fantasyit.maid_storage_manager.craft.context.common.CommonTakeItemAction;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideData;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideStepData;
import studio.fantasyit.maid_storage_manager.craft.type.ICraftType;
import studio.fantasyit.maid_storage_manager.menu.craft.furnace.FurnaceCraftMenu;
import studio.fantasyit.maid_storage_manager.storage.ItemHandler.ItemHandlerStorage;
import studio.fantasyit.maid_storage_manager.storage.Target;

public class FurnaceType
implements ICraftType {
    public static final ResourceLocation TYPE = new ResourceLocation("maid_storage_manager", "furnace");

    @Override
    @NotNull
    public ResourceLocation getType() {
        return TYPE;
    }

    @Override
    @NotNull
    public ResourceLocation getActionType() {
        return TYPE;
    }

    @Override
    @NotNull
    public ItemStack getIcon() {
        return Items.f_41962_.m_7968_();
    }

    @Override
    public boolean isSpecialType(ServerLevel level, BlockPos pos, Direction direction) {
        return level.m_8055_(pos).m_204336_(WorkBlockTags.FURNACE);
    }

    @Override
    @Nullable
    public AbstractContainerMenu createGui(int containerId, Level level, Player player, CraftGuideData data) {
        return new FurnaceCraftMenu(containerId, player);
    }

    @Override
    public boolean available(CraftGuideData craftGuideData) {
        return craftGuideData.getOutput().stream().anyMatch(itemStack -> !itemStack.m_41619_());
    }

    @Override
    @NotNull
    public List<CraftGuideStepData> transformSteps(List<CraftGuideStepData> steps) {
        CraftGuideStepData craftGuideStepData = ICraftType.super.transformSteps(steps).get(0);
        ArrayList<CraftGuideStepData> ret = new ArrayList<CraftGuideStepData>();
        Target target = new Target(ItemHandlerStorage.TYPE, craftGuideStepData.getStorage().pos);
        ret.add(new CraftGuideStepData(target.sameType(craftGuideStepData.getStorage().getPos(), Direction.UP), List.of(craftGuideStepData.getInput().get(0)), List.of(), CommonPlaceItemAction.TYPE));
        ret.add(new CraftGuideStepData(target.sameType(craftGuideStepData.getStorage().getPos(), Direction.EAST), List.of(craftGuideStepData.getInput().get(1)), List.of(), CommonPlaceItemAction.TYPE, ActionOptionSet.with(ActionOption.OPTIONAL, true)));
        ret.add(new CraftGuideStepData(target.sameType(craftGuideStepData.getStorage().getPos(), Direction.DOWN), List.of(), List.of(craftGuideStepData.getOutput().get(0)), CommonTakeItemAction.TYPE));
        return ret;
    }
}

