/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.event;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import studio.fantasyit.maid_storage_manager.render.ItemStackLighting;
import studio.fantasyit.maid_storage_manager.render.base.CustomGraphics;
import studio.fantasyit.maid_storage_manager.render.base.ICustomGraphics;
import studio.fantasyit.maid_storage_manager.render.map_like.CommonMapLike;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE, modid="maid_storage_manager", value={Dist.CLIENT})
public class RenderHandMapLikeEvent {
    @SubscribeEvent
    public static void onRenderHand(RenderHandEvent event) {
        Item item;
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        InteractionHand hand = event.getHand();
        ItemStack stack = event.getItemStack();
        if (hand == InteractionHand.MAIN_HAND && (item = stack.m_41720_()) instanceof MapLikeRenderItem) {
            MapLikeRenderItem mli = (MapLikeRenderItem)item;
            if (!mli.available(stack)) {
                return;
            }
            event.getPoseStack().m_85836_();
            if (player.m_21206_().m_41619_()) {
                RenderHandMapLikeEvent.renderTwoHandedMap(mc, event.getPoseStack(), event.getMultiBufferSource(), event.getPackedLight(), event.getInterpolatedPitch(), event.getEquipProgress(), event.getSwingProgress(), stack);
            } else {
                RenderHandMapLikeEvent.renderOneHandedMap(mc, event.getPoseStack(), event.getMultiBufferSource(), event.getPackedLight(), event.getEquipProgress(), player.m_5737_(), event.getSwingProgress(), stack);
            }
            event.getPoseStack().m_85849_();
            event.setCanceled(true);
        } else if (hand == InteractionHand.OFF_HAND && (item = stack.m_41720_()) instanceof MapLikeRenderItem) {
            MapLikeRenderItem mli = (MapLikeRenderItem)item;
            if (!mli.available(stack)) {
                return;
            }
            event.getPoseStack().m_85836_();
            RenderHandMapLikeEvent.renderOneHandedMap(mc, event.getPoseStack(), event.getMultiBufferSource(), event.getPackedLight(), event.getEquipProgress(), player.m_5737_().m_20828_(), event.getSwingProgress(), stack);
            event.getPoseStack().m_85849_();
            event.setCanceled(true);
        }
    }

    private static void renderMapHand(Minecraft mc, PoseStack pPoseStack, MultiBufferSource pBuffer, int pCombinedLight, HumanoidArm pSide) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)mc.f_91074_.m_108560_());
        PlayerRenderer playerrenderer = (PlayerRenderer)mc.m_91290_().m_114382_((Entity)mc.f_91074_);
        pPoseStack.m_85836_();
        float f = pSide == HumanoidArm.RIGHT ? 1.0f : -1.0f;
        pPoseStack.m_252781_(Axis.f_252436_.m_252977_(92.0f));
        pPoseStack.m_252781_(Axis.f_252529_.m_252977_(45.0f));
        pPoseStack.m_252781_(Axis.f_252403_.m_252977_(f * -41.0f));
        pPoseStack.m_252880_(f * 0.3f, -1.1f, 0.45f);
        if (pSide == HumanoidArm.RIGHT) {
            playerrenderer.m_117770_(pPoseStack, pBuffer, pCombinedLight, (AbstractClientPlayer)mc.f_91074_);
        } else {
            playerrenderer.m_117813_(pPoseStack, pBuffer, pCombinedLight, (AbstractClientPlayer)mc.f_91074_);
        }
        pPoseStack.m_85849_();
    }

    private static void renderOneHandedMap(Minecraft mc, PoseStack pPoseStack, MultiBufferSource pBuffer, int pCombinedLight, float pEquippedProgress, HumanoidArm pHand, float pSwingProgress, ItemStack pStack) {
        float f = pHand == HumanoidArm.RIGHT ? 1.0f : -1.0f;
        pPoseStack.m_252880_(f * 0.125f, -0.125f, 0.0f);
        if (!mc.f_91074_.m_20145_()) {
            pPoseStack.m_85836_();
            pPoseStack.m_252781_(Axis.f_252403_.m_252977_(f * 10.0f));
            RenderHandMapLikeEvent.renderPlayerArm(mc, pPoseStack, pBuffer, pCombinedLight, pEquippedProgress, pSwingProgress, pHand);
            pPoseStack.m_85849_();
        }
        pPoseStack.m_85836_();
        pPoseStack.m_252880_(f * 0.51f, -0.08f + pEquippedProgress * -1.2f, -0.75f);
        float f1 = Mth.m_14116_((float)pSwingProgress);
        float f2 = Mth.m_14031_((float)(f1 * (float)Math.PI));
        float f3 = -0.5f * f2;
        float f4 = 0.4f * Mth.m_14031_((float)(f1 * ((float)Math.PI * 2)));
        float f5 = -0.3f * Mth.m_14031_((float)(pSwingProgress * (float)Math.PI));
        pPoseStack.m_252880_(f * f3, f4 - 0.3f * f2, f5);
        pPoseStack.m_252781_(Axis.f_252529_.m_252977_(f2 * -45.0f));
        pPoseStack.m_252781_(Axis.f_252436_.m_252977_(f * f2 * -30.0f));
        RenderHandMapLikeEvent.doRenderOnHand(mc, pPoseStack, pBuffer, pCombinedLight, pStack, pHand == HumanoidArm.RIGHT ? MapLikeRenderContext.MAIN_HAND : MapLikeRenderContext.OFF_HAND);
        pPoseStack.m_85849_();
    }

    private static float calculateMapTilt(float pPitch) {
        float f = 1.0f - pPitch / 45.0f + 0.1f;
        f = Mth.m_14036_((float)f, (float)0.0f, (float)1.0f);
        return -Mth.m_14089_((float)(f * (float)Math.PI)) * 0.5f + 0.5f;
    }

    private static void renderTwoHandedMap(Minecraft mc, PoseStack pPoseStack, MultiBufferSource pBuffer, int pCombinedLight, float pPitch, float pEquippedProgress, float pSwingProgress, ItemStack pStack) {
        float f = Mth.m_14116_((float)pSwingProgress);
        float f1 = -0.2f * Mth.m_14031_((float)(pSwingProgress * (float)Math.PI));
        float f2 = -0.4f * Mth.m_14031_((float)(f * (float)Math.PI));
        pPoseStack.m_252880_(0.0f, -f1 / 2.0f, f2);
        float f3 = RenderHandMapLikeEvent.calculateMapTilt(pPitch);
        pPoseStack.m_252880_(0.0f, 0.04f + pEquippedProgress * -1.2f + f3 * -0.5f, -0.72f);
        pPoseStack.m_252781_(Axis.f_252529_.m_252977_(f3 * -85.0f));
        if (!mc.f_91074_.m_20145_()) {
            pPoseStack.m_85836_();
            pPoseStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
            RenderHandMapLikeEvent.renderMapHand(mc, pPoseStack, pBuffer, pCombinedLight, HumanoidArm.RIGHT);
            RenderHandMapLikeEvent.renderMapHand(mc, pPoseStack, pBuffer, pCombinedLight, HumanoidArm.LEFT);
            pPoseStack.m_85849_();
        }
        float f4 = Mth.m_14031_((float)(f * (float)Math.PI));
        pPoseStack.m_252781_(Axis.f_252529_.m_252977_(f4 * 20.0f));
        pPoseStack.m_85841_(2.0f, 2.0f, 2.0f);
        RenderHandMapLikeEvent.doRenderOnHand(mc, pPoseStack, pBuffer, pCombinedLight, pStack, MapLikeRenderContext.BOTH_HANDS);
    }

    private static void doRenderOnHand(Minecraft mc, PoseStack pPoseStack, MultiBufferSource pBuffer, int pCombinedLight, ItemStack pStack, MapLikeRenderContext context) {
        Item item = pStack.m_41720_();
        if (item instanceof MapLikeRenderItem) {
            MapLikeRenderItem mli = (MapLikeRenderItem)item;
            MapLikeRenderer mlr = mli.getRenderer();
            pPoseStack.m_85836_();
            pPoseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
            pPoseStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
            pPoseStack.m_85841_(0.38f, 0.38f, 0.38f);
            pPoseStack.m_252880_(-0.5f, -0.5f, 0.0f);
            pPoseStack.m_85841_(0.0078125f, 0.0078125f, 0.0078125f);
            mlr.extraTransform(pPoseStack, context);
            float height = mlr.getHeight(context);
            float width = mlr.getWidth(context);
            CommonMapLike.renderBgSliced(64.0f - width / 2.0f, -7.0f, 64.0f + width / 2.0f, height - 7.0f, 8.0f, pPoseStack, pBuffer, pCombinedLight, mlr.backgroundRenderType(mc, pPoseStack, pBuffer, pCombinedLight, pStack));
            if (pBuffer instanceof MultiBufferSource.BufferSource) {
                MultiBufferSource.BufferSource bs = (MultiBufferSource.BufferSource)pBuffer;
                bs.m_109911_();
                pPoseStack.m_252880_(64.0f - width / 2.0f, -7.0f, -1.0f);
                pPoseStack.m_85841_(1.0f, 1.0f, -1.0f);
                CustomGraphics graphics = new CustomGraphics(mc, pPoseStack, bs);
                RenderSystem.enableDepthTest();
                ItemStackLighting.setup(pPoseStack);
                mlr.renderOnHand(graphics, pStack, pCombinedLight, context);
                ItemStackLighting.restore();
                graphics.flush();
            }
            pPoseStack.m_85849_();
        }
    }

    private static void renderPlayerArm(Minecraft mc, PoseStack pPoseStack, MultiBufferSource pBuffer, int pCombinedLight, float pEquippedProgress, float pSwingProgress, HumanoidArm pSide) {
        boolean flag = pSide != HumanoidArm.LEFT;
        float f = flag ? 1.0f : -1.0f;
        float f1 = Mth.m_14116_((float)pSwingProgress);
        float f2 = -0.3f * Mth.m_14031_((float)(f1 * (float)Math.PI));
        float f3 = 0.4f * Mth.m_14031_((float)(f1 * ((float)Math.PI * 2)));
        float f4 = -0.4f * Mth.m_14031_((float)(pSwingProgress * (float)Math.PI));
        pPoseStack.m_252880_(f * (f2 + 0.64000005f), f3 + -0.6f + pEquippedProgress * -0.6f, f4 + -0.71999997f);
        pPoseStack.m_252781_(Axis.f_252436_.m_252977_(f * 45.0f));
        float f5 = Mth.m_14031_((float)(pSwingProgress * pSwingProgress * (float)Math.PI));
        float f6 = Mth.m_14031_((float)(f1 * (float)Math.PI));
        pPoseStack.m_252781_(Axis.f_252436_.m_252977_(f * f6 * 70.0f));
        pPoseStack.m_252781_(Axis.f_252403_.m_252977_(f * f5 * -20.0f));
        LocalPlayer abstractclientplayer = mc.f_91074_;
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)abstractclientplayer.m_108560_());
        pPoseStack.m_252880_(f * -1.0f, 3.6f, 3.5f);
        pPoseStack.m_252781_(Axis.f_252403_.m_252977_(f * 120.0f));
        pPoseStack.m_252781_(Axis.f_252529_.m_252977_(200.0f));
        pPoseStack.m_252781_(Axis.f_252436_.m_252977_(f * -135.0f));
        pPoseStack.m_252880_(f * 5.6f, 0.0f, 0.0f);
        PlayerRenderer playerrenderer = (PlayerRenderer)mc.m_91290_().m_114382_((Entity)abstractclientplayer);
        if (flag) {
            playerrenderer.m_117770_(pPoseStack, pBuffer, pCombinedLight, (AbstractClientPlayer)abstractclientplayer);
        } else {
            playerrenderer.m_117813_(pPoseStack, pBuffer, pCombinedLight, (AbstractClientPlayer)abstractclientplayer);
        }
    }

    public static interface MapLikeRenderItem {
        public MapLikeRenderer getRenderer();

        default public boolean available(ItemStack stack) {
            return true;
        }
    }

    public static enum MapLikeRenderContext {
        MAIN_HAND,
        OFF_HAND,
        BOTH_HANDS,
        ITEM_FRAME_LARGE,
        ITEM_FRAME_SMALL,
        ITEM_FRAME_SIDE;

    }

    public static interface MapLikeRenderer {
        default public float getWidth(MapLikeRenderContext context) {
            return 142.0f;
        }

        default public float getHeight(MapLikeRenderContext context) {
            return 142.0f;
        }

        public RenderType backgroundRenderType(Minecraft var1, PoseStack var2, MultiBufferSource var3, int var4, ItemStack var5);

        public void renderOnHand(ICustomGraphics var1, ItemStack var2, int var3, MapLikeRenderContext var4);

        default public void extraTransform(PoseStack pPoseStack, MapLikeRenderContext context) {
        }
    }
}

