/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.items;

import com.github.tartaricacid.touhoulittlemaid.api.bauble.IMaidBauble;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.inventory.handler.BaubleItemHandler;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;
import oshi.util.tuples.Pair;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideData;
import studio.fantasyit.maid_storage_manager.craft.work.CraftLayer;
import studio.fantasyit.maid_storage_manager.craft.work.CraftLayerChain;
import studio.fantasyit.maid_storage_manager.craft.work.SolvedCraftLayer;
import studio.fantasyit.maid_storage_manager.items.MaidInteractItem;
import studio.fantasyit.maid_storage_manager.items.RequestListItem;
import studio.fantasyit.maid_storage_manager.maid.ChatTexts;
import studio.fantasyit.maid_storage_manager.maid.behavior.ScheduleBehavior;
import studio.fantasyit.maid_storage_manager.maid.memory.CraftMemory;
import studio.fantasyit.maid_storage_manager.maid.memory.ViewedInventoryMemory;
import studio.fantasyit.maid_storage_manager.registry.ItemRegistry;
import studio.fantasyit.maid_storage_manager.storage.Target;
import studio.fantasyit.maid_storage_manager.util.Conditions;
import studio.fantasyit.maid_storage_manager.util.MemoryUtil;
import studio.fantasyit.maid_storage_manager.util.RequestItemUtil;
import studio.fantasyit.maid_storage_manager.util.StorageAccessUtil;

public class WorkCardItem
extends MaidInteractItem
implements IMaidBauble {
    public void onTick(EntityMaid maid, ItemStack baubleItem) {
        if (maid.m_9236_().f_46443_) {
            return;
        }
        this.checkTask(maid, baubleItem);
        this.syncTaskWorkPos(maid, baubleItem);
        this.tryDispatch(maid, baubleItem);
        this.tryDispatchFind(maid, baubleItem);
    }

    private void syncTaskWorkPos(EntityMaid maid, ItemStack baubleItem) {
        Entity entity;
        CraftMemory craftMemory = MemoryUtil.getCrafting(maid);
        if (!craftMemory.hasPlan()) {
            return;
        }
        CraftLayerChain plan = craftMemory.plan();
        if (plan.isMaster()) {
            return;
        }
        UUID masterUUID = plan.getMasterUUID();
        if (masterUUID != null && (entity = ((ServerLevel)maid.m_9236_()).m_8791_(masterUUID)) instanceof EntityMaid) {
            EntityMaid toMaid = (EntityMaid)entity;
            maid.getSchedulePos().restrictTo(toMaid);
        }
    }

    private void checkTask(EntityMaid maid, ItemStack baubleItem) {
        CraftMemory craftMemory = MemoryUtil.getCrafting(maid);
        if (craftMemory.hasPlan()) {
            craftMemory.plan().checkDispatchedValidation(maid);
        }
    }

    protected void tryDispatch(EntityMaid maid, ItemStack baubleItem) {
        if (MemoryUtil.getCurrentlyWorking(maid) != ScheduleBehavior.Schedule.REQUEST) {
            return;
        }
        if (!MemoryUtil.getRequestProgress(maid).isTryCrafting()) {
            return;
        }
        CraftMemory crafting = MemoryUtil.getCrafting(maid);
        if (!crafting.hasPlan() || !crafting.plan().isMaster()) {
            return;
        }
        if (crafting.isGoPlacingBeforeCraft()) {
            return;
        }
        CraftLayerChain plan = crafting.plan();
        if (plan.getIsStoppingAdding()) {
            return;
        }
        WorkCardItem.getNearbyMaidsSameGroup(maid, baubleItem, true, false).stream().sorted(Comparator.comparingDouble(toMaid -> toMaid.m_20270_((Entity)maid))).forEach(toMaid -> {
            @Nullable Pair<CraftLayer, SolvedCraftLayer> dispatchLayerData = plan.getAndDispatchLayer((EntityMaid)toMaid);
            if (dispatchLayerData == null) {
                return;
            }
            SolvedCraftLayer node = (SolvedCraftLayer)dispatchLayerData.getB();
            CraftLayer dispatchLayer = (CraftLayer)dispatchLayerData.getA();
            List targetItems = dispatchLayer.getCraftData().map(CraftGuideData::getAllOutputItems).map(t -> t.stream().map(i -> i.m_255036_(i.m_41613_() * dispatchLayer.getCount())).toList()).orElseThrow();
            CraftLayerChain newPlan = new CraftLayerChain((EntityMaid)toMaid);
            newPlan.setMaster(maid.m_20148_(), MemoryUtil.getRequestProgress(maid).getWorkUUID());
            newPlan.addLayer(dispatchLayer.copyWithNoState());
            newPlan.addLayer(new CraftLayer(Optional.empty(), targetItems, 1));
            ItemStack dispatchedRequest = RequestItemUtil.makeVirtualItemStack(targetItems, null, (Entity)maid, "DISPATCHED");
            CompoundTag data = new CompoundTag();
            data.m_128362_("master", maid.m_20148_());
            data.m_128405_("index", node.index());
            RequestListItem.setVirtualData(dispatchedRequest, data);
            MemoryUtil.getCrafting(toMaid).setGatheringDispatched(true);
            MemoryUtil.getCrafting(toMaid).setPlan(newPlan);
            MemoryUtil.getRequestProgress(toMaid).newWork(RequestListItem.getUUID(dispatchedRequest));
            MemoryUtil.getRequestProgress(toMaid).setTryCrafting(true);
            toMaid.m_21008_(InteractionHand.MAIN_HAND, dispatchedRequest);
            plan.doDispatchLayer(node, toMaid.m_20148_(), RequestListItem.getUUID(dispatchedRequest));
            plan.showCraftingProgress(maid);
            newPlan.showCraftingProgress((EntityMaid)toMaid);
            MemoryUtil.getViewedInventory(toMaid).receiveFrom(MemoryUtil.getViewedInventory(maid));
            MemoryUtil.clearTarget(toMaid);
            MemoryUtil.getCrafting(toMaid).clearTarget();
            MemoryUtil.getCrafting(toMaid).clearIgnoreTargets();
            MemoryUtil.getCrafting(toMaid).addIgnoreTargets(crafting.getIgnoreTargets());
            MemoryUtil.getCrafting(toMaid).resetAndMarkVis((ServerLevel)maid.m_9236_(), (EntityMaid)toMaid);
            newPlan.setStatusMessage((EntityMaid)toMaid, (Component)Component.m_237115_((String)"chat_bubbles.maid_storage_manager.crafting.dispatch_received"));
        });
    }

    protected void tryDispatchFind(EntityMaid maid, ItemStack baubleItem) {
        if (Conditions.takingRequestList(maid) && maid.m_20202_() != null && maid.m_21205_().m_150930_((Item)ItemRegistry.REQUEST_LIST_ITEM.get())) {
            if (MemoryUtil.getRequestProgress(maid).isTryCrafting()) {
                return;
            }
            if (MemoryUtil.getRequestProgress(maid).isReturning()) {
                return;
            }
            if (MemoryUtil.getCurrentlyWorking(maid) != ScheduleBehavior.Schedule.REQUEST) {
                return;
            }
            List<EntityMaid> nearbyMaidsSameGroup = WorkCardItem.getNearbyMaidsSameGroup(maid, baubleItem, true, false);
            if (!nearbyMaidsSameGroup.isEmpty()) {
                EntityMaid toMaid = nearbyMaidsSameGroup.get(0);
                ItemStack itemStack = RequestItemUtil.makeVirtualItemStack(maid.m_21205_(), "DISPATCH_FIND");
                CompoundTag data = new CompoundTag();
                data.m_128362_("master", maid.m_20148_());
                RequestListItem.setVirtualData(itemStack, data);
                toMaid.m_21008_(InteractionHand.MAIN_HAND, itemStack);
                maid.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
                ChatTexts.send(maid, (Component)Component.m_237110_((String)"chat_bubbles.maid_storage_manager.request_dispatch_find", (Object[])new Object[]{toMaid.m_7755_()}));
            }
        }
    }

    public static boolean matches(ItemStack incoming, ItemStack source) {
        return !incoming.m_41788_() || source.m_41788_() && source.m_41786_().equals(incoming.m_41786_());
    }

    protected static boolean hasBaubleAndAvailable(EntityMaid maid, ItemStack source, boolean requireAvailable, boolean reversed) {
        if (requireAvailable) {
            if (MemoryUtil.getCurrentlyWorking(maid) != ScheduleBehavior.Schedule.VIEW) {
                return false;
            }
            if (!maid.m_21205_().m_41619_()) {
                return false;
            }
            if (maid.isMaidInSittingPose()) {
                return false;
            }
            if (maid.m_20202_() != null) {
                return false;
            }
            if (MemoryUtil.getViewedInventory(maid).isViewing()) {
                return false;
            }
            if (!Conditions.isNothingToPlace(maid)) {
                return false;
            }
        }
        BaubleItemHandler t = maid.getMaidBauble();
        for (int i = 0; i < t.getSlots(); ++i) {
            if (!t.getStackInSlot(i).m_150930_((Item)ItemRegistry.WORK_CARD.get()) || (reversed ? !WorkCardItem.matches(source, t.getStackInSlot(i)) : !WorkCardItem.matches(t.getStackInSlot(i), source))) continue;
            return true;
        }
        return false;
    }

    public static List<Component> getAllWorkCards(EntityMaid maid) {
        ArrayList<Component> workCards = new ArrayList<Component>();
        BaubleItemHandler inv = maid.getMaidBauble();
        for (int i = 0; i < inv.getSlots(); ++i) {
            if (!inv.getStackInSlot(i).m_150930_((Item)ItemRegistry.WORK_CARD.get())) continue;
            workCards.add(inv.getStackInSlot(i).m_41786_());
        }
        return workCards;
    }

    public static List<EntityMaid> getNearbyMaidsSameGroup(EntityMaid maid, boolean requireAvailable, boolean propagate) {
        return WorkCardItem.getNearbyMaidsSameGroup(maid, requireAvailable, propagate, false);
    }

    public static List<EntityMaid> getNearbyMaidsSameGroup(EntityMaid maid, boolean requireAvailable, boolean propagate, boolean reversed) {
        ArrayList<EntityMaid> maids = new ArrayList<EntityMaid>();
        HashSet<Component> hasChecked = new HashSet<Component>();
        LinkedList<ItemStack> queue = new LinkedList<ItemStack>();
        BaubleItemHandler inv = maid.getMaidBauble();
        for (int i = 0; i < inv.getSlots(); ++i) {
            if (!inv.getStackInSlot(i).m_150930_((Item)ItemRegistry.WORK_CARD.get())) continue;
            queue.add(inv.getStackInSlot(i));
            if (!inv.getStackInSlot(i).m_41788_() && reversed) {
                return WorkCardItem.getNearbyMaidsSameGroup(maid, inv.getStackInSlot(i), requireAvailable, reversed);
            }
            hasChecked.add(inv.getStackInSlot(i).m_41786_());
        }
        while (!queue.isEmpty()) {
            ItemStack stack = (ItemStack)queue.poll();
            List<EntityMaid> tmp = WorkCardItem.getNearbyMaidsSameGroup(maid, stack, requireAvailable, reversed);
            for (EntityMaid nearbyMaid : tmp) {
                if (maids.stream().noneMatch(m -> m.m_20148_().equals(nearbyMaid.m_20148_()))) {
                    maids.add(nearbyMaid);
                }
                if (!propagate) continue;
                BaubleItemHandler tt = nearbyMaid.getMaidBauble();
                for (int i = 0; i < tt.getSlots(); ++i) {
                    if (!tt.getStackInSlot(i).m_150930_((Item)ItemRegistry.WORK_CARD.get())) continue;
                    if (!tt.getStackInSlot(i).m_41788_()) {
                        return WorkCardItem.getNearbyMaidsSameGroup(maid, inv.getStackInSlot(i), requireAvailable, reversed);
                    }
                    if (hasChecked.contains(tt.getStackInSlot(i).m_41786_())) continue;
                    queue.add(tt.getStackInSlot(i));
                    hasChecked.add(tt.getStackInSlot(i).m_41786_());
                }
            }
        }
        return maids;
    }

    public static List<EntityMaid> getNearbyMaidsSameGroup(EntityMaid maid, ItemStack baubleItem, boolean requireAvailable, boolean reversed) {
        Level level = maid.m_9236_();
        return level.m_142425_(EntityTypeTest.m_156916_(EntityMaid.class), WorkCardItem.getMaidFindingBBox(maid), t -> WorkCardItem.hasBaubleAndAvailable(t, baubleItem, requireAvailable, reversed) && !t.m_20148_().equals(maid.m_20148_()));
    }

    private static AABB getMaidFindingBBox(EntityMaid maid) {
        if (maid.m_21536_()) {
            return new AABB(maid.m_21534_()).m_82400_((double)maid.m_21535_());
        }
        return new AABB(maid.m_20183_()).m_82400_(7.0);
    }

    public static void syncStorageOn(EntityMaid maid, Target ambitiousTarget, int holdStamp) {
        Target target = MemoryUtil.getViewedInventory(maid).ambitiousPos((ServerLevel)maid.m_9236_(), ambitiousTarget);
        Map<String, List<ViewedInventoryMemory.ItemCount>> itemsAt = MemoryUtil.getViewedInventory(maid).getItemsAtInternal(target);
        ServerLevel level = (ServerLevel)maid.m_9236_();
        WorkCardItem.getNearbyMaidsSameGroup(maid, false, true, true).forEach(toMaid -> {
            if (!StorageAccessUtil.isValidTarget(level, toMaid, target, false)) {
                return;
            }
            ViewedInventoryMemory toMem = MemoryUtil.getViewedInventory(toMaid);
            if (toMem.isLockedAmbitious(level, target)) {
                return;
            }
            if (toMem.isHolding(holdStamp)) {
                return;
            }
            toMem.resetViewedInvForPos(target);
            StorageAccessUtil.checkNearByContainers((Level)level, target.getPos(), pos -> toMem.resetViewedInvForPosAsRemoved(target.sameType((BlockPos)pos, null)));
            toMem.setItemsAtInternal(target, itemsAt);
            toMem.addVisitedPos(target);
        });
    }
}

