/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.items;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.fantasyit.maid_storage_manager.menu.InventoryListScreen;
import studio.fantasyit.maid_storage_manager.network.Network;

public class WrittenInvListItem
extends Item {
    public static final String TAG_UUID = "uuid";
    public static final String TAG_AUTHOR = "author";
    public static final String TAG_TIME = "time";

    public WrittenInvListItem() {
        super(new Item.Properties().m_41487_(1));
    }

    @OnlyIn(value=Dist.CLIENT)
    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level level, @NotNull Player player, @NotNull InteractionHand p_41434_) {
        if (level.f_46443_) {
            CompoundTag tag = player.m_21205_().m_41784_();
            if (tag.m_128441_(TAG_UUID)) {
                Network.sendRequestListPacket(tag.m_128342_(TAG_UUID));
                Minecraft.m_91087_().m_91152_((Screen)new InventoryListScreen(tag.m_128342_(TAG_UUID)));
            }
            return InteractionResultHolder.m_19096_((Object)player.m_21120_(p_41434_));
        }
        return InteractionResultHolder.m_19098_((Object)player.m_21120_(p_41434_));
    }

    public void m_7373_(@NotNull ItemStack itemStack, @Nullable Level p_41422_, List<Component> tooltip, TooltipFlag p_41424_) {
        super.m_7373_(itemStack, p_41422_, tooltip, p_41424_);
        CompoundTag tag = itemStack.m_41784_();
        tooltip.add((Component)Component.m_237115_((String)"tooltip.maid_storage_manager.written_request_list.desc").m_130940_(ChatFormatting.GRAY));
        if (tag.m_128441_(TAG_AUTHOR)) {
            tooltip.add((Component)Component.m_237110_((String)"tooltip.maid_storage_manager.request_list.author", (Object[])new Object[]{tag.m_128461_(TAG_AUTHOR)}));
        }
        if (tag.m_128441_(TAG_TIME)) {
            tooltip.add((Component)Component.m_237110_((String)"tooltip.maid_storage_manager.request_list.time", (Object[])new Object[]{this.getTimeStr(tag.m_128454_(TAG_TIME))}));
        }
    }

    private String getTimeStr(long aLong) {
        long day = aLong / 24000L;
        long hour = (aLong - day * 24000L) / 1000L;
        long minute = (aLong - day * 24000L - hour * 1000L) * 60L / 1000L;
        return Component.m_237110_((String)"tooltip.maid_storage_manager.request_list.time.str", (Object[])new Object[]{String.valueOf(day), String.format("%02d", hour), String.format("%02d", minute)}).getString();
    }
}

