/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.maid.behavior.request;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.mojang.authlib.GameProfile;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import studio.fantasyit.maid_storage_manager.Config;
import studio.fantasyit.maid_storage_manager.registry.MemoryModuleRegistry;
import studio.fantasyit.maid_storage_manager.util.MemoryUtil;

public class InteractAfterDone
extends Behavior<EntityMaid> {
    int ticks = 0;

    public InteractAfterDone() {
        super(Map.of((MemoryModuleType)MemoryModuleRegistry.INTERACTION_RESULT.get(), MemoryStatus.VALUE_PRESENT));
    }

    protected void start(ServerLevel p_22540_, EntityMaid p_22541_, long p_22542_) {
        this.ticks = 0;
    }

    protected void tick(ServerLevel p_22551_, EntityMaid p_22552_, long p_22553_) {
        ++this.ticks;
        if (this.ticks % 4 == 0) {
            MemoryUtil.setTarget(p_22552_, MemoryUtil.getInteractPos(p_22552_), (float)Config.collectSpeed);
        }
    }

    protected boolean canStillUse(ServerLevel p_22545_, EntityMaid p_22546_, long p_22547_) {
        return this.ticks < 20;
    }

    protected void stop(ServerLevel level, EntityMaid maid, long p_22550_) {
        this.tryInteract(level, maid);
        MemoryUtil.clearInteractPos(maid);
        MemoryUtil.clearTarget(maid);
    }

    private void tryInteract(ServerLevel level, EntityMaid maid) {
        BlockPos interactPos = MemoryUtil.getInteractPos(maid);
        if (interactPos == null) {
            return;
        }
        BlockPos target = null;
        if (!level.m_8055_(interactPos).m_60808_((BlockGetter)level, interactPos).m_83281_()) {
            target = interactPos;
        } else if (!level.m_8055_(interactPos.m_7494_()).m_60808_((BlockGetter)level, interactPos.m_7494_()).m_83281_()) {
            target = interactPos.m_7494_();
        }
        if (target == null) {
            return;
        }
        FakePlayer fakePlayer = FakePlayerFactory.get((ServerLevel)level, (GameProfile)new GameProfile(UUID.randomUUID(), maid.m_7755_().getString()));
        fakePlayer.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
        ClipContext rayTraceContext = new ClipContext(maid.m_20318_(0.0f).m_82520_(0.0, (double)maid.m_20192_(), 0.0), target.m_252807_(), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)fakePlayer);
        BlockHitResult result = level.m_45547_(rayTraceContext);
        if (!result.m_82425_().equals((Object)target)) {
            return;
        }
        PlayerInteractEvent.RightClickBlock event = ForgeHooks.onRightClickBlock((Player)fakePlayer, (InteractionHand)InteractionHand.MAIN_HAND, (BlockPos)target, (BlockHitResult)result);
        if (event.getUseBlock() != Event.Result.DENY) {
            level.m_8055_(target).m_60664_((Level)level, (Player)fakePlayer, InteractionHand.MAIN_HAND, result);
        }
        Containers.m_19002_((Level)level, (BlockPos)target, (Container)fakePlayer.m_150109_());
        fakePlayer.m_150109_().m_6211_();
        fakePlayer.m_142687_(Entity.RemovalReason.DISCARDED);
    }
}

