/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.maid.behavior.request.craft.ret;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.item.ItemStack;
import studio.fantasyit.maid_storage_manager.craft.work.CraftLayer;
import studio.fantasyit.maid_storage_manager.craft.work.CraftLayerChain;
import studio.fantasyit.maid_storage_manager.debug.DebugData;
import studio.fantasyit.maid_storage_manager.items.RequestListItem;
import studio.fantasyit.maid_storage_manager.maid.behavior.ScheduleBehavior;
import studio.fantasyit.maid_storage_manager.maid.memory.CraftMemory;
import studio.fantasyit.maid_storage_manager.util.Conditions;
import studio.fantasyit.maid_storage_manager.util.MemoryUtil;

public class ReturnOnVehicleBehavior
extends Behavior<EntityMaid> {
    public ReturnOnVehicleBehavior() {
        super(Map.of());
    }

    protected boolean checkExtraStartConditions(ServerLevel p_22538_, EntityMaid maid) {
        if (MemoryUtil.getCurrentlyWorking(maid) != ScheduleBehavior.Schedule.REQUEST) {
            return false;
        }
        if (MemoryUtil.getRequestProgress(maid).isReturning()) {
            return false;
        }
        if (!Conditions.takingRequestList(maid)) {
            return false;
        }
        if (MemoryUtil.getCrafting(maid).isGatheringDispatched()) {
            return false;
        }
        if (!MemoryUtil.getCrafting(maid).hasPlan()) {
            return false;
        }
        if (!MemoryUtil.getCrafting(maid).plan().hasCurrent()) {
            return false;
        }
        return !MemoryUtil.getCrafting(maid).plan().getCurrentLayer().getCraftData().isPresent();
    }

    protected void start(ServerLevel level, EntityMaid maid, long p_22542_) {
        CraftMemory crafting = MemoryUtil.getCrafting(maid);
        CraftLayerChain plan = crafting.plan();
        CraftLayer layer = plan.getCurrentLayer();
        if (!layer.getItems().isEmpty()) {
            plan.setStatusMessage(maid, (Component)Component.m_237110_((String)"chat_bubbles.maid_storage_manager.crafting_success", (Object[])new Object[]{layer.getItems().get(0).m_41786_()}).m_130940_(ChatFormatting.GREEN));
        }
        DebugData.sendDebug("[REQUEST_CRAFT_WORK] Step Done. Set Success.", new Object[0]);
        for (int i = 0; i < layer.getItems().size(); ++i) {
            ItemStack itemStack = layer.getItems().get(i);
            if (itemStack.m_41619_()) continue;
            RequestListItem.updateCollectedItem(maid.m_21205_(), itemStack, itemStack.m_41613_(), true);
        }
        MemoryUtil.getCrafting(maid).lastSuccess();
        plan.finishCurrentLayer(maid);
        plan.showCraftingProgress(maid);
        MemoryUtil.getCrafting(maid).resetAndMarkVis(level, maid);
        MemoryUtil.getRequestProgress(maid).setReturn();
        MemoryUtil.getRequestProgress(maid).clearTarget();
        MemoryUtil.clearTarget(maid);
    }
}

