/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.maid.behavior.request.find;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.MaidPathFindingBFS;
import com.github.tartaricacid.touhoulittlemaid.init.InitEntities;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import oshi.util.tuples.Pair;
import studio.fantasyit.maid_storage_manager.Config;
import studio.fantasyit.maid_storage_manager.debug.DebugData;
import studio.fantasyit.maid_storage_manager.items.RequestListItem;
import studio.fantasyit.maid_storage_manager.maid.behavior.ScheduleBehavior;
import studio.fantasyit.maid_storage_manager.maid.behavior.base.MaidMoveToBlockTaskWithArrivalMap;
import studio.fantasyit.maid_storage_manager.maid.data.StorageManagerConfigData;
import studio.fantasyit.maid_storage_manager.maid.memory.RequestProgressMemory;
import studio.fantasyit.maid_storage_manager.maid.memory.ViewedInventoryMemory;
import studio.fantasyit.maid_storage_manager.storage.MaidStorage;
import studio.fantasyit.maid_storage_manager.storage.StoragePredictor;
import studio.fantasyit.maid_storage_manager.storage.Target;
import studio.fantasyit.maid_storage_manager.util.Conditions;
import studio.fantasyit.maid_storage_manager.util.ItemStackUtil;
import studio.fantasyit.maid_storage_manager.util.MemoryUtil;
import studio.fantasyit.maid_storage_manager.util.MoveUtil;
import studio.fantasyit.maid_storage_manager.util.PosUtil;

public class RequestFindMoveBehavior
extends MaidMoveToBlockTaskWithArrivalMap {
    ItemStack checkItem = null;
    Target chestPos = null;
    Target returnPos = null;

    public RequestFindMoveBehavior() {
        super((float)Config.collectSpeed, 3);
        this.verticalSearchStart = 1;
    }

    protected boolean checkExtraStartConditions(@NotNull ServerLevel worldIn, @NotNull EntityMaid owner) {
        if (MemoryUtil.getCurrentlyWorking(owner) != ScheduleBehavior.Schedule.REQUEST) {
            return false;
        }
        if (!Conditions.takingRequestList(owner)) {
            return false;
        }
        if (MemoryUtil.getRequestProgress(owner).isReturning()) {
            return false;
        }
        if (MemoryUtil.getRequestProgress(owner).isTryCrafting()) {
            return false;
        }
        if (MemoryUtil.getRequestProgress(owner).isCheckingStock()) {
            return false;
        }
        if (Conditions.shouldCheckStock(owner)) {
            return false;
        }
        return Conditions.inventoryNotFull(owner) && !Conditions.listAllDone(owner);
    }

    protected void start(ServerLevel level, EntityMaid maid, long p_22542_) {
        super.m_6735_(level, (LivingEntity)maid, p_22542_);
        MemoryUtil.getRequestProgress(maid).clearCheckItem();
        this.checkItem = null;
        if (!this.priorityTarget(level, maid) && (Conditions.useScanTarget(maid) || RequestListItem.isBlackMode(maid.m_21205_()))) {
            this.searchForDestination(level, maid);
        }
        RequestProgressMemory requestProgress = MemoryUtil.getRequestProgress(maid);
        if (!maid.m_6274_().m_21874_((MemoryModuleType)InitEntities.TARGET_POS.get())) {
            if (MemoryUtil.getRequestProgress(maid).confirmNoTarget()) {
                DebugData.sendDebug("[REQUEST_FIND]No More Target", new Object[0]);
                MemoryUtil.getRequestProgress(maid).setTryCrafting(true);
                MemoryUtil.getRequestProgress(maid).setReturn();
                MemoryUtil.getRequestProgress(maid).clearTarget();
                MemoryUtil.clearTarget(maid);
            }
        } else {
            MemoryUtil.getRequestProgress(maid).resetFailCount();
            if (this.chestPos != null) {
                requestProgress.setTarget(this.chestPos);
                maid.m_6274_().m_21879_(MemoryModuleType.f_26371_, (Object)new BlockPosTracker(this.chestPos.getPos()));
            }
            if (this.checkItem != null) {
                requestProgress.setCheckItem(this.checkItem);
            }
        }
    }

    private boolean priorityTarget(ServerLevel level, EntityMaid maid) {
        if (!Conditions.usePriorityTarget(maid)) {
            return false;
        }
        if (RequestListItem.isBlackMode(maid.m_21205_())) {
            return false;
        }
        List<Pair<ItemStack, Integer>> notDone = RequestListItem.getItemStacksNotDone(maid.m_21205_(), true);
        boolean matchTag = RequestListItem.matchNbt(maid.m_21205_());
        Map<Target, List<ViewedInventoryMemory.ItemCount>> viewed = MemoryUtil.getViewedInventory(maid).positionFlatten();
        MaidPathFindingBFS pathFinding = new MaidPathFindingBFS(maid.m_21573_().m_26575_(), level, maid);
        for (Map.Entry<Target, List<ViewedInventoryMemory.ItemCount>> blockPos : viewed.entrySet()) {
            List<BlockPos> possiblePos;
            if (MemoryUtil.getRequestProgress(maid).isVisitedPos(blockPos.getKey())) continue;
            Optional<ViewedInventoryMemory.ItemCount> targetItem = blockPos.getValue().stream().filter(itemCount -> notDone.stream().anyMatch(i2 -> ItemStackUtil.isSame((ItemStack)i2.getA(), itemCount.item(), matchTag))).findFirst();
            @Nullable Target storage = MaidStorage.getInstance().isValidTarget(level, (LivingEntity)maid, blockPos.getKey().getPos(), blockPos.getKey().side);
            if (storage == null) continue;
            boolean craftGuideProvider = MaidStorage.getInstance().isCraftGuideProvider(storage, blockPos.getValue());
            if (StorageManagerConfigData.get(maid).useMemorizedCraftGuide()) {
                craftGuideProvider = false;
            }
            if (targetItem.isEmpty() && !craftGuideProvider || !MoveUtil.isValidTarget(level, maid, storage, false) || (possiblePos = MoveUtil.getAllAvailablePosForTarget(level, maid, blockPos.getKey().getPos(), pathFinding)).isEmpty()) continue;
            @Nullable BlockPos targetPos = MoveUtil.getNearestFromTargetList(level, maid, possiblePos);
            if (targetPos == null) {
                pathFinding = new MaidPathFindingBFS(maid.m_21573_().m_26575_(), level, maid);
                continue;
            }
            this.chestPos = storage;
            MemoryUtil.setTarget(maid, targetPos, (float)Config.placeSpeed);
            DebugData.sendDebug("[REQUEST_FIND]Priority By Filter %s", storage);
            targetItem.ifPresent(itemCount -> {
                this.checkItem = itemCount.getFirst();
            });
            return true;
        }
        return false;
    }

    protected boolean shouldMoveTo(@NotNull ServerLevel serverLevel, EntityMaid entityMaid, @NotNull BlockPos blockPos) {
        if (!PosUtil.isSafePos((Level)serverLevel, blockPos)) {
            return false;
        }
        RequestProgressMemory requestProgress = MemoryUtil.getRequestProgress(entityMaid);
        Target canTouchChest = MoveUtil.findTargetForPos(serverLevel, entityMaid, blockPos, requestProgress, false, StoragePredictor::isCollectable);
        if (canTouchChest != null) {
            this.chestPos = canTouchChest;
            DebugData.sendDebug("[REQUEST_FIND]Target %s", canTouchChest);
        }
        return canTouchChest != null;
    }
}

