/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.maid.behavior.request.ret;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitEntities;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import org.jetbrains.annotations.Nullable;
import studio.fantasyit.maid_storage_manager.Config;
import studio.fantasyit.maid_storage_manager.debug.DebugData;
import studio.fantasyit.maid_storage_manager.items.RequestListItem;
import studio.fantasyit.maid_storage_manager.maid.behavior.ScheduleBehavior;
import studio.fantasyit.maid_storage_manager.storage.MaidStorage;
import studio.fantasyit.maid_storage_manager.storage.Target;
import studio.fantasyit.maid_storage_manager.util.Conditions;
import studio.fantasyit.maid_storage_manager.util.MemoryUtil;
import studio.fantasyit.maid_storage_manager.util.MoveUtil;
import studio.fantasyit.maid_storage_manager.util.RequestItemUtil;

public class RequestRetMoveBehavior
extends Behavior<EntityMaid> {
    public RequestRetMoveBehavior() {
        super(Map.of(MemoryModuleType.f_26370_, MemoryStatus.VALUE_ABSENT, (MemoryModuleType)InitEntities.TARGET_POS.get(), MemoryStatus.VALUE_ABSENT));
    }

    protected boolean checkExtraStartConditions(ServerLevel level, EntityMaid maid) {
        if (MemoryUtil.getCurrentlyWorking(maid) != ScheduleBehavior.Schedule.REQUEST) {
            return false;
        }
        if (!Conditions.takingRequestList(maid)) {
            return false;
        }
        if (MemoryUtil.getRequestProgress(maid).isReturning()) {
            return true;
        }
        if (MemoryUtil.getRequestProgress(maid).isCheckingStock()) {
            return false;
        }
        if (MemoryUtil.getRequestProgress(maid).isTryCrafting()) {
            return false;
        }
        return Conditions.listAllDone(maid) || Conditions.inventoryFull(maid);
    }

    protected void start(ServerLevel level, EntityMaid maid, long p_22542_) {
        Entity entity;
        if (Conditions.isNothingToPlace(maid) && MemoryUtil.getRequestProgress(maid).isTryCrafting()) {
            MemoryUtil.getRequestProgress(maid).setReturn(false);
            return;
        }
        @Nullable Target target = RequestListItem.getStorageBlock(maid.m_21205_());
        @Nullable Target storage = target == null ? null : MaidStorage.getInstance().isValidTarget(level, (LivingEntity)maid, target.getPos(), target.side);
        @Nullable UUID uuid = RequestListItem.getStorageEntity(maid.m_21205_());
        Entity entity2 = entity = uuid == null ? null : level.m_8791_(uuid);
        if (target != null && storage != null) {
            BlockPos goal = MoveUtil.selectPosForTarget(level, maid, target.pos);
            if (goal == null) {
                DebugData.sendDebug("[REQUEST_RET] Unavailable target, waiting", new Object[0]);
                return;
            }
            DebugData.sendDebug("[REQUEST_RET] Return target %s", storage);
            MemoryUtil.setTarget(maid, goal, (float)Config.collectSpeed);
            MemoryUtil.getRequestProgress(maid).setReturn();
            MemoryUtil.getRequestProgress(maid).setTarget(storage);
        } else if (entity != null) {
            MemoryUtil.setTarget(maid, entity, (float)Config.collectSpeed);
            MemoryUtil.getRequestProgress(maid).setReturn();
            MemoryUtil.getRequestProgress(maid).setTargetEntity(entity.m_20148_());
        } else if (!MemoryUtil.getRequestProgress(maid).isTryCrafting()) {
            DebugData.sendDebug("[REQUEST_RET] No target", new Object[0]);
            RequestListItem.markAllDone(maid.m_21205_());
            RequestItemUtil.stopJobAndStoreOrThrowItem(maid, null, null);
            MemoryUtil.setReturnToScheduleAt(maid, level.m_7654_().m_129921_() + 600);
        } else {
            MemoryUtil.getRequestProgress(maid).setReturn(false);
            MemoryUtil.getRequestProgress(maid).clearTarget();
            MemoryUtil.getCrafting(maid).clearTarget();
            MemoryUtil.clearTarget(maid);
        }
    }
}

