/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.menu;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.anti_ad.mc.ipn.api.IPNIgnore;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import oshi.util.tuples.Pair;
import studio.fantasyit.maid_storage_manager.menu.ItemSelectorMenu;
import studio.fantasyit.maid_storage_manager.menu.base.AbstractFilterScreen;
import studio.fantasyit.maid_storage_manager.menu.base.IItemTarget;
import studio.fantasyit.maid_storage_manager.menu.container.ButtonWidget;
import studio.fantasyit.maid_storage_manager.menu.container.FilterContainer;
import studio.fantasyit.maid_storage_manager.menu.container.FilterSlot;
import studio.fantasyit.maid_storage_manager.menu.container.InventorySelectButton;
import studio.fantasyit.maid_storage_manager.network.ItemSelectorGuiPacket;
import studio.fantasyit.maid_storage_manager.network.Network;
import studio.fantasyit.maid_storage_manager.registry.ItemRegistry;
import studio.fantasyit.maid_storage_manager.util.InventoryListUtil;
import studio.fantasyit.maid_storage_manager.util.ItemStackUtil;
import yalter.mousetweaks.api.MouseTweaksDisableWheelTweak;

@MouseTweaksDisableWheelTweak
@IPNIgnore
public class ItemSelectorScreen
extends AbstractFilterScreen<ItemSelectorMenu>
implements IItemTarget {
    private final ResourceLocation background = new ResourceLocation("maid_storage_manager", "textures/gui/item_selector.png");
    AbstractWidget repeatControl;
    InventorySelectButton inventorySelectButton;

    public ItemSelectorScreen(ItemSelectorMenu p_97741_, Inventory p_97742_, Component p_97743_) {
        super(p_97741_, p_97742_, p_97743_);
        this.f_97726_ = 176;
        this.f_97727_ = 200;
        this.f_97731_ = this.f_97727_ - 94;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.addButtons();
        this.addRepeatControl();
        this.addInventoryListButton();
        this.refreshUUID(true);
    }

    protected List<Component> getTooltipForResult(int slot) {
        FilterContainer filteredItems = ((ItemSelectorMenu)this.m_6262_()).filteredItems;
        ItemStack listItem = null;
        if (Minecraft.m_91087_().f_91074_ != null) {
            listItem = Minecraft.m_91087_().f_91074_.m_21120_(InteractionHand.MAIN_HAND);
        }
        List<ItemStack> itemStackStream = null;
        MutableComponent additionFailMessage = null;
        if (listItem != null) {
            CompoundTag tag = listItem.m_41784_();
            itemStackStream = tag.m_128437_("items", 10).m_128728_(slot).m_128437_("missing", 10).stream().map(t -> ItemStackUtil.parseStack((CompoundTag)t)).toList();
            if (tag.m_128441_("fail")) {
                additionFailMessage = Component.m_237115_((String)tag.m_128461_("fail"));
            }
        }
        List tooltip = this.m_280553_(filteredItems.m_8020_(slot));
        Integer collected = filteredItems.collected[slot].getValue();
        Integer requested = filteredItems.count[slot].getValue();
        if (filteredItems.done[slot].getValue() == 1) {
            if (requested <= collected || collected == -1) {
                tooltip.add(Component.m_237115_((String)"tooltip.maid_storage_manager.request_list.done_success").m_130940_(ChatFormatting.GREEN));
            } else {
                tooltip.add(Component.m_237115_((String)"tooltip.maid_storage_manager.request_list.done_fail").m_130940_(ChatFormatting.RED));
            }
        } else {
            tooltip.add(Component.m_237115_((String)"tooltip.maid_storage_manager.request_list.processing").m_130940_(ChatFormatting.YELLOW));
        }
        if (itemStackStream != null && !itemStackStream.isEmpty()) {
            tooltip.add(Component.m_237115_((String)"tooltip.maid_storage_manager.request_list.missing_items").m_130940_(ChatFormatting.RED));
            for (ItemStack itemStack : itemStackStream) {
                tooltip.add(Component.m_237110_((String)"tooltip.maid_storage_manager.request_list.missing_items_item", (Object[])new Object[]{itemStack.m_41786_(), itemStack.m_41613_()}));
            }
        }
        if (additionFailMessage != null) {
            tooltip.add(additionFailMessage.m_6881_().m_130940_(ChatFormatting.RED));
        }
        tooltip.add(Component.m_237110_((String)"tooltip.maid_storage_manager.request_list.collected", (Object[])new Object[]{collected, String.valueOf(requested == -1 ? "*" : requested)}));
        return tooltip;
    }

    private void addButtons() {
        this.m_142416_((GuiEventListener)new ButtonWidget(119, 70, 16, 16, this.background, widget -> {
            if (((ItemSelectorMenu)this.m_6262_()).matchTag) {
                return new Pair((Object)208, (Object)(widget.m_274382_() ? 16 : 0));
            }
            return new Pair((Object)224, (Object)(widget.m_274382_() ? 16 : 0));
        }, () -> ((ItemSelectorMenu)this.m_6262_()).matchTag ? Component.m_237115_((String)"gui.maid_storage_manager.request_list.match_tag_on") : Component.m_237115_((String)"gui.maid_storage_manager.request_list.match_tag_off"), () -> {
            ((ItemSelectorMenu)this.m_6262_()).matchTag = !((ItemSelectorMenu)this.m_6262_()).matchTag;
            Network.sendItemSelectorGuiPacket(ItemSelectorGuiPacket.SlotType.MATCH_TAG, 0, ((ItemSelectorMenu)this.m_6262_()).matchTag ? 1 : 0);
        }, this));
        this.m_142416_((GuiEventListener)new ButtonWidget(148, 70, 16, 16, this.background, widget -> {
            if (((ItemSelectorMenu)this.m_6262_()).stockMode) {
                return new Pair((Object)176, (Object)(widget.m_274382_() ? 48 : 32));
            }
            return new Pair((Object)192, (Object)(widget.m_274382_() ? 48 : 32));
        }, () -> ((ItemSelectorMenu)this.m_6262_()).stockMode ? Component.m_237115_((String)"gui.maid_storage_manager.request_list.stock_mode_on") : Component.m_237115_((String)"gui.maid_storage_manager.request_list.stock_mode_off"), () -> {
            boolean bl = ((ItemSelectorMenu)this.m_6262_()).stockMode = !((ItemSelectorMenu)this.m_6262_()).stockMode;
            if (((ItemSelectorMenu)this.m_6262_()).stockMode) {
                ((ItemSelectorMenu)this.m_6262_()).blackmode = false;
                Network.sendItemSelectorGuiPacket(ItemSelectorGuiPacket.SlotType.BLACKLIST, 0, 0);
            }
            Network.sendItemSelectorGuiPacket(ItemSelectorGuiPacket.SlotType.STOCKMODE, 0, ((ItemSelectorMenu)this.m_6262_()).stockMode ? 1 : 0);
        }, this));
        this.m_142416_((GuiEventListener)new ButtonWidget(119, 91, 16, 16, this.background, widget -> {
            if (((ItemSelectorMenu)this.m_6262_()).blackmode) {
                return new Pair((Object)192, (Object)(widget.m_274382_() ? 16 : 0));
            }
            return new Pair((Object)176, (Object)(widget.m_274382_() ? 16 : 0));
        }, () -> ((ItemSelectorMenu)this.m_6262_()).blackmode ? Component.m_237115_((String)"gui.maid_storage_manager.request_list.blackmode_on") : Component.m_237115_((String)"gui.maid_storage_manager.request_list.blackmode_off"), () -> {
            boolean bl = ((ItemSelectorMenu)this.m_6262_()).blackmode = !((ItemSelectorMenu)this.m_6262_()).blackmode;
            if (((ItemSelectorMenu)this.m_6262_()).blackmode) {
                ((ItemSelectorMenu)this.m_6262_()).stockMode = false;
                Network.sendItemSelectorGuiPacket(ItemSelectorGuiPacket.SlotType.STOCKMODE, 0, 0);
            }
            Network.sendItemSelectorGuiPacket(ItemSelectorGuiPacket.SlotType.BLACKLIST, 0, ((ItemSelectorMenu)this.m_6262_()).blackmode ? 1 : 0);
        }, this));
        this.m_142416_((GuiEventListener)new ButtonWidget(148, 91, 16, 16, this.background, widget -> new Pair((Object)208, (Object)(widget.m_274382_() ? 48 : 32)), () -> Component.m_237115_((String)"gui.maid_storage_manager.request_list.clear"), () -> {
            ((ItemSelectorMenu)this.m_6262_()).shouldClear = true;
            Network.sendItemSelectorGuiPacket(ItemSelectorGuiPacket.SlotType.CLEAR, 0, 1);
        }, this));
    }

    private void addRepeatControl() {
        this.repeatControl = (AbstractWidget)this.m_142416_((GuiEventListener)new AbstractWidget(116, 26, 52, 28, (Component)Component.m_237115_((String)"gui.maid_storage_manager.request_list.repeat")){

            public void m_5716_(double p_93634_, double p_93635_) {
                ((ItemSelectorMenu)((ItemSelectorScreen)ItemSelectorScreen.this).f_97732_).unitSecond = !((ItemSelectorMenu)((ItemSelectorScreen)ItemSelectorScreen.this).f_97732_).unitSecond;
                Network.sendItemSelectorGuiPacket(ItemSelectorGuiPacket.SlotType.UNITSECOND, 0, ((ItemSelectorMenu)((ItemSelectorScreen)ItemSelectorScreen.this).f_97732_).unitSecond ? 1 : 0);
            }

            public int m_252754_() {
                return ItemSelectorScreen.this.getGuiLeft() + super.m_252754_();
            }

            public int m_252907_() {
                return ItemSelectorScreen.this.getGuiTop() + super.m_252907_();
            }

            protected void m_87963_(GuiGraphics graphics, int p_268034_, int p_268009_, float p_268085_) {
                graphics.m_280614_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237115_((String)"gui.maid_storage_manager.request_list.repeat"), this.m_252754_() + 6, this.m_252907_() + 4, 0xFFFFFF, false);
                MutableComponent repeatDesc = Component.m_237115_((String)"gui.maid_storage_manager.request_list.never");
                if (((ItemSelectorMenu)ItemSelectorScreen.this.m_6262_()).repeat != 0) {
                    repeatDesc = ((ItemSelectorMenu)ItemSelectorScreen.this.m_6262_()).unitSecond ? Component.m_237110_((String)"gui.maid_storage_manager.request_list.repeat_desc_s", (Object[])new Object[]{String.valueOf(((ItemSelectorMenu)ItemSelectorScreen.this.m_6262_()).repeat)}) : Component.m_237110_((String)"gui.maid_storage_manager.request_list.repeat_desc_t", (Object[])new Object[]{String.valueOf(((ItemSelectorMenu)ItemSelectorScreen.this.m_6262_()).repeat)});
                }
                graphics.m_280614_(Minecraft.m_91087_().f_91062_, (Component)repeatDesc, this.m_252754_() + 5, this.m_252907_() + 15, 3046706, false);
            }

            public boolean m_6050_(double p_94734_, double p_94735_, double p_94736_) {
                int dv = (int)(Math.abs(p_94736_) / p_94736_);
                if (InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)340)) {
                    dv *= 10;
                }
                if (InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)341)) {
                    dv *= 10;
                }
                ((ItemSelectorMenu)ItemSelectorScreen.this.m_6262_()).repeat = Math.max(0, Math.min(((ItemSelectorMenu)ItemSelectorScreen.this.m_6262_()).repeat + dv, 72000));
                Network.sendItemSelectorGuiPacket(ItemSelectorGuiPacket.SlotType.REPEAT, 0, ((ItemSelectorMenu)ItemSelectorScreen.this.m_6262_()).repeat);
                return true;
            }

            protected void m_168797_(NarrationElementOutput p_259858_) {
                p_259858_.m_169146_(NarratedElementType.HINT, this.m_6035_());
            }
        });
    }

    protected void addInventoryListButton() {
        this.inventorySelectButton = (InventorySelectButton)this.m_142416_((GuiEventListener)new InventorySelectButton(this.getGuiLeft() + 8, this.getGuiTop() + 50, (Screen)this));
    }

    protected void m_181908_() {
        this.refreshUUID(false);
    }

    protected void refreshUUID(boolean force) {
        UUID inventoryListUUIDFromPlayerInv;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null && (player.f_19797_ % 20 == 0 || force) && (inventoryListUUIDFromPlayerInv = InventoryListUtil.getInventoryListUUIDFromPlayerInv((List<ItemStack>)player.f_36093_.f_35974_)) != null) {
            this.inventorySelectButton.setUUID(inventoryListUUIDFromPlayerInv);
        }
    }

    protected void m_7286_(GuiGraphics guiGraphics, float p_97788_, int p_97789_, int p_97790_) {
        this.m_280273_(guiGraphics);
        int relX = (this.f_96543_ - this.f_97726_) / 2;
        int relY = (this.f_96544_ - this.f_97727_) / 2;
        guiGraphics.m_280398_(this.background, relX, relY, 0, 0.0f, 0.0f, this.f_97726_, this.f_97727_, 256, 256);
        guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 0.5f);
        guiGraphics.m_280480_(((Item)ItemRegistry.STORAGE_DEFINE_BAUBLE.get()).m_7968_(), relX + 8, relY + 71);
        guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
    }

    protected void m_280072_(@NotNull GuiGraphics graphics, int x, int y) {
        if (((ItemSelectorMenu)this.f_97732_).m_142621_().m_41619_()) {
            int inGuiX = x - this.getGuiLeft();
            int inGuiY = y - this.getGuiTop();
            for (Slot slot : ((ItemSelectorMenu)this.m_6262_()).f_38839_) {
                if (slot.f_40220_ > inGuiX || slot.f_40220_ + 30 < inGuiX || slot.f_40221_ > inGuiY || slot.f_40221_ + 16 < inGuiY || !(slot instanceof FilterSlot)) continue;
                FilterSlot filterSlot = (FilterSlot)slot;
                if (!filterSlot.m_7993_().m_41619_()) {
                    graphics.m_280677_(this.f_96547_, this.getTooltipForResult(filterSlot.m_150661_()), Optional.empty(), x, y);
                }
                return;
            }
            this.m_6702_().forEach(renderable -> {
                if (renderable.m_5953_((double)x, (double)y)) {
                    if (renderable instanceof ButtonWidget) {
                        ButtonWidget buttonWidget = (ButtonWidget)((Object)renderable);
                        graphics.m_280557_(this.f_96547_, buttonWidget.getTooltipComponent(), x, y);
                    } else if (renderable instanceof InventorySelectButton) {
                        InventorySelectButton buttonWidget = (InventorySelectButton)((Object)renderable);
                        graphics.m_280557_(this.f_96547_, buttonWidget.getTooltipComponent(), x, y);
                    } else if (this.repeatControl == renderable) {
                        graphics.renderTooltip(this.f_96547_, List.of(Component.m_237115_((String)"gui.maid_storage_manager.request_list.scroll_to_adjust"), Component.m_237115_((String)"gui.maid_storage_manager.request_list.click_to_switch")), Optional.empty(), ItemStack.f_41583_, x, y);
                    }
                }
            });
        }
        super.m_280072_(graphics, x, y);
    }

    public void m_88315_(GuiGraphics graphics, int p_283661_, int p_281248_, float p_281886_) {
        super.m_88315_(graphics, p_283661_, p_281248_, p_281886_);
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_(0.0f, 0.0f, 2000.0f);
        this.m_280072_(graphics, p_283661_, p_281248_);
        graphics.m_280168_().m_85849_();
        RenderSystem.disableDepthTest();
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_(0.0f, 0.0f, 1000.0f);
        int relX = (this.f_96543_ - this.f_97726_) / 2;
        int relY = (this.f_96544_ - this.f_97727_) / 2;
        FilterContainer filters = ((ItemSelectorMenu)this.m_6262_()).filteredItems;
        for (Slot slot : ((ItemSelectorMenu)this.m_6262_()).f_38839_) {
            FilterSlot filterSlot;
            if (!(slot instanceof FilterSlot) || !(filterSlot = (FilterSlot)slot).m_6657_()) continue;
            MutableInt count = filters.count[filterSlot.m_150661_()];
            MutableInt done = filters.done[filterSlot.m_150661_()];
            MutableInt collected = filters.collected[filterSlot.m_150661_()];
            String text = String.valueOf(count.getValue());
            if (count.getValue() == -1) {
                text = "*";
            }
            graphics.m_280168_().m_85836_();
            graphics.m_280168_().m_85841_(0.6f, 0.6f, 1.0f);
            int n = (int)(((double)(relX + filterSlot.f_40220_ + 16) - (double)this.f_96547_.m_92895_(text) * 0.6) / (double)0.6f);
            double d = relY + filterSlot.f_40221_ + 16;
            Objects.requireNonNull(this.f_96547_);
            graphics.m_280488_(this.f_96547_, text, n, (int)((d - 9.0 * 0.6) / (double)0.6f), 0xFFFFFF);
            String collectedStr = String.valueOf(collected.getValue());
            int n2 = (int)(((double)(relX + filterSlot.f_40220_ + 30) - (double)this.f_96547_.m_92895_(collectedStr) * 0.6) / 0.6);
            double d2 = relY + filterSlot.f_40221_ + 16;
            Objects.requireNonNull(this.f_96547_);
            graphics.m_280488_(this.f_96547_, collectedStr, n2, (int)((d2 - 9.0 * 0.6) / 0.6), 0xFFFFFF);
            graphics.m_280168_().m_85849_();
            if (done.getValue() == 0) continue;
            if (collected.getValue() < count.getValue() && count.getValue() != -1 && !((ItemSelectorMenu)this.f_97732_).blackmode) {
                graphics.m_280398_(this.background, relX + filterSlot.f_40220_ + 20, relY + filterSlot.f_40221_ + 4, 0, 179.0f, 83.0f, 10, 10, 256, 256);
                continue;
            }
            graphics.m_280398_(this.background, relX + filterSlot.f_40220_ + 20, relY + filterSlot.f_40221_ + 4, 0, 179.0f, 67.0f, 10, 10, 256, 256);
        }
        graphics.m_280168_().m_85849_();
        RenderSystem.enableDepthTest();
    }

    public boolean m_6050_(double p_94686_, double p_94687_, double p_94688_) {
        @Nullable Slot slot = this.getSlotUnderMouse();
        if (slot instanceof FilterSlot) {
            FilterSlot filterSlot = (FilterSlot)slot;
            MutableInt count = ((ItemSelectorMenu)this.m_6262_()).filteredItems.count[filterSlot.m_150661_()];
            int dv = (int)(Math.abs(p_94688_) / p_94688_);
            if (InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)340)) {
                dv *= 10;
            }
            if (dv > 0) {
                if (count.addAndGet(dv) == 0) {
                    count.addAndGet(1);
                }
            } else if (count.addAndGet(dv) <= 0) {
                count.setValue(-1);
            }
            Network.sendItemSelectorGuiPacket(ItemSelectorGuiPacket.SlotType.COUNT, filterSlot.m_150661_(), count.getValue());
        }
        return super.m_6050_(p_94686_, p_94687_, p_94688_);
    }

    @Override
    public void accept(FilterSlot menu, ItemStack item) {
        ItemStack itemStack = item.m_255036_(1);
        ((ItemSelectorMenu)this.m_6262_()).filteredItems.m_6836_(menu.m_150661_(), itemStack);
        Network.sendItemSelectorSetItemPacket(menu.m_150661_(), itemStack);
    }

    @Override
    public List<FilterSlot> getSlots() {
        return ((ItemSelectorMenu)this.m_6262_()).f_38839_.stream().filter(slot -> slot instanceof FilterSlot).map(slot -> (FilterSlot)((Object)slot)).toList();
    }

    @Override
    public void itemSelected(ItemStack stack) {
        for (FilterSlot slot : this.getSlots()) {
            if (!slot.m_6659_() || !slot.m_7993_().m_41619_()) continue;
            this.accept(slot, stack);
            break;
        }
    }
}

