/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.menu.craft.base;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideData;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideRenderData;
import studio.fantasyit.maid_storage_manager.menu.container.FilterSlot;
import studio.fantasyit.maid_storage_manager.menu.container.ISaveFilter;
import studio.fantasyit.maid_storage_manager.menu.craft.base.ICraftGuiPacketReceiver;
import studio.fantasyit.maid_storage_manager.menu.craft.base.StepDataContainer;
import studio.fantasyit.maid_storage_manager.util.ItemStackUtil;

public abstract class AbstractCraftMenu<T extends AbstractCraftMenu<?>>
extends AbstractContainerMenu
implements ISaveFilter,
ICraftGuiPacketReceiver {
    ItemStack target;
    protected Player player;
    protected CraftGuideData craftGuideData;
    public StepDataContainer stepDataContainer = null;
    public Map<Integer, Predicate<ItemStack>> slotFilter = new HashMap<Integer, Predicate<ItemStack>>();

    public AbstractCraftMenu(MenuType<T> p_38851_, int p_38852_, Player player) {
        super(p_38851_, p_38852_);
        this.player = player;
        this.target = player.m_21205_();
        this.craftGuideData = CraftGuideData.fromItemStack(this.target);
        this.stepDataContainer = new StepDataContainer(this.craftGuideData.getSteps().get(0), (AbstractContainerMenu)this);
        this.addFilterSlots();
        this.addPlayerSlots();
        this.addSpecialSlots();
        if (!player.m_9236_().f_46443_) {
            this.recalculateRecipe();
        }
    }

    protected abstract void addFilterSlots();

    protected void addPlayerSlots() {
        int i;
        int cellHeight = 18;
        int cellWidth = 18;
        int startY = 164;
        int startX = 8;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)this.player.m_150109_(), 9 + i * 9 + j, 8 + j * 18, 164 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)this.player.m_150109_(), i, 8 + i * 18, 222));
        }
    }

    protected void addSpecialSlots() {
    }

    protected void setSlotFilter(Slot slot, Predicate<ItemStack> filter) {
        this.slotFilter.put(slot.m_150661_(), filter);
    }

    protected void setSlotFilter(int containerIndex, Predicate<ItemStack> filter) {
        this.slotFilter.put(containerIndex, filter);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void m_150399_(int slotId, int dragType, ClickType clickTypeIn, Player player) {
        Slot slot;
        if (slotId >= 0 && (slot = this.m_38853_(slotId)) instanceof FilterSlot) {
            FilterSlot fs = (FilterSlot)slot;
            slot = fs.f_40218_;
            if (slot instanceof StepDataContainer) {
                ItemStack insert;
                StepDataContainer container = (StepDataContainer)slot;
                if (fs.readonly) {
                    return;
                }
                int slot2 = fs.m_150661_();
                if (clickTypeIn == ClickType.THROW) {
                    return;
                }
                ItemStack held = this.m_142621_();
                if (clickTypeIn == ClickType.CLONE) {
                    if (!player.m_7500_()) return;
                    if (!held.m_41619_()) return;
                    ItemStack stackInSlot = container.m_8020_(slot2).m_41777_();
                    stackInSlot.m_41764_(stackInSlot.m_41741_());
                    this.m_142503_(stackInSlot);
                    this.save();
                    return;
                }
                if (held.m_41619_()) {
                    insert = ItemStack.f_41583_;
                } else {
                    insert = held.m_41777_();
                    insert.m_41764_(1);
                }
                if (!this.isValidFor(slot2, insert)) {
                    return;
                }
                if (player.m_9236_().f_46443_) return;
                container.m_6836_(slot2, insert);
                container.setCount(slot2, 1);
                this.m_38853_(slotId).m_6654_();
                this.save();
                return;
            }
        }
        super.m_150399_(slotId, dragType, clickTypeIn, player);
    }

    protected boolean isValidFor(Slot slot, ItemStack itemStack) {
        return this.isValidFor(slot.m_150661_(), itemStack);
    }

    protected boolean isValidFor(int slot, ItemStack itemStack) {
        return itemStack.m_41619_() || !this.slotFilter.containsKey(slot) || this.slotFilter.get(slot).test(itemStack);
    }

    public void m_6199_(Container p_38868_) {
        if (this.stepDataContainer == null) {
            return;
        }
        super.m_6199_(p_38868_);
        this.save();
    }

    @NotNull
    public ItemStack m_7648_(Player p_38941_, int p_38942_) {
        Slot slot = this.m_38853_(p_38942_);
        if (slot.m_6657_()) {
            if (slot instanceof FilterSlot) {
                FilterSlot fs = (FilterSlot)slot;
                fs.m_5852_(ItemStack.f_41583_);
            } else {
                boolean found = false;
                int toPlace = -1;
                for (int j = 0; j < this.stepDataContainer.m_6643_(); ++j) {
                    if (this.stepDataContainer.m_8020_(j).m_41619_()) {
                        if (!this.isValidFor(j, slot.m_7993_()) || toPlace != -1) continue;
                        toPlace = j;
                        continue;
                    }
                    if (!ItemStackUtil.isSameInCrafting(this.stepDataContainer.m_8020_(j), slot.m_7993_())) continue;
                    found = true;
                }
                if (!found && toPlace != -1) {
                    this.stepDataContainer.m_6836_(toPlace, slot.m_7993_().m_255036_(1));
                    this.save();
                }
            }
        }
        return ItemStack.f_41583_;
    }

    public boolean m_6875_(Player player) {
        return player.m_21205_() == this.target;
    }

    public boolean m_5622_(Slot p_38945_) {
        return !(p_38945_ instanceof FilterSlot);
    }

    @Override
    public void save() {
        if (this.stepDataContainer == null) {
            return;
        }
        if (this.player.m_9236_().f_46443_) {
            return;
        }
        this.m_38946_();
        this.recalculateRecipe();
        this.stepDataContainer.save();
        this.craftGuideData.buildInputAndOutputs();
        this.craftGuideData.saveToItemStack(this.target);
        CraftGuideRenderData.recalculateItemStack(this.target);
        this.m_38946_();
    }

    public abstract void recalculateRecipe();
}

