/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.menu.craft.common;

import dev.emi.emi.api.recipe.EmiPlayerInventory;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.handler.EmiCraftContext;
import dev.emi.emi.api.recipe.handler.EmiRecipeHandler;
import dev.emi.emi.api.stack.EmiStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideStepData;
import studio.fantasyit.maid_storage_manager.menu.craft.common.CommonCraftMenu;
import studio.fantasyit.maid_storage_manager.network.CraftGuideGuiPacket;
import studio.fantasyit.maid_storage_manager.network.Network;
import studio.fantasyit.maid_storage_manager.util.InventoryListUtil;
import studio.fantasyit.maid_storage_manager.util.ItemStackUtil;

public class EmiCommonRecipeHandler
implements EmiRecipeHandler<CommonCraftMenu> {
    public EmiPlayerInventory getInventory(AbstractContainerScreen<CommonCraftMenu> screen) {
        return new EmiPlayerInventory(List.of());
    }

    public boolean supportsRecipe(EmiRecipe recipe) {
        return true;
    }

    public boolean alwaysDisplaySupport(EmiRecipe recipe) {
        return true;
    }

    protected boolean work(EmiRecipe recipe, EmiCraftContext<CommonCraftMenu> context, boolean doTransfer) {
        CommonCraftMenu container = (CommonCraftMenu)context.getScreenHandler();
        ArrayList outputs = new ArrayList();
        recipe.getOutputs().stream().map(e -> e.getEmiStacks().stream().map(EmiStack::getItemStack).findFirst()).filter(Optional::isPresent).map(Optional::get).forEach(i -> ItemStackUtil.addToList((List<ItemStack>)outputs, i.m_41777_(), true));
        ArrayList inputs = new ArrayList();
        recipe.getInputs().stream().map(e -> InventoryListUtil.getMatchingForPlayer(e.getEmiStacks().stream().map(EmiStack::getItemStack).toList())).filter(i -> !i.m_41619_()).forEach(i -> ItemStackUtil.addToList((List<ItemStack>)inputs, i.m_41777_(), true));
        int inputId = 0;
        int outputId = 0;
        CompoundTag data = new CompoundTag();
        ListTag inputTag = new ListTag();
        ListTag outputTag = new ListTag();
        for (CraftGuideStepData step : container.craftGuideData.steps) {
            int i2;
            for (i2 = 0; i2 < step.actionType.inputCount(); ++i2) {
                if (inputId >= inputs.size()) continue;
                if (doTransfer) {
                    inputTag.add((Object)ItemStackUtil.saveStack((ItemStack)inputs.get(inputId)));
                }
                ++inputId;
            }
            for (i2 = 0; i2 < step.actionType.outputCount(); ++i2) {
                if (outputId >= outputs.size()) continue;
                if (doTransfer) {
                    outputTag.add((Object)ItemStackUtil.saveStack((ItemStack)outputs.get(outputId)));
                }
                ++outputId;
            }
        }
        if (doTransfer) {
            data.m_128365_("inputs", (Tag)inputTag);
            data.m_128365_("outputs", (Tag)outputTag);
            Network.INSTANCE.sendToServer((Object)new CraftGuideGuiPacket(CraftGuideGuiPacket.Type.SET_ALL_INPUT, 0, 0, data));
        }
        return inputId == inputs.size() && outputId == outputs.size();
    }

    public boolean canCraft(EmiRecipe recipe, EmiCraftContext<CommonCraftMenu> context) {
        return this.work(recipe, context, false);
    }

    public boolean craft(EmiRecipe recipe, EmiCraftContext<CommonCraftMenu> context) {
        return this.work(recipe, context, true);
    }
}

