/*
 * Decompiled with CFR 0.152.
 */
package com.renyigesai.bakeries.block.moka_pot;

import com.renyigesai.bakeries.init.BakeriesBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.items.ItemStackHandler;

public class MokaPotBlockEntity
extends BlockEntity {
    protected final ItemStackHandler inventory = new ItemStackHandler(1);
    public int cookingTotalTime;
    public boolean fill;

    public MokaPotBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)BakeriesBlocks.MOKA_POT_ENTITY.get(), pPos, pBlockState);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.m_142466_(pkt.m_131708_());
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_("Inventory")) {
            this.inventory.deserializeNBT(tag.m_128469_("Inventory"));
        }
        this.cookingTotalTime = tag.m_128451_("CookingTotalTime");
        this.fill = tag.m_128471_("Fill");
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
        tag.m_128405_("CookingTotalTime", this.cookingTotalTime);
        tag.m_128379_("Fill", this.fill);
    }

    public boolean isInventoryFull() {
        return this.inventory.getStackInSlot(0).m_41619_();
    }

    public int getCookingTotalTime() {
        return this.cookingTotalTime;
    }

    public boolean getFill() {
        return this.fill;
    }

    public void addGroundCoffee(ItemStack stack) {
        this.inventory.setStackInSlot(0, stack);
    }

    public boolean isCraft(Level level, BlockPos pos) {
        BooleanProperty booleanProperty;
        BlockState state = level.m_8055_(pos.m_7495_());
        Property property = state.m_60734_().m_49965_().m_61081_("lit");
        return property instanceof BooleanProperty && (Boolean)state.m_61143_((Property)(booleanProperty = (BooleanProperty)property)) != false;
    }

    public static void craftTick(Level level, BlockPos pos, BlockState state, MokaPotBlockEntity blockEntity) {
        if (blockEntity.isCraft(level, pos) && !blockEntity.isInventoryFull()) {
            blockEntity.tick();
            MokaPotBlockEntity.m_155232_((Level)level, (BlockPos)pos, (BlockState)state);
            if (!level.f_46443_) {
                level.m_7260_(pos, state, state, 3);
            }
        }
    }

    public void tick() {
        if (this.inventory.getStackInSlot(0).m_204117_(ItemTags.create((ResourceLocation)new ResourceLocation("forge:coffee_grounds")))) {
            if (this.cookingTotalTime < 200) {
                ++this.cookingTotalTime;
            } else {
                this.inventory.extractItem(0, 1, false);
                this.cookingTotalTime = 0;
                this.fill = true;
            }
        }
    }
}

