/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.ai;

import com.github.tartaricacid.touhoulittlemaid.ai.service.function.IFunctionCall;
import com.github.tartaricacid.touhoulittlemaid.ai.service.function.response.ToolResponse;
import com.github.tartaricacid.touhoulittlemaid.ai.service.function.schema.parameter.ArrayParameter;
import com.github.tartaricacid.touhoulittlemaid.ai.service.function.schema.parameter.ObjectParameter;
import com.github.tartaricacid.touhoulittlemaid.ai.service.function.schema.parameter.Parameter;
import com.github.tartaricacid.touhoulittlemaid.ai.service.function.schema.parameter.StringParameter;
import com.github.tartaricacid.touhoulittlemaid.ai.service.llm.openai.request.ChatCompletion;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableInt;
import studio.fantasyit.maid_storage_manager.data.InventoryItem;
import studio.fantasyit.maid_storage_manager.maid.memory.ViewedInventoryMemory;
import studio.fantasyit.maid_storage_manager.maid.task.StorageManageTask;
import studio.fantasyit.maid_storage_manager.network.Network;
import studio.fantasyit.maid_storage_manager.storage.Target;
import studio.fantasyit.maid_storage_manager.util.ItemStackUtil;
import studio.fantasyit.maid_storage_manager.util.MemoryUtil;

public class FindAndMarkStorageFunction
implements IFunctionCall<ItemIdData> {
    public String getId() {
        return "find_mark_storage";
    }

    public String getDescription(EntityMaid entityMaid) {
        return "If you want to find the storage location of an item, you can use this tool. The tool requires you to pass in the parameter `item`, which is a list of item ID. The item ID must match the format of namespace:path, e.g. `{\"item\":[\"minecraft:egg\",\"minecraft:stone\"]}`. When the tool is used, you will get a list of locations that were found. If the tool was successfully called, the locations will be highlighted on the owner's screen. You must get ItemId from `get_storage` tool.";
    }

    public Parameter addParameters(ObjectParameter objectParameter, EntityMaid entityMaid) {
        objectParameter.addProperties("item", (Parameter)ArrayParameter.create().setItems((Parameter)StringParameter.create().setPattern("[a-zA-Z0-9_]+:[a-zA-Z0-9_]+")));
        return objectParameter;
    }

    public Codec<ItemIdData> codec() {
        return ItemIdData.CODEC;
    }

    public boolean addToChatCompletion(EntityMaid maid, ChatCompletion chatCompletion) {
        return maid.getTask().getUid().equals((Object)StorageManageTask.TASK_ID);
    }

    public ToolResponse onToolCall(ItemIdData itemIdData, EntityMaid entityMaid) {
        Map<Target, List<ViewedInventoryMemory.ItemCount>> itemKeys = MemoryUtil.getViewedInventory(entityMaid).positionFlatten();
        StringBuilder message = new StringBuilder();
        for (String itemId : itemIdData.itemId()) {
            ResourceLocation resourceLocation = new ResourceLocation(itemId);
            Item item = (Item)ForgeRegistries.ITEMS.getValue(resourceLocation);
            if (item == null) {
                message.append("Fail. Item ID: ").append(itemId).append(" is not a valid item.\n");
            }
            ItemStack itemStack = item.m_7968_();
            InventoryItem toShowItem = new InventoryItem(itemStack, 0);
            MutableBoolean found = new MutableBoolean(false);
            itemKeys.forEach((pos, list) -> {
                MutableInt count = new MutableInt(0);
                list.stream().filter(ic -> ItemStackUtil.isSame(ic.item(), itemStack, false)).forEach(ic -> count.add(ic.getSecond()));
                if (count.intValue() > 0) {
                    toShowItem.addCount((Target)pos, count.intValue());
                    found.setTrue();
                    message.append("Found ").append(count.intValue()).append(" ").append(" at ").append(pos).append("\n");
                }
            });
            if (!found.getValue().booleanValue()) {
                message.append("Fail. Item ID: ").append(itemId).append(" is not found.\n");
            }
            message.append("Success! Positions for ").append(itemId).append(" are been highlighted.\n");
            LivingEntity owner = entityMaid.m_269323_();
            if (!(owner instanceof ServerPlayer)) continue;
            ServerPlayer player = (ServerPlayer)owner;
            Network.sendShowInvPacket(player, toShowItem, 600);
        }
        message.append("Please always refer to items by their name and not their ID.");
        return new ToolResponse(message.toString());
    }

    public record ItemIdData(List<String> itemId) {
        public static Codec<ItemIdData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.listOf().fieldOf("item").forGetter(ItemIdData::itemId)).apply((Applicative)instance, ItemIdData::new));
    }
}

