/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.craft.action;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import studio.fantasyit.maid_storage_manager.craft.action.ActionOption;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideStepData;

public class ActionOptionSet {
    public final List<ActionOptionSetItem<?>> options;

    public ActionOptionSet(List<ActionOptionSetItem<?>> options) {
        this.options = new ArrayList(options);
    }

    public <T> ActionOptionSet add(ActionOption<T> option, T selection) {
        this.options.add(new ActionOptionSetItem<T>(option, selection));
        return this;
    }

    public <T> ActionOptionSet add(ActionOption<T> option, T selection, @Nullable String value) {
        this.options.add(new ActionOptionSetItem<T>(option, selection, value));
        return this;
    }

    public static <T> ActionOptionSet with(ActionOption<T> option, T selection) {
        return new ActionOptionSet(List.of(new ActionOptionSetItem<T>(option, selection)));
    }

    public static <T> ActionOptionSet with(ActionOption<T> option, T selection, String value) {
        return new ActionOptionSet(List.of(new ActionOptionSetItem<T>(option, selection, value)));
    }

    public void applyTo(CraftGuideStepData data) {
        for (ActionOptionSetItem<?> option : this.options) {
            data.setOptionSelection(option.option, option.selection);
            if (option.value == null) continue;
            data.setOptionValue(option.option, option.value);
        }
    }

    public record ActionOptionSetItem<T>(ActionOption<?> option, T selection, @Nullable String value) {
        public ActionOptionSetItem(ActionOption<?> option, T selection) {
            this(option, selection, null);
        }
    }
}

