/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.craft.action;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.MaidPathFindingBFS;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import oshi.util.tuples.Pair;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideData;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideStepData;
import studio.fantasyit.maid_storage_manager.craft.work.CraftLayer;
import studio.fantasyit.maid_storage_manager.storage.Target;
import studio.fantasyit.maid_storage_manager.util.MoveUtil;
import studio.fantasyit.maid_storage_manager.util.PosUtil;

public class PathTargetLocator {
    public static BlockPos commonNearestAvailablePos(EntityMaid maid, CraftGuideData craftGuideData, CraftGuideStepData craftGuideStepData, CraftLayer layer, MaidPathFindingBFS pathFinding) {
        return MoveUtil.selectPosForTarget((ServerLevel)maid.m_9236_(), maid, craftGuideStepData.getStorage().getPos());
    }

    public static BlockPos exactlySidedPos(EntityMaid maid, CraftGuideData craftGuideData, CraftGuideStepData craftGuideStepData, CraftLayer layer, MaidPathFindingBFS pathFinding) {
        BlockPos pos = craftGuideStepData.getStorage().getPos();
        if (craftGuideStepData.getStorage().side != null) {
            pos = pos.m_5484_(craftGuideStepData.getStorage().side, 1);
        }
        return pos;
    }

    public static BlockPos touchPos(EntityMaid maid, CraftGuideData craftGuideData, CraftGuideStepData craftGuideStepData, CraftLayer layer, MaidPathFindingBFS pathFinding) {
        List<Object> posList = new ArrayList();
        Target target = craftGuideStepData.getStorage();
        BlockPos pos = target.getPos();
        Direction side = target.side;
        posList = side != null ? List.of(pos.m_5484_(side, 2)) : Arrays.stream(Direction.values()).map(d -> pos.m_5484_(d, 2)).toList();
        List<List> allPosTmp = posList.stream().map(finalPos -> PosUtil.gatherAroundUpAndDown(finalPos, pos1 -> {
            if (PosUtil.isBetween(pos, finalPos, pos1)) {
                return null;
            }
            if (!PosUtil.isSafePos(maid.m_9236_(), pos1)) {
                return null;
            }
            if (maid.m_21444_(pos1) && pathFinding.canPathReach(pos1) && PathTargetLocator.canTouchBlock(maid, pos1, target)) {
                return pos1;
            }
            return null;
        })).filter(s -> !s.isEmpty()).toList();
        Stream<Pair> allPos = allPosTmp.stream().map(s -> s.stream().map(pos1 -> {
            Path path = maid.m_21573_().m_7864_(pos1, 0);
            if (path != null && path.m_77403_()) {
                return new Pair(pos1, (Object)path.m_77398_());
            }
            return null;
        }).filter(Objects::nonNull).toList()).filter(s -> !s.isEmpty()).map(s -> s.stream().min(Comparator.comparingInt(Pair::getB))).map(Optional::get);
        return allPos.min(Comparator.comparingInt(Pair::getB)).map(Pair::getA).orElse(null);
    }

    private static boolean canTouchBlock(EntityMaid maid, BlockPos standPos, Target target) {
        Vec3 eyePos = standPos.m_252807_().m_82520_(0.0, (double)maid.m_20192_() - 0.5, 0.0);
        for (Direction direction : Direction.values()) {
            if (target.side != null && direction != target.side) continue;
            for (float f = 0.5f; f > 0.0f; f -= 0.1f) {
                Vec3 offseted = target.pos.m_252807_().m_231075_(direction, (double)f);
                BlockHitResult clip = maid.m_9236_().m_45547_(new ClipContext(eyePos, offseted, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)maid));
                if ((clip.m_6662_() != HitResult.Type.BLOCK || !clip.m_82425_().equals((Object)target.pos)) && clip.m_6662_() != HitResult.Type.MISS || target.side != null && target.side != clip.m_82434_()) continue;
                return true;
            }
        }
        return false;
    }

    public static BlockPos throwItemPos(EntityMaid maid, CraftGuideData craftGuideData, CraftGuideStepData craftGuideStepData, CraftLayer layer, MaidPathFindingBFS pathFinding) {
        BlockPos currentTarget = craftGuideStepData.getStorage().getPos();
        if (craftGuideStepData.getStorage().side != null) {
            currentTarget = currentTarget.m_121945_(craftGuideStepData.getStorage().side);
        }
        ServerLevel level = (ServerLevel)maid.m_9236_();
        for (int i = 0; i < 4; ++i) {
            if (PathTargetLocator.validPosForThrowItem(level, maid, currentTarget, pathFinding)) {
                return currentTarget;
            }
            if (level.m_8055_(currentTarget).m_60838_((BlockGetter)level, currentTarget)) {
                return null;
            }
            if (PathTargetLocator.validPosForThrowItem(level, maid, currentTarget.m_122019_(), pathFinding)) {
                return currentTarget.m_122019_();
            }
            if (PathTargetLocator.validPosForThrowItem(level, maid, currentTarget.m_122029_(), pathFinding)) {
                return currentTarget.m_122029_();
            }
            if (PathTargetLocator.validPosForThrowItem(level, maid, currentTarget.m_122024_(), pathFinding)) {
                return currentTarget.m_122024_();
            }
            if (PathTargetLocator.validPosForThrowItem(level, maid, currentTarget.m_122012_(), pathFinding)) {
                return currentTarget.m_122012_();
            }
            currentTarget = currentTarget.m_7494_();
        }
        return null;
    }

    private static boolean validPosForThrowItem(ServerLevel level, EntityMaid maid, BlockPos pos, MaidPathFindingBFS pathFinding) {
        if (PosUtil.isSafePos((Level)level, pos) && maid.m_21444_(pos)) {
            return pathFinding.canPathReach(pos);
        }
        return false;
    }

    public static BlockPos besidePosOrExactlyPos(EntityMaid maid, CraftGuideData craftGuideData, CraftGuideStepData craftGuideStepData, CraftLayer craftLayer, MaidPathFindingBFS pathFinding) {
        BlockPos center = craftGuideStepData.getStorage().getPos();
        if (craftGuideStepData.getStorage().side != null) {
            center = center.m_5484_(craftGuideStepData.getStorage().side, 1);
        }
        return PosUtil.findAround(center, pos -> {
            if (PosUtil.isSafePos(maid.m_9236_(), pos) && maid.m_21444_(pos) && pathFinding.canPathReach(pos)) {
                return pos;
            }
            return null;
        });
    }

    public static BlockPos nearByNoLimitation(EntityMaid maid, CraftGuideData craftGuideData, CraftGuideStepData craftGuideStepData, CraftLayer craftLayer, MaidPathFindingBFS pathFinding) {
        ServerLevel level = (ServerLevel)maid.m_9236_();
        BlockPos target1 = craftGuideStepData.getStorage().getPos();
        if (craftGuideStepData.getStorage().side != null) {
            target1 = target1.m_5484_(craftGuideStepData.getStorage().side, 1);
        }
        BlockPos target = target1;
        @NotNull List<BlockPos> posListToEval = PosUtil.gatherAroundUpAndDown(target, pos -> {
            if (!PosUtil.isSafePos((Level)level, pos)) {
                return null;
            }
            if (maid.m_21444_(pos) && PosUtil.canTouch(level, pos, target) && pathFinding.canPathReach(pos)) {
                return pos;
            }
            return null;
        });
        pathFinding.finish();
        return MoveUtil.getNearestFromTargetList(level, maid, posListToEval);
    }
}

