/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.craft.algo.utils;

import java.util.ArrayList;
import java.util.List;
import studio.fantasyit.maid_storage_manager.craft.work.CraftLayer;

public class ResultListUtils {
    public static void unsetPlaceBefore(List<CraftLayer> layers) {
        for (CraftLayer layer : layers) {
            layer.clearPlaceBefore();
        }
    }

    public static List<CraftLayer> splitIntoSingleStep(List<CraftLayer> layers) {
        ArrayList<CraftLayer> result = new ArrayList<CraftLayer>();
        for (CraftLayer layer : layers) {
            if (layer.getCraftData().isEmpty()) {
                result.add(layer);
                continue;
            }
            int oCount = layer.getCount();
            boolean placeBefore = layer.shouldPlaceBefore();
            for (int i = 0; i < oCount; ++i) {
                CraftLayer newLayer = layer.copyWithNoState();
                newLayer.setCount(1);
                newLayer.setItems(newLayer.getItems().stream().map(itemStack -> itemStack.m_255036_(itemStack.m_41613_() / oCount)).toList());
                if (placeBefore) {
                    newLayer.setPlaceBefore();
                    placeBefore = false;
                }
                result.add(newLayer);
            }
        }
        return result;
    }
}

