/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.craft.generator.type.mekanism;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.infuse.InfuseType;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.recipes.ItemStackToInfuseTypeRecipe;
import mekanism.api.recipes.MetallurgicInfuserRecipe;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.common.content.blocktype.FactoryType;
import mekanism.common.recipe.MekanismRecipeType;
import mekanism.common.recipe.lookup.cache.InputRecipeCache;
import mekanism.common.tags.MekanismTags;
import mekanism.common.tile.component.config.DataType;
import mekanism.common.tile.factory.TileEntityMetallurgicInfuserFactory;
import mekanism.common.tile.machine.TileEntityMetallurgicInfuser;
import mekanism.common.tile.prefab.TileEntityConfigurableMachine;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;
import oshi.util.tuples.Pair;
import studio.fantasyit.maid_storage_manager.craft.context.common.CommonPlaceItemAction;
import studio.fantasyit.maid_storage_manager.craft.context.common.CommonTakeItemAction;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideData;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideStepData;
import studio.fantasyit.maid_storage_manager.craft.generator.algo.ICachableGeneratorGraph;
import studio.fantasyit.maid_storage_manager.craft.generator.type.mekanism.GeneratorMek;
import studio.fantasyit.maid_storage_manager.craft.type.CommonType;
import studio.fantasyit.maid_storage_manager.storage.ItemHandler.ItemHandlerStorage;
import studio.fantasyit.maid_storage_manager.storage.Target;
import studio.fantasyit.maid_storage_manager.util.MathUtil;
import studio.fantasyit.maid_storage_manager.util.StorageAccessUtil;

public class GeneratorMekInfusion
extends GeneratorMek<MetallurgicInfuserRecipe, InputRecipeCache.ItemChemical<InfuseType, InfusionStack, MetallurgicInfuserRecipe>> {
    @Override
    protected MekanismRecipeType<MetallurgicInfuserRecipe, InputRecipeCache.ItemChemical<InfuseType, InfusionStack, MetallurgicInfuserRecipe>> getRecipeType() {
        return (MekanismRecipeType)MekanismRecipeType.METALLURGIC_INFUSING.get();
    }

    protected List<Pair<ItemStack, Integer>> infusionInputs(RecipeManager manager, ChemicalStackIngredient.InfusionStackIngredient input, boolean alwaysEnrich) {
        ArrayList<Pair<ItemStack, Integer>> ret = new ArrayList<Pair<ItemStack, Integer>>();
        List infusionConverters = manager.m_44013_((RecipeType)MekanismRecipeType.INFUSION_CONVERSION.get());
        input.getRepresentations().forEach(infusionStack -> {
            if ((double)infusionStack.getAmount() > 1.0E9) {
                return;
            }
            int amount = (int)infusionStack.getAmount();
            for (ItemStackToInfuseTypeRecipe recipe : infusionConverters) {
                if (!recipe.getOutputDefinition().stream().anyMatch(output -> output.isTypeEqual((ChemicalStack)infusionStack))) continue;
                for (ItemStack possibleInput : recipe.getInput().getRepresentations()) {
                    long getAmountL;
                    if (alwaysEnrich && !possibleInput.m_204117_(MekanismTags.Items.ENRICHED) || (double)(getAmountL = ((InfusionStack)recipe.getOutput(possibleInput)).getAmount()) > 1.0E9) continue;
                    int getAmount = (int)getAmountL;
                    int totalAmount = MathUtil.lcm(getAmount, amount);
                    ret.add(new Pair((Object)possibleInput.m_255036_(totalAmount / getAmount), (Object)(totalAmount / amount)));
                }
            }
        });
        return ret;
    }

    @Override
    List<Ingredient> getRecipeIngredients(MetallurgicInfuserRecipe recipe, RecipeManager manager, Map<ResourceLocation, List<BlockPos>> recognizedTypePositions) {
        return List.of();
    }

    @Override
    protected boolean addSteps(BlockPos pos, TileEntityConfigurableMachine machine, MetallurgicInfuserRecipe recipe, List<ItemStack> inputs, List<ItemStack> outputs, List<CraftGuideStepData> steps) {
        Direction inputSide = this.getTypeDirection(machine, List.of(DataType.INPUT, DataType.INPUT_OUTPUT));
        Direction outputSide = this.getTypeDirection(machine, List.of(DataType.OUTPUT, DataType.INPUT_OUTPUT));
        Direction extra = this.getTypeDirection(machine, List.of(DataType.EXTRA));
        if (inputSide == null || outputSide == null || extra == null) {
            return false;
        }
        steps.add(new CraftGuideStepData(new Target(ItemHandlerStorage.TYPE, pos, extra), List.of(inputs.get(1)), List.of(), CommonPlaceItemAction.TYPE));
        steps.add(new CraftGuideStepData(new Target(ItemHandlerStorage.TYPE, pos, inputSide), List.of(inputs.get(0)), List.of(), CommonPlaceItemAction.TYPE));
        steps.add(new CraftGuideStepData(new Target(ItemHandlerStorage.TYPE, pos, outputSide), List.of(), List.of(outputs.get(0).m_255036_(inputs.get(0).m_41613_())), CommonTakeItemAction.TYPE));
        return true;
    }

    @Override
    public void generate(MetallurgicInfuserRecipe recipe, TileEntityConfigurableMachine machine, Level level, BlockPos pos, ICachableGeneratorGraph graph, Map<ResourceLocation, List<BlockPos>> recognizedTypePositions, StorageAccessUtil.Filter posFilter) {
        boolean alwaysEnrich = false;
        if (recognizedTypePositions.containsKey(MekanismRecipeType.ENRICHING.getRegistryName()) && !recognizedTypePositions.get(MekanismRecipeType.ENRICHING.getRegistryName()).isEmpty()) {
            alwaysEnrich = true;
        }
        List<Pair<ItemStack, Integer>> possibleInfusion = this.infusionInputs(level.m_7465_(), (ChemicalStackIngredient.InfusionStackIngredient)recipe.getChemicalInput(), alwaysEnrich);
        Ingredient ingredient = Ingredient.m_43921_(recipe.getItemInput().getRepresentations().stream());
        for (Pair<ItemStack, Integer> pair : possibleInfusion) {
            List<Ingredient> inputs = List.of(ingredient, Ingredient.m_43927_((ItemStack[])new ItemStack[]{(ItemStack)pair.getA()}));
            List<Integer> counts = List.of((Integer)pair.getB(), Integer.valueOf(((ItemStack)pair.getA()).m_41613_()));
            List outputs = recipe.getOutputDefinition();
            if (outputs.isEmpty() || !posFilter.isAvailable((ItemStack)outputs.get(0))) continue;
            ResourceLocation oid = recipe.m_6423_();
            @Nullable ResourceLocation itemKey = ForgeRegistries.ITEMS.getKey((Object)((ItemStack)pair.getA()).m_41720_());
            if (itemKey == null) continue;
            ResourceLocation id = new ResourceLocation(oid.m_135827_(), oid.m_135815_() + "_" + itemKey.m_135827_() + "_" + itemKey.m_135815_());
            graph.addRecipe(id, inputs, counts, outputs, items -> {
                ArrayList<CraftGuideStepData> step = new ArrayList<CraftGuideStepData>();
                if (this.addSteps(pos, machine, recipe, (List<ItemStack>)items, (List<ItemStack>)outputs, (List<CraftGuideStepData>)step)) {
                    return new CraftGuideData(step, CommonType.TYPE);
                }
                return null;
            });
        }
    }

    @Override
    public boolean isBlockValid(Level level, BlockPos pos) {
        TileEntityMetallurgicInfuserFactory factory;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof TileEntityMetallurgicInfuserFactory && (factory = (TileEntityMetallurgicInfuserFactory)blockEntity).getFactoryType() == FactoryType.INFUSING) {
            return true;
        }
        return level.m_7702_(pos) instanceof TileEntityMetallurgicInfuser;
    }

    @Override
    public boolean canCacheGraph() {
        return false;
    }

    @Override
    public Component getConfigName() {
        return Component.m_237115_((String)"config.maid_storage_manager.crafting.generating.mekanism.meta_infuser");
    }
}

