/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.integration.create;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.content.logistics.stockTicker.StockTickerInteractionHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;
import studio.fantasyit.maid_storage_manager.Config;
import studio.fantasyit.maid_storage_manager.api.ICreateStockKeeperMaidChecker;
import studio.fantasyit.maid_storage_manager.maid.task.StorageManageTask;
import studio.fantasyit.maid_storage_manager.network.CreateStockManagerPacket;
import studio.fantasyit.maid_storage_manager.network.Network;

public class StockManagerInteract {
    public static int lastInteractedMaidId = -1;

    public static void setInteractedMaidId(int id) {
        lastInteractedMaidId = id;
    }

    @Nullable
    protected static BlockPos getStockTickerAround(EntityMaid maid) {
        return BlockPos.m_121921_((AABB)maid.m_20191_().m_82377_((double)Config.createStockKeeperRangeV, (double)Config.createStockKeeperRangeH, (double)Config.createStockKeeperRangeV)).filter(pos -> maid.m_9236_().m_8055_(pos).m_60713_((Block)AllBlocks.STOCK_TICKER.get())).findFirst().orElse(null);
    }

    public static boolean onPlayerInteract(Player player, EntityMaid maid) {
        if (!maid.getTask().getUid().equals((Object)StorageManageTask.TASK_ID)) {
            return false;
        }
        if (player.m_21205_().m_150930_((Item)AllItems.SHOPPING_LIST.get())) {
            BlockPos pos = StockManagerInteract.getStockTickerAround(maid);
            if (pos == null) {
                player.m_213846_((Component)Component.m_237115_((String)"maid_storage_manager.no_stock_ticker"));
                return false;
            }
            if (player.m_9236_().f_46443_) {
                Network.INSTANCE.send(PacketDistributor.SERVER.noArg(), (Object)new CreateStockManagerPacket(CreateStockManagerPacket.Type.SHOP_LIST, pos, maid.m_19879_()));
            } else {
                StockManagerInteract.onHandleShoppingList((ServerPlayer)player, maid, pos);
            }
            return true;
        }
        return false;
    }

    public static void onHandleShoppingList(ServerPlayer player, EntityMaid maid, BlockPos ticker) {
        if (player.m_21205_().m_150930_((Item)AllItems.SHOPPING_LIST.get())) {
            StockTickerInteractionHandler.interactWithLogisticsManagerAt((Player)player, (Level)player.m_9236_(), (BlockPos)ticker);
        }
    }

    public static void onHandleStockManager(ServerPlayer player, EntityMaid maid, BlockPos ticker) {
        if (!maid.getTask().getUid().equals((Object)StorageManageTask.TASK_ID)) {
            return;
        }
        StockTickerInteractionHandler.interactWithLogisticsManagerAt((Player)player, (Level)player.m_9236_(), (BlockPos)ticker);
        AbstractContainerMenu abstractContainerMenu = player.f_36096_;
        if (abstractContainerMenu instanceof ICreateStockKeeperMaidChecker) {
            ICreateStockKeeperMaidChecker icsk = (ICreateStockKeeperMaidChecker)abstractContainerMenu;
            icsk.maid_storage_manager$setMaid(maid);
        }
    }
}

