/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.maid.behavior.request.craft.work;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import studio.fantasyit.maid_storage_manager.Config;
import studio.fantasyit.maid_storage_manager.craft.context.AbstractCraftActionContext;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideData;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideStepData;
import studio.fantasyit.maid_storage_manager.craft.work.CraftLayer;
import studio.fantasyit.maid_storage_manager.craft.work.CraftLayerChain;
import studio.fantasyit.maid_storage_manager.data.BoxTip;
import studio.fantasyit.maid_storage_manager.debug.DebugData;
import studio.fantasyit.maid_storage_manager.maid.behavior.ScheduleBehavior;
import studio.fantasyit.maid_storage_manager.network.Network;
import studio.fantasyit.maid_storage_manager.network.ShowCommonPacket;
import studio.fantasyit.maid_storage_manager.util.BehaviorBreath;
import studio.fantasyit.maid_storage_manager.util.Conditions;
import studio.fantasyit.maid_storage_manager.util.InvUtil;
import studio.fantasyit.maid_storage_manager.util.MemoryUtil;

public class RequestCraftWorkBehavior
extends Behavior<EntityMaid> {
    BehaviorBreath breath = new BehaviorBreath();
    AbstractCraftActionContext context;
    CraftGuideStepData craftGuideStepData;
    private CraftLayer layer;
    private CraftLayerChain plan;
    private boolean done;
    private boolean fail;
    private boolean skipped;
    private boolean hasTrySkip;
    private boolean isOccupied;
    private static final float[] colors_r = new float[]{0.91f, 0.12f, 0.39f, 1.0f};

    public RequestCraftWorkBehavior() {
        super(Map.of());
    }

    protected boolean checkExtraStartConditions(@NotNull ServerLevel level, @NotNull EntityMaid maid) {
        if (MemoryUtil.getCurrentlyWorking(maid) != ScheduleBehavior.Schedule.REQUEST) {
            return false;
        }
        if (MemoryUtil.isWorking(maid)) {
            return false;
        }
        if (!MemoryUtil.getRequestProgress(maid).isTryCrafting()) {
            return false;
        }
        if (MemoryUtil.getCrafting(maid).isGatheringDispatched()) {
            return false;
        }
        if (!MemoryUtil.getCrafting(maid).hasTarget()) {
            return false;
        }
        if (!MemoryUtil.getCrafting(maid).hasPlan()) {
            return false;
        }
        if (!MemoryUtil.getCrafting(maid).plan().isCurrentWorking()) {
            return false;
        }
        CraftGuideStepData stepData = MemoryUtil.getCrafting(maid).plan().getCurrentLayer().getStepData();
        if (stepData == null) {
            return false;
        }
        return Conditions.hasReachedValidTargetOrReset(maid, stepData.actionType.pathCloseEnoughThreshold());
    }

    protected void start(@NotNull ServerLevel level, @NotNull EntityMaid maid, long gameTimeIn) {
        this.fail = false;
        this.skipped = false;
        this.hasTrySkip = false;
        if (!MemoryUtil.getCrafting(maid).hasTarget()) {
            this.done = true;
            this.fail = true;
            return;
        }
        this.plan = MemoryUtil.getCrafting(maid).plan();
        this.layer = this.plan.getCurrentLayer();
        this.craftGuideStepData = this.layer.getStepData();
        this.plan.showCraftingProgress(maid);
        this.plan.setStatusMessage(maid, (Component)Component.m_237110_((String)"chat_bubbles.maid_storage_manager.crafting_progress", (Object[])new Object[]{this.layer.getCraftData().map(CraftGuideData::getAllOutputItems).map(l -> ((ItemStack)l.get(0)).m_41786_()).orElse((Component)Component.m_237119_()), this.layer.getDoneCount().toString(), this.layer.getCount().toString()}));
        if (this.craftGuideStepData == null) {
            MemoryUtil.getCrafting(maid).lastSuccess();
            this.done = true;
            return;
        }
        this.done = false;
        if (this.plan.checkIsCurrentOccupied(level, maid)) {
            this.tryRelease(maid);
            if (this.done) {
                return;
            }
            this.isOccupied = true;
        } else {
            this.isOccupied = false;
            this.plan.setOccupied(level, maid);
        }
        this.breath.reset();
        this.context = this.layer.startStep(maid);
        if (this.context == null) {
            this.fail = true;
            this.done = true;
            return;
        }
        this.context.loadEnv(this.layer.getEnv());
        AbstractCraftActionContext.Result start = this.context.start();
        if (start == AbstractCraftActionContext.Result.SUCCESS) {
            this.fail = false;
            this.done = true;
        } else if (start == AbstractCraftActionContext.Result.FAIL) {
            this.fail = true;
            this.done = true;
        }
        MemoryUtil.setWorking(maid, true);
        InvUtil.mergeSameStack((IItemHandler)maid.getAvailableInv(false));
    }

    protected boolean canStillUse(ServerLevel level, EntityMaid maid, long p_22547_) {
        if (!Conditions.takingRequestList(maid)) {
            return false;
        }
        if (!MemoryUtil.getRequestProgress(maid).isTryCrafting()) {
            return false;
        }
        if (!this.layer.hasCollectedAll()) {
            return false;
        }
        return !this.done;
    }

    protected void tick(ServerLevel level, EntityMaid maid, long p_22553_) {
        if (this.isOccupied) {
            if (this.plan.checkIsCurrentOccupied(level, maid)) {
                return;
            }
            this.isOccupied = false;
            this.plan.setOccupied(level, maid);
        }
        if (this.layer.addAndGetTryTick() > Config.maxCraftTries) {
            this.fail = true;
            this.done = true;
            return;
        }
        if (!this.breath.breathTick(maid)) {
            return;
        }
        AbstractCraftActionContext.Result tick = this.context.tick();
        if (this.context.skipNextBreath()) {
            this.breath.reset();
        }
        switch (tick) {
            case SUCCESS: {
                this.fail = false;
                this.done = true;
                break;
            }
            case FAIL: {
                this.fail = true;
                this.done = true;
                break;
            }
            case CONTINUE: {
                this.layer.setTryTick(0);
                break;
            }
            case NOT_DONE_INTERRUPTABLE: {
                this.tryRelease(maid);
                break;
            }
            case CONTINUE_INTERRUPTABLE: {
                this.layer.setTryTick(0);
                this.tryRelease(maid);
                break;
            }
        }
    }

    protected void tryRelease(EntityMaid maid) {
        if (!this.hasTrySkip && this.plan.tryReleaseAndStartNext()) {
            MemoryUtil.getCrafting(maid).clearTarget();
            MemoryUtil.clearTarget(maid);
            this.skipped = true;
            this.done = true;
        }
        this.hasTrySkip = true;
        if (this.plan.hasDispatchedWaitingCheck(maid)) {
            this.skipped = true;
            this.done = true;
        }
    }

    protected void stop(ServerLevel level, EntityMaid maid, long p_22550_) {
        super.m_6732_(level, (LivingEntity)maid, p_22550_);
        MemoryUtil.setWorking(maid, false);
        if (this.context != null) {
            this.context.stop();
            this.layer.setEnv(this.context.saveEnv(this.layer.getEnv()));
        }
        MemoryUtil.getCrafting(maid).clearTarget();
        MemoryUtil.clearTarget(maid);
        if (this.skipped) {
            return;
        }
        if (!MemoryUtil.getCrafting(maid).hasPlan()) {
            return;
        }
        if (this.fail) {
            EntityMaid toMaid;
            ServerLevel sl;
            Level level2;
            DebugData.sendDebug("[REQUEST_CRAFT_WORK]crafting fail", new Object[0]);
            this.plan.failCurrent(maid, this.craftGuideStepData.getItems(), "tooltip.maid_storage_manager.request_list.fail_crafting");
            Network.INSTANCE.send(PacketDistributor.TRACKING_ENTITY.with(() -> maid), (Object)new ShowCommonPacket(new BoxTip(this.craftGuideStepData.getStorage(), (Component)Component.m_237115_((String)"tip.maid_storage_manager.crafting_fail"), 600, colors_r)));
            if (!this.plan.isMaster() && (level2 = maid.m_9236_()) instanceof ServerLevel && (level2 = (sl = (ServerLevel)level2).m_8791_(this.plan.getMasterUUID())) instanceof EntityMaid && MemoryUtil.getCrafting(toMaid = (EntityMaid)level2).hasPlan()) {
                CraftLayerChain plan1 = MemoryUtil.getCrafting(toMaid).plan();
                plan1.dispatchedFail("tooltip.maid_storage_manager.request_list.fail_crafting");
            }
        } else {
            DebugData.sendDebug("[REQUEST_CRAFT_WORK]crafting done %s", this.layer.getStep());
            this.layer.nextStep();
            if (this.layer.isDone()) {
                this.plan.removeOccupied(level, maid);
                DebugData.sendDebug("[REQUEST_CRAFT_WORK]layer done", new Object[0]);
                this.plan.finishCurrentLayer(maid);
                MemoryUtil.getCrafting(maid).resetAndMarkVis(level, maid);
                this.plan.showCraftingProgress(maid);
            } else {
                this.plan.checkInputInbackpack(maid);
            }
            this.plan.handleStopAddingEvent(maid);
        }
    }

    protected boolean m_7773_(long p_22537_) {
        return false;
    }
}

