/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.menu.craft.common;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.PacketDistributor;
import org.anti_ad.mc.ipn.api.IPNIgnore;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import oshi.util.tuples.Pair;
import studio.fantasyit.maid_storage_manager.craft.CraftManager;
import studio.fantasyit.maid_storage_manager.craft.action.ActionOption;
import studio.fantasyit.maid_storage_manager.craft.action.CraftAction;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideStepData;
import studio.fantasyit.maid_storage_manager.menu.base.AbstractFilterScreen;
import studio.fantasyit.maid_storage_manager.menu.base.ImageAsset;
import studio.fantasyit.maid_storage_manager.menu.container.FilterSlot;
import studio.fantasyit.maid_storage_manager.menu.container.NoPlaceFilterSlot;
import studio.fantasyit.maid_storage_manager.menu.container.SelectButtonWidget;
import studio.fantasyit.maid_storage_manager.menu.craft.base.ICraftGuiPacketReceiver;
import studio.fantasyit.maid_storage_manager.menu.craft.common.CommonActionSelectionWidget;
import studio.fantasyit.maid_storage_manager.menu.craft.common.CommonCraftAssets;
import studio.fantasyit.maid_storage_manager.menu.craft.common.CommonCraftMenu;
import studio.fantasyit.maid_storage_manager.menu.craft.common.CommonStepDataContainer;
import studio.fantasyit.maid_storage_manager.network.CraftGuideGuiPacket;
import studio.fantasyit.maid_storage_manager.network.Network;
import studio.fantasyit.maid_storage_manager.storage.Target;
import studio.fantasyit.maid_storage_manager.util.ItemStackUtil;
import yalter.mousetweaks.api.MouseTweaksDisableWheelTweak;

@MouseTweaksDisableWheelTweak
@IPNIgnore
public class CommonCraftScreen
extends AbstractFilterScreen<CommonCraftMenu>
implements ICraftGuiPacketReceiver {
    CommonActionSelectionWidget actionSelector;
    SelectButtonWidget<CraftAction> actionSelectorButton;
    SelectButtonWidget<?> sortButtonUp;
    SelectButtonWidget<?> sortButtonDown;
    List<Pair<SelectButtonWidget<Integer>, EditBox>> options = new ArrayList<Pair<SelectButtonWidget<Integer>, EditBox>>();
    private static final int SCROLL_AREA_TOTAL_HEIGHT = 93;
    private float scrollOffsetTop = 0.0f;
    private Double mouseDraggingScrollingBar = null;
    private Double mouseStartDraggingOffset = null;

    public CommonCraftScreen(CommonCraftMenu p_97741_, Inventory p_97742_, Component p_97743_) {
        super(p_97741_, p_97742_, p_97743_);
        this.f_97726_ = 176;
        this.f_97727_ = 245;
        this.f_97731_ = this.f_97727_ - 94;
        this.f_97730_ = 8;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.addOptionButtons();
        this.addSortButtons();
        this.addActionButtons();
        this.actionSelector = new CommonActionSelectionWidget(0, 0, this);
        this.updateButtons();
    }

    private void syncOption(int idx, Integer nv, String value) {
        if (value == null) {
            value = ((EditBox)this.options.get(idx).getB()).m_94155_();
        }
        if (nv == null) {
            nv = (Integer)((SelectButtonWidget)((Object)this.options.get(idx).getA())).getData();
        }
        this.sendAndTriggerLocalPacket(new CraftGuideGuiPacket(CraftGuideGuiPacket.Type.OPTION, idx, nv, CraftGuideGuiPacket.singleValue(value)));
    }

    private void addOptionButtons() {
        int sx = 113;
        int sy = 96;
        for (int i = 0; i < 2; ++i) {
            int optionIdx = i;
            SelectButtonWidget btn = (SelectButtonWidget)this.m_142416_((GuiEventListener)new SelectButtonWidget<Integer>(113, sy + i * 12, value -> {
                if (((CommonCraftMenu)this.f_97732_).currentEditingItems.options.isEmpty()) {
                    return new SelectButtonWidget.Option<Integer>(0, CommonCraftAssets.BTN_OPTION, CommonCraftAssets.BTN_OPTION_HOVER, (Component)Component.m_237119_());
                }
                ActionOption<?> opt = ((CommonCraftMenu)this.f_97732_).currentEditingItems.options.get(optionIdx);
                int nv = value == null ? ((CommonCraftMenu)this.f_97732_).currentEditingItems.step.getOptionSelectionId(opt).orElse(0) : value + 1;
                nv %= opt.tooltip().length;
                if (value != null) {
                    this.syncOption(optionIdx, nv, null);
                }
                return new SelectButtonWidget.Option<Integer>(nv, CommonCraftAssets.BTN_OPTION, CommonCraftAssets.BTN_OPTION_HOVER, opt.tooltip()[nv]);
            }, this));
            EditBox editBox = (EditBox)this.m_142416_((GuiEventListener)new EditBox(this.f_96547_, this.getGuiLeft() + 113 + 14, this.getGuiTop() + sy + i * 12, 21, 9, (Component)Component.m_237113_((String)"")));
            editBox.m_94144_("");
            editBox.m_94182_(false);
            editBox.m_94153_(s -> {
                if (((CommonCraftMenu)this.f_97732_).currentEditingItems.options.isEmpty()) {
                    return false;
                }
                ActionOption<?> opt = ((CommonCraftMenu)this.f_97732_).currentEditingItems.options.get(optionIdx);
                return opt.valuePredicatorOrGetter().predicate((String)s);
            });
            editBox.m_94151_(t -> {
                ActionOption<?> opt = ((CommonCraftMenu)this.f_97732_).currentEditingItems.options.get(optionIdx);
                if (opt.valuePredicatorOrGetter().hasPredicator()) {
                    this.syncOption(optionIdx, null, (String)t);
                }
            });
            this.options.add((Pair<SelectButtonWidget<Integer>, EditBox>)new Pair((Object)btn, (Object)editBox));
        }
        this.m_142416_((GuiEventListener)new SelectButtonWidget<Boolean>(114, 126, value -> {
            if (value == null) {
                value = ((CommonCraftMenu)this.f_97732_).craftGuideData.isMergeable();
            } else {
                value = value == false;
                this.sendAndTriggerLocalPacket(new CraftGuideGuiPacket(CraftGuideGuiPacket.Type.GLOBAL, 0, value != false ? 1 : 0));
            }
            return new SelectButtonWidget.Option<Boolean>((Boolean)value, value != false ? CommonCraftAssets.BTN_MERGEABLE : CommonCraftAssets.BTN_NOT_MERGEABLE, value != false ? CommonCraftAssets.BTN_MERGEABLE_HOVER : CommonCraftAssets.BTN_NOT_MERGEABLE_HOVER, (Component)(value != false ? Component.m_237115_((String)"gui.maid_storage_manager.craft_guide.global.mergeable") : Component.m_237115_((String)"gui.maid_storage_manager.craft_guide.global.not_mergeable")));
        }, this));
        this.m_142416_((GuiEventListener)new SelectButtonWidget<Boolean>(132, 126, value -> {
            if (value == null) {
                value = ((CommonCraftMenu)this.f_97732_).craftGuideData.isNoOccupy();
            } else {
                value = value == false;
                this.sendAndTriggerLocalPacket(new CraftGuideGuiPacket(CraftGuideGuiPacket.Type.GLOBAL, 1, value != false ? 1 : 0));
            }
            return new SelectButtonWidget.Option<Boolean>((Boolean)value, value != false ? CommonCraftAssets.BTN_NO_OCCUPY : CommonCraftAssets.BTN_OCCUPY, value != false ? CommonCraftAssets.BTN_NO_OCCUPY_HOVER : CommonCraftAssets.BTN_OCCUPY_HOVER, (Component)(value != false ? Component.m_237115_((String)"gui.maid_storage_manager.craft_guide.global.no_occupy") : Component.m_237115_((String)"gui.maid_storage_manager.craft_guide.global.occupy")));
        }, this));
    }

    private void addSortButtons() {
        this.sortButtonUp = (SelectButtonWidget)this.m_142416_((GuiEventListener)new SelectButtonWidget<Integer>(91, 129, value -> {
            if (value != null) {
                this.sendAndTriggerLocalPacket(new CraftGuideGuiPacket(CraftGuideGuiPacket.Type.UP, 0));
            }
            return new SelectButtonWidget.Option<Integer>(0, CommonCraftAssets.BTN_UP, CommonCraftAssets.BTN_UP, (Component)Component.m_237115_((String)"gui.maid_storage_manager.craft_guide.common.up"));
        }, this));
        this.sortButtonDown = (SelectButtonWidget)this.m_142416_((GuiEventListener)new SelectButtonWidget<Integer>(91, 136, value -> {
            if (value != null) {
                this.sendAndTriggerLocalPacket(new CraftGuideGuiPacket(CraftGuideGuiPacket.Type.DOWN, 0));
            }
            return new SelectButtonWidget.Option<Integer>(0, CommonCraftAssets.BTN_DOWN, CommonCraftAssets.BTN_DOWN, (Component)Component.m_237115_((String)"gui.maid_storage_manager.craft_guide.common.down"));
        }, this));
    }

    private void addActionButtons() {
        this.actionSelectorButton = (SelectButtonWidget)this.m_142416_((GuiEventListener)new SelectButtonWidget<CraftAction>(112, 73, value -> {
            if (value == null) {
                CraftAction action = ((CommonCraftMenu)this.f_97732_).currentEditingItems.step != null ? ((CommonCraftMenu)this.f_97732_).currentEditingItems.actionType : CraftManager.getInstance().getDefaultAction();
                return new SelectButtonWidget.Option<CraftAction>(action, CommonCraftAssets.BTN_ACTION, CommonCraftAssets.BTN_ACTION_HOVER, CommonCraftAssets.translationForAction(action.type()));
            }
            this.actionSelector.setCallback(t -> {
                this.actionSelectorButton.setOption(new SelectButtonWidget.Option<CraftAction>((CraftAction)t, CommonCraftAssets.BTN_ACTION, CommonCraftAssets.BTN_ACTION_HOVER, CommonCraftAssets.translationForAction(t.type())));
                CompoundTag tag = new CompoundTag();
                tag.m_128359_("ns", t.type().m_135827_());
                tag.m_128359_("id", t.type().m_135815_());
                this.sendAndTriggerLocalPacket(new CraftGuideGuiPacket(CraftGuideGuiPacket.Type.SET_MODE, 0, tag));
            });
            this.actionSelector.setSelectedAction((CraftAction)value);
            this.actionSelector.expandFrom(this.actionSelectorButton);
            return new SelectButtonWidget.Option<CraftAction>((CraftAction)value, CommonCraftAssets.BTN_ACTION, CommonCraftAssets.BTN_ACTION_HOVER, CommonCraftAssets.translationForAction(value.type()));
        }, this));
    }

    private void sendAndTriggerLocalPacket(CraftGuideGuiPacket packet) {
        Network.INSTANCE.send(PacketDistributor.SERVER.noArg(), (Object)packet);
        ((CommonCraftMenu)this.f_97732_).handleGuiPacket(packet.type, packet.key, packet.value, packet.data);
        this.handleGuiPacket(packet.type, packet.key, packet.value, packet.data);
    }

    protected void m_7286_(GuiGraphics guiGraphics, float p_97788_, int p_97789_, int p_97790_) {
        this.m_280273_(guiGraphics);
        int relX = (this.f_96543_ - this.f_97726_) / 2;
        int relY = (this.f_96544_ - this.f_97727_) / 2;
        guiGraphics.m_280398_(CommonCraftAssets.BACKGROUND, relX, relY, 0, 0.0f, 0.0f, this.f_97726_, this.f_97727_, 256, 256);
        int c = 0;
        for (int x = 0; x < 2; ++x) {
            for (int y = 0; y < 2; ++y) {
                if (((CommonCraftMenu)this.f_97732_).filterSlots[c].m_6659_()) {
                    ImageAsset imageAsset = ((CommonCraftMenu)this.f_97732_).isHandRelated && c == 1 && ((CommonCraftMenu)this.f_97732_).filterSlots[c].m_7993_().m_41619_() ? CommonCraftAssets.SLOT_HAND : CommonCraftAssets.SLOT_NORMAL;
                    imageAsset.blit(guiGraphics, relX + ((CommonCraftMenu)this.f_97732_).filterSlots[c].f_40220_ - 1, relY + ((CommonCraftMenu)this.f_97732_).filterSlots[c].f_40221_ - 1);
                }
                ++c;
            }
        }
    }

    protected void m_280072_(@NotNull GuiGraphics graphics, int x, int y) {
        if (this.actionSelector.visible) {
            return;
        }
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_(0.0f, 0.0f, 200.0f);
        RenderSystem.enableDepthTest();
        if (((CommonCraftMenu)this.f_97732_).m_142621_().m_41619_()) {
            int inGuiX = x - this.getGuiLeft();
            int inGuiY = y - this.getGuiTop();
            for (Slot slot : ((CommonCraftMenu)this.m_6262_()).f_38839_) {
                FilterSlot filterSlot;
                if (slot.f_40220_ > inGuiX || slot.f_40220_ + 16 < inGuiX || slot.f_40221_ > inGuiY || slot.f_40221_ + 16 < inGuiY || !(slot instanceof FilterSlot) || !(filterSlot = (FilterSlot)slot).m_6659_()) continue;
                if (!filterSlot.m_7993_().m_41619_()) {
                    graphics.m_280153_(this.f_96547_, filterSlot.m_7993_(), x, y);
                }
                return;
            }
            this.m_6702_().forEach(renderable -> {
                SelectButtonWidget buttonWidget;
                if (renderable.m_5953_((double)x, (double)y) && renderable instanceof SelectButtonWidget && (buttonWidget = (SelectButtonWidget)((Object)renderable)).m_142518_()) {
                    graphics.m_280557_(this.f_96547_, buttonWidget.getTooltipComponent(), x, y);
                }
            });
        }
        super.m_280072_(graphics, x, y);
        graphics.m_280262_();
        graphics.m_280168_().m_85849_();
    }

    public void m_88315_(GuiGraphics graphics, int p_283661_, int p_281248_, float p_281886_) {
        super.m_88315_(graphics, p_283661_, p_281248_, p_281886_);
        this.renderOptionEditorOrTip(graphics);
        this.renderBlockIndicator(graphics);
        this.renderNumberLabel(graphics);
        this.renderButtonIcon(graphics);
        this.renderArrow(graphics);
        this.renderScrollList(graphics, p_283661_, p_281248_);
        this.renderScrollBar(graphics, p_283661_, p_281248_);
        this.renderMiniBarInfo(graphics);
        this.actionSelector.m_88315_(graphics, p_283661_, p_281248_, p_281886_);
        this.m_280072_(graphics, p_283661_, p_281248_);
    }

    private void renderOptionEditorOrTip(@NotNull GuiGraphics graphics) {
        for (int i = 0; i < this.options.size(); ++i) {
            if (((CommonCraftMenu)this.f_97732_).currentEditingItems.options.size() <= i) continue;
            ActionOption<?> opt = ((CommonCraftMenu)this.f_97732_).currentEditingItems.options.get(i);
            Pair<SelectButtonWidget<Integer>, EditBox> editBox = this.options.get(i);
            if (((EditBox)editBox.getB()).m_94213_()) {
                CommonCraftAssets.OPTION_UNDERLINE.blit(graphics, ((EditBox)editBox.getB()).m_252754_(), ((EditBox)editBox.getB()).m_252907_() + ((EditBox)editBox.getB()).m_93694_());
            } else if (((SelectButtonWidget)((Object)editBox.getA())).isVisible() && !opt.valuePredicatorOrGetter().hasPredicator()) {
                Object ab = opt.converter().ab((Integer)((SelectButtonWidget)((Object)editBox.getA())).getData());
                graphics.m_280168_().m_85836_();
                graphics.m_280168_().m_252880_((float)((EditBox)editBox.getB()).m_252754_(), (float)(((EditBox)editBox.getB()).m_252907_() + 2), 0.0f);
                this.drawCenteredString(graphics, this.f_96547_, opt.valuePredicatorOrGetter().getValue(ab).orElse((Component)Component.m_237119_()), 0, 0, 23, -1, true);
                graphics.m_280168_().m_85849_();
            }
            if (!((SelectButtonWidget)((Object)editBox.getA())).isVisible()) continue;
            ResourceLocation asset = opt.icon()[(Integer)((SelectButtonWidget)((Object)editBox.getA())).getData()];
            graphics.m_280163_(asset, ((SelectButtonWidget)((Object)editBox.getA())).m_252754_(), ((SelectButtonWidget)((Object)editBox.getA())).m_252907_(), 0.0f, 0.0f, 11, 11, 11, 11);
        }
    }

    private void renderArrow(@NotNull GuiGraphics graphics) {
        int relX = (this.f_96543_ - this.f_97726_) / 2;
        int relY = (this.f_96544_ - this.f_97727_) / 2;
        if (((CommonCraftMenu)this.f_97732_).currentEditingItems.inputCount > 0) {
            CommonCraftAssets.ARROW_DOWN.blit(graphics, relX + 118, relY + 60);
        }
        if (((CommonCraftMenu)this.f_97732_).currentEditingItems.outputCount > 0) {
            CommonCraftAssets.ARROW_UP.blit(graphics, relX + 138, relY + 60);
        }
    }

    private void renderNumberLabel(@NotNull GuiGraphics graphics) {
        int relX = (this.f_96543_ - this.f_97726_) / 2;
        int relY = (this.f_96544_ - this.f_97727_) / 2;
        for (Slot slot : ((CommonCraftMenu)this.m_6262_()).f_38839_) {
            if (!(slot instanceof FilterSlot)) continue;
            FilterSlot filterSlot = (FilterSlot)slot;
            Container container = filterSlot.f_40218_;
            if (!(container instanceof CommonStepDataContainer)) continue;
            CommonStepDataContainer sdc = (CommonStepDataContainer)container;
            if (!filterSlot.m_6659_() || !filterSlot.m_6657_()) continue;
            int count = sdc.getCount(filterSlot.m_150661_());
            String text = String.valueOf(count);
            if (count == -1) {
                text = "*";
            }
            graphics.m_280168_().m_85836_();
            graphics.m_280168_().m_85841_(0.6f, 0.6f, 1.0f);
            graphics.m_280168_().m_252880_(0.0f, 0.0f, 350.0f);
            RenderSystem.enableDepthTest();
            int n = (int)(((double)(relX + filterSlot.f_40220_ + 16) - (double)this.f_96547_.m_92895_(text) * 0.6) / (double)0.6f);
            double d = relY + filterSlot.f_40221_ + 16;
            Objects.requireNonNull(this.f_96547_);
            graphics.m_280488_(this.f_96547_, text, n, (int)((d - 9.0 * 0.6) / (double)0.6f), 0xFFFFFF);
            graphics.m_280168_().m_85849_();
        }
        graphics.m_280262_();
    }

    private void renderButtonIcon(@NotNull GuiGraphics graphics) {
        if (this.actionSelectorButton.isVisible()) {
            CommonCraftAssets.imageForAction(this.actionSelectorButton.getData().type()).blit(graphics, this.actionSelectorButton.m_252754_() + 2, this.actionSelectorButton.m_252907_() + 2);
        }
        graphics.m_280262_();
    }

    private void renderBlockIndicator(@NotNull GuiGraphics graphics) {
        graphics.m_280168_().m_85836_();
        float scale = 1.3f;
        graphics.m_280168_().m_85841_(scale, scale, 1.0f);
        graphics.m_280480_(((CommonCraftMenu)this.f_97732_).blockIndicator.m_7993_(), (int)((float)(this.f_97735_ + ((CommonCraftMenu)this.f_97732_).blockIndicator.f_40220_ - 1) / scale), (int)((float)(this.f_97736_ + ((CommonCraftMenu)this.f_97732_).blockIndicator.f_40221_ + 1) / scale));
        graphics.m_280168_().m_85849_();
    }

    private void renderMiniBarInfo(@NotNull GuiGraphics graphics) {
        if (((CommonCraftMenu)this.f_97732_).currentEditingItems.step == null) {
            graphics.m_280168_().m_85836_();
            graphics.m_280168_().m_252880_((float)(this.getGuiLeft() + 36), (float)(this.getGuiTop() + 131), 0.0f);
            graphics.m_280168_().m_85841_(0.6f, 0.6f, 1.0f);
            graphics.m_280430_(this.f_96547_, (Component)Component.m_237115_((String)"gui.maid_storage_manager.craft_guide.common.no_step_selected"), 0, 0, -1);
            graphics.m_280168_().m_85849_();
            return;
        }
        NoPlaceFilterSlot bi = ((CommonCraftMenu)this.f_97732_).blockIndicatorForSteps.get(((CommonCraftMenu)this.f_97732_).selectedIndex);
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_((float)(this.getGuiLeft() + 28), (float)(this.getGuiTop() + 128), 0.0f);
        graphics.m_280168_().m_85841_(0.7f, 0.7f, 1.0f);
        graphics.m_280480_(bi.m_7993_(), 0, 0);
        graphics.m_280168_().m_85849_();
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_((float)(this.getGuiLeft() + 41), (float)(this.getGuiTop() + 128), 0.0f);
        graphics.m_280168_().m_85841_(0.55f, 0.55f, 1.0f);
        graphics.m_280430_(this.f_96547_, (Component)Component.m_237110_((String)"gui.maid_storage_manager.craft_guide.common.step_index", (Object[])new Object[]{((CommonCraftMenu)this.f_97732_).selectedIndex + 1}), 0, 0, -1);
        graphics.m_280168_().m_85849_();
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_((float)(this.getGuiLeft() + 41), (float)(this.getGuiTop() + 134), 0.0f);
        graphics.m_280168_().m_85841_(0.65f, 0.65f, 1.0f);
        graphics.m_280430_(this.f_96547_, (Component)Component.m_237110_((String)"gui.maid_storage_manager.craft_guide.common.step_pos", (Object[])new Object[]{((CommonCraftMenu)this.f_97732_).currentEditingItems.step.storage.pos.m_123341_(), ((CommonCraftMenu)this.f_97732_).currentEditingItems.step.storage.pos.m_123342_(), ((CommonCraftMenu)this.f_97732_).currentEditingItems.step.storage.pos.m_123343_(), Component.m_237115_((String)("gui.maid_storage_manager.craft_guide.common.side_" + ((CommonCraftMenu)this.f_97732_).currentEditingItems.step.storage.getSide().map(t -> t.name().toLowerCase()).orElse("none")))}), 0, 0, -1);
        graphics.m_280168_().m_85849_();
    }

    public boolean m_6050_(double x, double y, double p_94688_) {
        EditBox eb;
        Optional child;
        Object count;
        if (this.actionSelector.visible) {
            return this.actionSelector.m_6050_(x, y, p_94688_);
        }
        @Nullable Slot slot = this.getSlotUnderMouse();
        if (slot instanceof FilterSlot) {
            FilterSlot filterSlot = (FilterSlot)slot;
            Container container = filterSlot.f_40218_;
            if (container instanceof CommonStepDataContainer) {
                CommonStepDataContainer sdc = (CommonStepDataContainer)container;
                count = new MutableInt(sdc.getCount(filterSlot.m_150661_()));
                int dv = (int)(Math.abs(p_94688_) / p_94688_);
                if (InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)340)) {
                    dv *= 10;
                }
                if (dv > 0) {
                    if (count.addAndGet(dv) == 0) {
                        count.addAndGet(1);
                    }
                } else if (count.addAndGet(dv) <= 0) {
                    count.setValue(1);
                }
                this.sendAndTriggerLocalPacket(new CraftGuideGuiPacket(CraftGuideGuiPacket.Type.COUNT, filterSlot.f_40219_, count.getValue()));
                return true;
            }
        }
        if ((child = this.m_94729_(x, y)).isPresent() && (count = child.get()) instanceof EditBox && (eb = (EditBox)count).m_94213_()) {
            int dv = (int)(Math.abs(p_94688_) / p_94688_);
            if (InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)340)) {
                dv *= 10;
            }
            Integer ov = Integer.valueOf(eb.m_94155_());
            eb.m_94144_(String.valueOf(ov + dv));
            return true;
        }
        if (x - (double)this.getGuiLeft() > 26.0 && y - (double)this.getGuiTop() > 26.0 && x - (double)this.getGuiLeft() < 100.0 && y - (double)this.getGuiTop() < 119.0) {
            this.scroll((float)(-p_94688_) * 3.0f);
        }
        return super.m_6050_(x, y, p_94688_);
    }

    @Override
    public void accept(FilterSlot slot, ItemStack item) {
        if (slot instanceof NoPlaceFilterSlot) {
            return;
        }
        if (!slot.m_6659_()) {
            return;
        }
        slot.m_5852_(item);
        this.sendAndTriggerLocalPacket(new CraftGuideGuiPacket(CraftGuideGuiPacket.Type.SET_ITEM, slot.f_40219_, 0, ItemStackUtil.saveStack(item)));
    }

    @Override
    public List<FilterSlot> getSlots() {
        return ((CommonCraftMenu)this.f_97732_).f_38839_.stream().filter(slot -> {
            if (!(slot instanceof FilterSlot)) return false;
            FilterSlot fs = (FilterSlot)((Object)slot);
            if (slot instanceof NoPlaceFilterSlot) return false;
            if (!slot.m_6659_()) return false;
            return true;
        }).map(slot -> (FilterSlot)((Object)slot)).toList();
    }

    @Override
    public void handleGuiPacket(CraftGuideGuiPacket.Type type, int key, int value, @Nullable CompoundTag data) {
        if (type == CraftGuideGuiPacket.Type.SELECT || type == CraftGuideGuiPacket.Type.SET_MODE) {
            this.updateButtons();
        }
        if (type == CraftGuideGuiPacket.Type.SELECT) {
            this.actionSelectorButton.setOption(null);
        }
    }

    private void updateButtons() {
        List<ActionOption<?>> actionOptions = ((CommonCraftMenu)this.f_97732_).currentEditingItems.options;
        for (int i = 0; i < this.options.size(); ++i) {
            boolean show = i < actionOptions.size();
            ((SelectButtonWidget)((Object)this.options.get(i).getA())).setVisible(show);
            if (show) {
                ((SelectButtonWidget)((Object)this.options.get(i).getA())).setOption(null);
            }
            if (show && actionOptions.get(i).valuePredicatorOrGetter().hasPredicator()) {
                ((EditBox)this.options.get(i).getB()).m_94194_(true);
                ((EditBox)this.options.get(i).getB()).m_94153_(actionOptions.get(i).valuePredicatorOrGetter()::predicate);
                ((EditBox)this.options.get(i).getB()).m_94144_(actionOptions.get(i).getOptionValue(((CommonCraftMenu)this.f_97732_).currentEditingItems.step));
                continue;
            }
            ((EditBox)this.options.get(i).getB()).m_94194_(false);
        }
        boolean hasStepSelected = ((CommonCraftMenu)this.f_97732_).currentEditingItems.step != null;
        this.actionSelectorButton.setVisible(hasStepSelected);
        this.sortButtonDown.setVisible(hasStepSelected);
        this.sortButtonUp.setVisible(hasStepSelected);
    }

    private Component getStorageSideTranslate(Target target) {
        return Component.m_237110_((String)"gui.maid_storage_manager.craft_guide.common.side", (Object[])new Object[]{Component.m_237115_((String)("gui.maid_storage_manager.craft_guide.common.side_" + target.getSide().map(t -> t.name().toLowerCase()).orElse("none")))});
    }

    public boolean m_6375_(double x, double y, int p_97750_) {
        if (this.actionSelector.visible) {
            if (!this.actionSelector.m_5953_(x, y)) {
                this.actionSelector.hide();
            } else {
                return this.actionSelector.m_6375_(x, y, p_97750_);
            }
        }
        if (this.isInScrollBlockArea(x, y)) {
            this.mouseDraggingScrollingBar = y;
            this.mouseStartDraggingOffset = this.scrollOffsetTop;
        }
        if (x - (double)this.getGuiLeft() > 26.0 && y - (double)this.getGuiTop() > 26.0 && x - (double)this.getGuiLeft() < 100.0 && y - (double)this.getGuiTop() < 119.0) {
            this.clickInScrollList(x, y);
        }
        return super.m_6375_(x, y, p_97750_);
    }

    private float getScrollBlockHeight() {
        return Math.max(Math.min(186 - ((CommonCraftMenu)this.f_97732_).craftGuideData.steps.size() * (CommonCraftAssets.ROW.h - 1), 99), 10);
    }

    private float getScrollBlockOffset() {
        float scrollableHeight = this.getMaxListOffset();
        float totalMaxHeight = this.getMaxScrollOffset();
        return this.scrollOffsetTop * scrollableHeight / totalMaxHeight;
    }

    private float getMaxScrollOffset() {
        return ((CommonCraftMenu)this.f_97732_).craftGuideData.steps.size() * (CommonCraftAssets.ROW.h - 1) - 93;
    }

    private float getMaxListOffset() {
        return 99.0f - this.getScrollBlockHeight();
    }

    private void makeScreenScissor(GuiGraphics graphics) {
        graphics.m_280588_(this.getGuiLeft() + 26, this.getGuiTop() + 26, this.getGuiLeft() + 100, this.getGuiTop() + 119);
    }

    private void releaseScreenScissor(GuiGraphics graphics) {
        graphics.m_280618_();
    }

    private void scroll(float delta) {
        this.scrollOffsetTop += delta;
        if (this.scrollOffsetTop > this.getMaxScrollOffset()) {
            this.scrollOffsetTop = this.getMaxScrollOffset();
        }
        if (this.scrollOffsetTop < 0.0f) {
            this.scrollOffsetTop = 0.0f;
        }
    }

    private int getSelectedStep(double x, double y) {
        int rh = CommonCraftAssets.ROW.h - 1;
        if (x - (double)this.getGuiLeft() > 26.0 && y - (double)this.getGuiTop() > 26.0 && x - (double)this.getGuiLeft() < 100.0 && y - (double)this.getGuiTop() < 119.0) {
            int offsetY = (int)(y - (double)this.getGuiTop() - 26.0);
            return (int)(((float)offsetY + this.scrollOffsetTop) / (float)rh);
        }
        return -1;
    }

    boolean isClickedOnDeleteBtn(double x, double y, int seleted) {
        int rh = CommonCraftAssets.ROW.h - 1;
        if (x - (double)this.getGuiLeft() > 26.0 && y - (double)this.getGuiTop() > 26.0 && x - (double)this.getGuiLeft() < 100.0 && y - (double)this.getGuiTop() < 119.0) {
            double lDist = x - (double)this.getGuiLeft() - 26.0;
            double tDist = y - (double)this.getGuiTop() - 26.0 + (double)this.scrollOffsetTop - (double)(seleted * rh);
            if (lDist > (double)(CommonCraftAssets.ROW.w - 5) && tDist < 5.0) {
                return true;
            }
        }
        return false;
    }

    private void renderScrollList(GuiGraphics graphics, int x, int y) {
        int i;
        this.makeScreenScissor(graphics);
        int relX = (this.f_96543_ - this.f_97726_) / 2 + 27;
        int relY = (this.f_96544_ - this.f_97727_) / 2 + 27;
        int selected = this.getSelectedStep(x, y);
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_((float)relX, (float)relY - this.scrollOffsetTop, 0.0f);
        graphics.m_280168_().m_85836_();
        for (i = 0; i < ((CommonCraftMenu)this.f_97732_).craftGuideData.steps.size(); ++i) {
            CommonCraftAssets.ROW.blit(graphics, 0, 0);
            graphics.m_280168_().m_252880_(0.0f, (float)(CommonCraftAssets.ROW.h - 1), 0.0f);
        }
        graphics.m_280168_().m_85849_();
        graphics.m_280168_().m_85836_();
        for (i = 0; i < ((CommonCraftMenu)this.f_97732_).craftGuideData.steps.size(); ++i) {
            if (i == selected) {
                CommonCraftAssets.ROW_HOVER.blit(graphics, 0, 0);
            }
            graphics.m_280168_().m_252880_(0.0f, (float)(CommonCraftAssets.ROW.h - 1), 0.0f);
        }
        graphics.m_280168_().m_85849_();
        for (i = 0; i < ((CommonCraftMenu)this.f_97732_).craftGuideData.steps.size(); ++i) {
            CraftGuideStepData step = ((CommonCraftMenu)this.f_97732_).craftGuideData.steps.get(i);
            if (i == ((CommonCraftMenu)this.f_97732_).selectedIndex) {
                CommonCraftAssets.ROW_HIGHLIGHT.blit(graphics, -1, -1);
                if (i == selected) {
                    CommonCraftAssets.ROW_HOVER.blit(graphics, 0, 0);
                } else {
                    CommonCraftAssets.ROW.blit(graphics, 0, 0);
                }
            }
            this.renderScrollListRow(graphics, step, ((CommonCraftMenu)this.f_97732_).blockIndicatorForSteps.get(i).m_7993_(), selected == i, i == ((CommonCraftMenu)this.f_97732_).selectedIndex, x - relX, (int)((float)(y - relY) + this.scrollOffsetTop - (float)(i * (CommonCraftAssets.ROW.h - 1))));
            graphics.m_280168_().m_252880_(0.0f, (float)(CommonCraftAssets.ROW.h - 1), 0.0f);
        }
        graphics.m_280168_().m_85849_();
        graphics.m_280262_();
        this.releaseScreenScissor(graphics);
    }

    private void renderScrollListRow(GuiGraphics graphics, CraftGuideStepData step, ItemStack blockIndicator, boolean hover, boolean selected, int x, int y) {
        String text;
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_(47.0f, 4.0f, 0.0f);
        graphics.m_280168_().m_85841_(0.7f, 0.7f, 1.0f);
        CommonCraftAssets.imageForAction(step.action).blit(graphics, 0, 0);
        graphics.m_280168_().m_85849_();
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_(2.0f, 4.0f, 0.0f);
        graphics.m_280168_().m_85841_(0.6f, 0.6f, 1.0f);
        boolean hasInput = false;
        for (ItemStack itemStack : step.getNonEmptyInput()) {
            graphics.m_280480_(itemStack, 0, 0);
            text = String.valueOf(itemStack.m_41613_());
            graphics.m_280168_().m_252880_(0.0f, 0.0f, 400.0f);
            int n = 16 - this.f_96547_.m_92895_(text);
            Objects.requireNonNull(this.f_96547_);
            graphics.m_280488_(this.f_96547_, text, n, 16 - 9, -1);
            graphics.m_280168_().m_252880_(0.0f, 0.0f, -400.0f);
            graphics.m_280168_().m_252880_(16.0f, 0.0f, 0.0f);
            hasInput = true;
        }
        if (hasInput) {
            graphics.m_280168_().m_252880_(4.0f, 0.0f, 0.0f);
        }
        for (ItemStack itemStack : step.getNonEmptyOutput()) {
            graphics.m_280480_(itemStack, 0, 0);
            text = String.valueOf(itemStack.m_41613_());
            graphics.m_280168_().m_252880_(0.0f, 0.0f, 400.0f);
            int n = 16 - this.f_96547_.m_92895_(text);
            Objects.requireNonNull(this.f_96547_);
            graphics.m_280488_(this.f_96547_, text, n, 16 - 9, -1);
            graphics.m_280168_().m_252880_(0.0f, 0.0f, -400.0f);
            graphics.m_280168_().m_252880_(16.0f, 0.0f, 0.0f);
        }
        graphics.m_280168_().m_85849_();
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_(58.0f, 2.0f, 0.0f);
        graphics.m_280168_().m_85841_(0.7f, 0.7f, 1.0f);
        graphics.m_280480_(blockIndicator, 0, 0);
        graphics.m_280168_().m_85849_();
        if (hover && selected) {
            graphics.m_280168_().m_85836_();
            graphics.m_280168_().m_252880_(0.0f, 0.0f, 600.0f);
            CommonCraftAssets.DELETE_GRAY.blit(graphics, CommonCraftAssets.ROW.w - 5, 2);
            if (x >= CommonCraftAssets.ROW.w - 5 && y < 5) {
                CommonCraftAssets.DELETE.blit(graphics, CommonCraftAssets.ROW.w - 5, 2);
            }
            graphics.m_280168_().m_85849_();
        }
    }

    private void renderScrollBar(GuiGraphics graphics, int x, int y) {
        boolean active = this.mouseDraggingScrollingBar != null;
        ImageAsset base = active ? CommonCraftAssets.SCROLL_BASE_HOVER : CommonCraftAssets.SCROLL_BASE;
        graphics.m_280260_(CommonCraftAssets.BACKGROUND, this.getGuiLeft() + 100, this.getGuiTop() + 23 + (int)this.getScrollBlockOffset(), base.w, (int)this.getScrollBlockHeight(), 1, base.w, base.h, base.u, base.v);
        ImageAsset deco = active ? CommonCraftAssets.SCROLL_DECO_HOVER : CommonCraftAssets.SCROLL_DECO;
        deco.blit(graphics, this.getGuiLeft() + 100, this.getGuiTop() + 23 + (int)this.getScrollBlockOffset() + (int)(this.getScrollBlockHeight() / 2.0f - (float)deco.h / 2.0f));
    }

    private void clickInScrollList(double x, double y) {
        int id = this.getSelectedStep(x, y);
        if (id == -1 || id >= ((CommonCraftMenu)this.f_97732_).craftGuideData.steps.size()) {
            return;
        }
        if (this.isClickedOnDeleteBtn(x, y, id) && ((CommonCraftMenu)this.f_97732_).selectedIndex == id) {
            this.sendAndTriggerLocalPacket(new CraftGuideGuiPacket(CraftGuideGuiPacket.Type.REMOVE, id));
        } else {
            this.sendAndTriggerLocalPacket(new CraftGuideGuiPacket(CraftGuideGuiPacket.Type.SELECT, id));
        }
    }

    private boolean isInScrollBlockArea(double x, double y) {
        double rx = x - (double)this.getGuiLeft();
        double ry = y - (double)this.getGuiTop() - 23.0;
        if (rx > 104.0 || rx < 100.0) {
            return false;
        }
        if (ry < (double)this.getScrollBlockOffset()) {
            return false;
        }
        return !(ry > (double)(this.getScrollBlockOffset() + this.getScrollBlockHeight()));
    }

    public boolean m_7979_(double x, double y, int p_97754_, double p_97755_, double p_97756_) {
        if (this.mouseDraggingScrollingBar != null && this.mouseStartDraggingOffset != null) {
            this.scrollOffsetTop = (float)(this.mouseStartDraggingOffset + (y - this.mouseDraggingScrollingBar) / (double)this.getMaxListOffset() * (double)this.getMaxScrollOffset());
            this.scroll(0.0f);
        }
        return super.m_7979_(x, y, p_97754_, p_97755_, p_97756_);
    }

    public boolean m_6348_(double p_97812_, double p_97813_, int p_97814_) {
        if (this.mouseDraggingScrollingBar != null || this.mouseStartDraggingOffset != null) {
            this.mouseDraggingScrollingBar = null;
            this.mouseStartDraggingOffset = null;
        }
        return super.m_6348_(p_97812_, p_97813_, p_97814_);
    }

    public void drawCenteredString(GuiGraphics graphics, Font pFont, Component pText, int pX, int pY, int maxWidth, int pColor, boolean shadow) {
        FormattedCharSequence formattedcharsequence = pText.m_7532_();
        int textWidth = pFont.m_92724_(formattedcharsequence);
        int drawWidth = Math.max(textWidth, maxWidth);
        int alignWidth = Math.min(maxWidth, textWidth);
        float scale = (float)maxWidth / (float)drawWidth;
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_85841_(scale, scale, scale);
        graphics.drawString(pFont, formattedcharsequence, (float)pX / scale, ((float)(pY - 3) + (14.0f - 8.0f * scale) / 2.0f) / scale, pColor, shadow);
        graphics.m_280168_().m_85849_();
    }
}

