/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.client.gui.entity.maid.farm;

import com.github.wallev.maidsoulkitchen.api.task.v1.farm.ICompatFarm;
import com.github.wallev.maidsoulkitchen.api.task.v1.farm.ICompatFarmHandler;
import com.github.wallev.maidsoulkitchen.api.task.v1.farm.IHandlerInfo;
import com.github.wallev.maidsoulkitchen.client.gui.entity.maid.MaidTaskConfigGui;
import com.github.wallev.maidsoulkitchen.client.gui.widget.button.CFRuleButton;
import com.github.wallev.maidsoulkitchen.client.gui.widget.button.ResultInfo;
import com.github.wallev.maidsoulkitchen.client.gui.widget.button.Zone;
import com.github.wallev.maidsoulkitchen.entity.data.inner.task.BerryData;
import com.github.wallev.maidsoulkitchen.inventory.container.maid.BerryFarmConfigContainer;
import com.github.wallev.maidsoulkitchen.network.NetworkHandler;
import com.github.wallev.maidsoulkitchen.network.message.ActionBerryFarmRuleMessage;
import com.github.wallev.maidsoulkitchen.task.farm.TaskBerryFarm;
import com.github.wallev.maidsoulkitchen.task.farm.handler.v1.IFarmHandlerManager;
import java.util.Arrays;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import org.anti_ad.mc.ipn.api.IPNButton;
import org.anti_ad.mc.ipn.api.IPNGuiHint;
import org.anti_ad.mc.ipn.api.IPNGuiHints;
import org.anti_ad.mc.ipn.api.IPNPlayerSideOnly;

@IPNPlayerSideOnly
@IPNGuiHints(value={@IPNGuiHint(button=IPNButton.SORT, horizontalOffset=-36, bottom=-12), @IPNGuiHint(button=IPNButton.SORT_COLUMNS, horizontalOffset=-24, bottom=-24), @IPNGuiHint(button=IPNButton.SORT_ROWS, horizontalOffset=-12, bottom=-36), @IPNGuiHint(button=IPNButton.SHOW_EDITOR, horizontalOffset=-5), @IPNGuiHint(button=IPNButton.SETTINGS, horizontalOffset=-5)})
public class BerryFarmConfigGui
extends MaidTaskConfigGui<BerryFarmConfigContainer> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("maidsoulkitchen", "textures/gui/farm_guide.png");
    protected final Zone scrollDisplay = new Zone(161, 20, 9, 110);
    protected final Zone ruleDisplay = new Zone(6, 20, 152, 110);
    protected final ResultInfo ref = new ResultInfo(4, 1, 152, 24, 0, 5);
    private final int limitSize = this.ref.row() * this.ref.col();
    private List<ICompatFarmHandler> handlers;
    private BerryData farmTaskInfo;

    public BerryFarmConfigGui(BerryFarmConfigContainer screenContainer, Inventory inv, Component titleIn) {
        super(screenContainer, inv, (Component)screenContainer.getMaid().getTask().getName().m_7220_((Component)Component.m_237115_((String)"gui.maidsoulkitchen.farm_config_screen.title")));
    }

    protected void initAdditionData() {
        super.initAdditionData();
        this.handlers = Arrays.stream(((ICompatFarm)this.task).getManagerHandlerValues()).map(IFarmHandlerManager::getFarmHandler).filter(rec$ -> ((ICompatFarmHandler)rec$).canLoad()).toList();
        this.farmTaskInfo = (BerryData)((TaskBerryFarm)this.task).getTaskData(this.maid);
    }

    @Override
    protected void initAdditionWidgets() {
        super.initAdditionWidgets();
        this.addRuleButton();
        this.addScrollButton();
    }

    protected void renderAddition(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.renderAddition(graphics, mouseX, mouseY, partialTicks);
        this.drawScrollInfoBar(graphics);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        boolean isCookSettingMainZone;
        boolean bl = isCookSettingMainZone = mouseX >= (double)this.visualZone.startX() && mouseY >= (double)this.visualZone.startY() && mouseX < (double)(this.visualZone.startX() + this.visualZone.width()) && mouseY < (double)(this.visualZone.startY() + this.visualZone.height());
        if (delta != 0.0 && isCookSettingMainZone) {
            if (delta > 0.0 && this.solIndex > 0) {
                --this.solIndex;
                this.m_7856_();
                return true;
            }
            if (delta < 0.0 && this.solIndex < (this.handlers.size() - 1) / this.limitSize) {
                ++this.solIndex;
                this.m_7856_();
                return true;
            }
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }

    private void addRuleButton() {
        int index;
        int startX = this.visualZone.startX() + this.ruleDisplay.startX();
        int startY = this.visualZone.startY() + this.ruleDisplay.startY();
        for (int i = index = this.solIndex * this.limitSize; i < Math.min(this.handlers.size(), index + this.limitSize); ++i) {
            ICompatFarmHandler handler = this.handlers.get(i);
            if (!handler.canLoad()) continue;
            String handlerUid = ((IHandlerInfo)((Object)handler)).getUid().toString();
            boolean contains = this.farmTaskInfo.rules().contains(handlerUid);
            CFRuleButton cfRuleButton = new CFRuleButton((IHandlerInfo)((Object)handler), handler, contains, startX, startY, this.getTaskTooltips((IHandlerInfo)((Object)handler))){

                public void m_5716_(double pMouseX, double pMouseY) {
                    this.isSelected = !this.isSelected;
                    BerryFarmConfigGui.this.farmTaskInfo.addOrRemoveRule(this.handlerInfo.getUid().toString());
                    NetworkHandler.sendToServer(new ActionBerryFarmRuleMessage(BerryFarmConfigGui.this.maid.m_19879_(), ((TaskBerryFarm)BerryFarmConfigGui.this.task).getCookDataKey().getKey(), this.handlerInfo.getUid().toString()));
                }
            };
            this.m_142416_((GuiEventListener)cfRuleButton);
            startY += this.ref.colHeight() + this.ref.colSpacing();
        }
    }

    private void addScrollButton() {
        int startX = this.visualZone.startX() + this.scrollDisplay.startX();
        int startY = this.visualZone.startY() + this.scrollDisplay.startY();
        ImageButton upButton = new ImageButton(startX, startY, 9, 7, 228, 10, 14, TEXTURE, b -> {
            if (this.solIndex > 0) {
                --this.solIndex;
                this.m_7856_();
            }
        });
        ImageButton downButton = new ImageButton(startX, startY + 8 + 1 + 95, 9, 7, 237, 10, 14, TEXTURE, b -> {
            if (this.solIndex < (this.handlers.size() - 1) / this.limitSize) {
                ++this.solIndex;
                this.m_7856_();
            }
        });
        this.m_142416_((GuiEventListener)upButton);
        this.m_142416_((GuiEventListener)downButton);
    }

    private void drawScrollInfoBar(GuiGraphics graphics) {
        int startX = this.visualZone.startX() + this.scrollDisplay.startX();
        int startY = this.visualZone.startY() + this.scrollDisplay.startY();
        graphics.m_280218_(TEXTURE, startX, startY + 8, 247, 8, 9, 95);
        this.drawScrollIndicator(graphics, startX + 1, startY + 8 + 1);
    }

    private void drawScrollIndicator(GuiGraphics graphics, int startX, int startY) {
        if ((this.handlers.size() - 1) / this.limitSize >= 1) {
            graphics.m_280218_(TEXTURE, startX, startY + (int)(83.0f * this.getCurrentScroll()), 228, 0, 7, 9);
        } else {
            graphics.m_280218_(TEXTURE, startX, startY, 235, 0, 7, 9);
        }
    }

    private float getCurrentScroll() {
        return Mth.m_14036_((float)((float)((double)this.solIndex * (1.0 / (double)((this.handlers.size() - 1) / this.limitSize)))), (float)0.0f, (float)1.0f);
    }

    private List<Component> getTaskTooltips(IHandlerInfo iHandlerInfo) {
        List<Component> conditionDescription;
        List<Component> desc = iHandlerInfo.getDescription(this.maid);
        if (!desc.isEmpty()) {
            desc.add(0, (Component)Component.m_237115_((String)"task.touhou_little_maid.desc.title").m_130940_(ChatFormatting.GOLD));
        }
        if (!(conditionDescription = iHandlerInfo.getConditionDescription(this.maid)).isEmpty()) {
            desc.add((Component)Component.m_237113_((String)" "));
            desc.add((Component)Component.m_237115_((String)"task.touhou_little_maid.desc.condition").m_130940_(ChatFormatting.GOLD));
        }
        for (Component line : conditionDescription) {
            MutableComponent prefix = Component.m_237113_((String)"- ");
            desc.add((Component)prefix.m_7220_(line));
        }
        return desc;
    }
}

