/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.client.gui.item;

import com.github.wallev.maidsoulkitchen.client.gui.item.CookBagAbstractContainerGui;
import com.github.wallev.maidsoulkitchen.client.gui.widget.button.CookBagModeButton;
import com.github.wallev.maidsoulkitchen.inventory.container.item.BagType;
import com.github.wallev.maidsoulkitchen.inventory.container.item.CookBagConfigContainer;
import com.github.wallev.maidsoulkitchen.item.ItemCulinaryHub;
import com.github.wallev.maidsoulkitchen.network.NetworkHandler;
import com.github.wallev.maidsoulkitchen.network.message.ClearCookBagBindPosesMessage;
import com.github.wallev.maidsoulkitchen.network.message.SetCookBagBindModeMessage;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.Items;
import org.anti_ad.mc.ipn.api.IPNIgnore;

@IPNIgnore
public class CookBagConfigContainerGui
extends CookBagAbstractContainerGui<CookBagConfigContainer> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("maidsoulkitchen", "textures/gui/cook_guide.png");
    protected String bindMode;

    public CookBagConfigContainerGui(CookBagConfigContainer container, Inventory inv, Component titleIn) {
        super(container, inv, (Component)Component.m_237115_((String)"gui.maidsoulkitchen.culinary_hub.config.title"));
        this.bindMode = ItemCulinaryHub.getBindMode(((CookBagConfigContainer)this.f_97732_).cookBag);
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.addBindModeButtons();
        this.addInfoButton();
    }

    private void addBindModeButtons() {
        int x = this.f_97735_ + 6;
        int y = this.f_97736_ + 6;
        for (final BagType value : BagType.values()) {
            MutableComponent title = Component.m_237115_((String)("gui.maidsoulkitchen.culinary_hub.config.bind_mode." + value.translateKey));
            if (value == BagType.INGREDIENT_ADDITION || value == BagType.START_ADDITION) {
                title.m_7220_((Component)Component.m_237115_((String)"gui.maidsoulkitchen.development")).m_130940_(ChatFormatting.YELLOW);
            }
            CookBagModeButton cookBagModeButton = new CookBagModeButton(x, y += 22, 100, 20, (Component)title, b -> {}, Tooltip.m_257550_((Component)Component.m_237115_((String)("gui.maidsoulkitchen.culinary_hub.config.bind_mode." + value.translateKey + ".tooltip")))){

                public void m_5716_(double pMouseX, double pMouseY) {
                    super.m_5716_(pMouseX, pMouseY);
                    CookBagConfigContainerGui.this.bindMode = value.name;
                    NetworkHandler.sendToServer(new SetCookBagBindModeMessage(CookBagConfigContainerGui.this.bindMode));
                }

                public void m_280139_(GuiGraphics pGuiGraphics, Font pFont, int pColor) {
                    if (Objects.equals(CookBagConfigContainerGui.this.bindMode, value.name)) {
                        pColor = Color.GREEN.getRGB();
                    }
                    super.m_280139_(pGuiGraphics, pFont, pColor);
                }
            };
            if (value == BagType.INGREDIENT_ADDITION || value == BagType.START_ADDITION) {
                cookBagModeButton.f_93623_ = false;
            }
            this.m_142416_((GuiEventListener)cookBagModeButton);
        }
        Button clearButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.maidsoulkitchen.culinary_hub.config.clear_bind_poses").m_130940_(ChatFormatting.YELLOW), b -> {
            NetworkHandler.sendToServer(new ClearCookBagBindPosesMessage());
            this.m_7379_();
        }).m_252987_(x, y += 22, 100, 20).m_257505_(Tooltip.m_257550_((Component)Component.m_237115_((String)"gui.maidsoulkitchen.culinary_hub.config.clear_bind_poses.tooltip"))).m_253136_();
        this.m_142416_((GuiEventListener)clearButton);
    }

    private void addInfoButton() {
        int x = this.f_97735_ + this.f_97726_;
        int y = this.f_97736_ + 5;
        ImageButton infoButton = new ImageButton(x - 15, y, 9, 9, 227, 212, 10, TEXTURE, b -> {});
        MutableComponent mutableComponent = Component.m_237115_((String)"tooltips.maidsoulkitchen.culinary_hub.desc.usage").m_130940_(ChatFormatting.GREEN);
        mutableComponent.m_7220_(CommonComponents.f_178388_);
        mutableComponent.m_7220_((Component)Component.m_237115_((String)"tooltips.maidsoulkitchen.culinary_hub.desc.usage.1").m_130940_(ChatFormatting.GRAY));
        mutableComponent.m_7220_(CommonComponents.f_178388_);
        mutableComponent.m_7220_((Component)Component.m_237115_((String)"tooltips.maidsoulkitchen.culinary_hub.desc.usage.2").m_130940_(ChatFormatting.GRAY));
        mutableComponent.m_7220_(CommonComponents.f_178388_);
        mutableComponent.m_7220_((Component)Component.m_237115_((String)"tooltips.maidsoulkitchen.culinary_hub.desc.usage.3").m_130940_(ChatFormatting.GRAY));
        infoButton.m_257544_(Tooltip.m_257550_((Component)mutableComponent));
        this.m_142416_((GuiEventListener)infoButton);
        Map<BagType, List<BlockPos>> bindPoses = ItemCulinaryHub.getBindPoses(((CookBagConfigContainer)this.f_97732_).cookBag);
        ArrayList leftBindBagTypes = new ArrayList();
        bindPoses.forEach((type, poses) -> {
            if (poses.isEmpty() && type != BagType.INGREDIENT_ADDITION && type != BagType.START_ADDITION) {
                leftBindBagTypes.add(type);
            }
        });
        if (bindPoses.isEmpty() || leftBindBagTypes.size() == BagType.values().length - 2) {
            MutableComponent mutableComponent1 = Component.m_237115_((String)"tooltips.maidsoulkitchen.culinary_hub.desc.warn").m_130940_(ChatFormatting.YELLOW);
            mutableComponent1.m_7220_(CommonComponents.f_178388_);
            mutableComponent1.m_7220_((Component)Component.m_237115_((String)"tooltips.maidsoulkitchen.culinary_hub.desc.warn.empty").m_130940_(ChatFormatting.GRAY));
            ImageButton warnButton = new ImageButton(x - 15 - 10, y, 9, 9, 237, 212, 10, TEXTURE, b -> {});
            warnButton.m_257544_(Tooltip.m_257550_((Component)mutableComponent1));
            this.m_142416_((GuiEventListener)warnButton);
        } else if (!leftBindBagTypes.isEmpty()) {
            MutableComponent leftComponent1 = Component.m_237119_();
            boolean first = true;
            for (BagType value : leftBindBagTypes) {
                if (first) {
                    leftComponent1.m_7220_((Component)Component.m_237115_((String)("gui.maidsoulkitchen.culinary_hub.config.bind_mode." + value.translateKey)).m_130940_(ChatFormatting.GRAY));
                    first = false;
                    continue;
                }
                leftComponent1.m_7220_((Component)Component.m_237113_((String)"\u3001").m_7220_((Component)Component.m_237115_((String)("gui.maidsoulkitchen.culinary_hub.config.bind_mode." + value.translateKey)).m_130940_(ChatFormatting.GRAY)));
            }
            MutableComponent leftComponent = Component.m_237113_((String)"[").m_7220_((Component)leftComponent1).m_7220_((Component)Component.m_237113_((String)"]").m_130940_(ChatFormatting.GRAY));
            MutableComponent mutableComponent1 = Component.m_237115_((String)"tooltips.maidsoulkitchen.culinary_hub.desc.warn").m_130940_(ChatFormatting.YELLOW);
            mutableComponent1.m_7220_(CommonComponents.f_178388_);
            mutableComponent1.m_7220_((Component)Component.m_237110_((String)"tooltips.maidsoulkitchen.culinary_hub.desc.warn.left", (Object[])new Object[]{leftComponent}).m_130940_(ChatFormatting.GRAY));
            ImageButton warnButton = new ImageButton(x - 15 - 10, y, 9, 9, 237, 212, 10, TEXTURE, b -> {});
            warnButton.m_257544_(Tooltip.m_257550_((Component)mutableComponent1));
            this.m_142416_((GuiEventListener)warnButton);
        }
    }

    @Override
    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        int x = this.f_97735_ + 6;
        int y = this.f_97736_ + 6;
        int width = 100;
        guiGraphics.m_280480_(Items.f_41953_.m_7968_(), x + width + 2, y + 22);
        guiGraphics.m_280480_(Items.f_41952_.m_7968_(), x + width + 16 + 2, y + 22);
        guiGraphics.m_280480_(Items.f_42413_.m_7968_(), x + width + 2, y + 44 + 2);
        guiGraphics.m_280480_(Items.f_42447_.m_7968_(), x + width + 16 + 2, y + 44 + 2);
        guiGraphics.m_280480_(Items.f_42399_.m_7968_(), x + width + 2, y + 88 + 2);
        guiGraphics.m_280480_(Items.f_42590_.m_7968_(), x + width + 16 + 2, y + 88 + 2);
        guiGraphics.m_280480_(Items.f_42400_.m_7968_(), x + width + 2, y + 110 + 2);
    }

    protected void m_280003_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY) {
        pGuiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"gui.maidsoulkitchen.culinary_hub.config.bind_mode"), this.f_97728_, this.f_97729_ + 12, 0x404040, false);
        pGuiGraphics.m_280614_(this.f_96547_, this.titleComponent, this.f_97728_, this.f_97729_, 0x404040, false);
        pGuiGraphics.m_280614_(this.f_96547_, this.f_169604_, this.f_97730_, this.f_97731_, 0x404040, false);
    }

    @Override
    protected void m_7286_(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        int middleX = (this.f_96543_ - this.f_97726_) / 2;
        int middleY = (this.f_96544_ - this.f_97727_) / 2;
        guiGraphics.m_280218_(CONFIG_BACKGROUND, middleX, middleY, 0, 0, this.f_97726_, this.f_97727_);
        super.m_7286_(guiGraphics, partialTick, mouseX, mouseY);
    }
}

