/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.item;

import com.github.tartaricacid.touhoulittlemaid.api.bauble.IChestType;
import com.github.tartaricacid.touhoulittlemaid.inventory.chest.ChestManager;
import com.github.wallev.maidsoulkitchen.init.MkItems;
import com.github.wallev.maidsoulkitchen.inventory.container.item.BagType;
import com.github.wallev.maidsoulkitchen.inventory.container.item.CookBagAbstractContainer;
import com.github.wallev.maidsoulkitchen.inventory.container.item.CookBagConfigContainer;
import com.github.wallev.maidsoulkitchen.inventory.container.item.CookBagContainer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

public class ItemCulinaryHub
extends Item
implements MenuProvider {
    private static final int COOK_BAG_SIZE = ItemCulinaryHub.getCookBagSize();
    private static final String CONTAINER_TAG = "CulinaryHubContainer";
    private static final String BIND_MODE_TAG = "CulinaryHubBindMode";
    private static final String BIND_POS_TAG = "CulinaryHubBindPos";
    private static final int BIND_SIZE = 3;

    public ItemCulinaryHub() {
        super(new Item.Properties().m_41487_(1));
    }

    public static void removeModePoses(ItemStack stack) {
        if (stack.m_150930_((Item)MkItems.CULINARY_HUB.get())) {
            CompoundTag tag = stack.m_41784_();
            CompoundTag compound = tag.m_128469_(BIND_POS_TAG);
            for (BagType value : BagType.values()) {
                compound.m_128473_(value.name);
            }
            tag.m_128365_(BIND_POS_TAG, (Tag)compound);
        }
    }

    public static void actionModePos(ItemStack stack, String mode, BlockPos blockPos) {
        if (stack.m_150930_((Item)MkItems.CULINARY_HUB.get()) && !mode.isEmpty()) {
            CompoundTag tag = stack.m_41784_();
            CompoundTag compound = tag.m_128469_(BIND_POS_TAG);
            ListTag list = compound.m_128437_(mode, 10);
            AtomicBoolean remove = new AtomicBoolean(false);
            list.removeIf(tag1 -> {
                if (NbtUtils.m_129239_((CompoundTag)((CompoundTag)tag1)).equals((Object)blockPos)) {
                    remove.set(true);
                    return true;
                }
                return false;
            });
            if (!remove.get()) {
                list.add((Object)NbtUtils.m_129224_((BlockPos)blockPos));
                compound.m_128365_(mode, (Tag)list);
            }
            tag.m_128365_(BIND_POS_TAG, (Tag)compound);
        }
    }

    public static List<BlockPos> getBindModePoses(ItemStack stack, String mode) {
        CompoundTag tag;
        if (stack.m_150930_((Item)MkItems.CULINARY_HUB.get()) && (tag = stack.m_41783_()) != null && tag.m_128425_(BIND_POS_TAG, 10)) {
            CompoundTag tag1 = tag.m_128469_(BIND_POS_TAG);
            ListTag list = tag1.m_128437_(mode, 10);
            return list.stream().map(tag2 -> NbtUtils.m_129239_((CompoundTag)((CompoundTag)tag2))).toList();
        }
        return Collections.emptyList();
    }

    public static Map<BagType, List<BlockPos>> getBindPoses(ItemStack stack) {
        CompoundTag tag;
        if (stack.m_150930_((Item)MkItems.CULINARY_HUB.get()) && (tag = stack.m_41783_()) != null && tag.m_128425_(BIND_POS_TAG, 10)) {
            CompoundTag tag1 = tag.m_128469_(BIND_POS_TAG);
            HashMap<BagType, List<BlockPos>> typeListHashMap = new HashMap<BagType, List<BlockPos>>();
            for (BagType value : BagType.values()) {
                ListTag list = tag1.m_128437_(value.name, 10);
                List<BlockPos> poses = list.stream().map(tag2 -> NbtUtils.m_129239_((CompoundTag)((CompoundTag)tag2))).toList();
                typeListHashMap.put(value, poses);
            }
            return typeListHashMap;
        }
        return Map.of();
    }

    public static String getBindMode(ItemStack stack) {
        CompoundTag tag;
        if (stack.m_150930_((Item)MkItems.CULINARY_HUB.get()) && (tag = stack.m_41783_()) != null) {
            return tag.m_128461_(BIND_MODE_TAG);
        }
        return "";
    }

    public static void setBindModeTag(ItemStack stack, String mode) {
        if (stack.m_150930_((Item)MkItems.CULINARY_HUB.get())) {
            CompoundTag tag = stack.m_41784_();
            tag.m_128359_(BIND_MODE_TAG, mode);
        }
    }

    private static int getCookBagSize() {
        int size = 0;
        for (BagType value : BagType.values()) {
            size += value.size * 9;
        }
        return size;
    }

    public static Map<BagType, ItemStackHandler> getContainers(ItemStack stack) {
        HashMap<BagType, ItemStackHandler> bagTypeItemStackHandlerHashMap;
        block5: {
            bagTypeItemStackHandlerHashMap = new HashMap<BagType, ItemStackHandler>();
            if (!stack.m_150930_((Item)MkItems.CULINARY_HUB.get())) break block5;
            CompoundTag tag = stack.m_41783_();
            if (tag == null || !tag.m_128425_(CONTAINER_TAG, 10)) {
                for (BagType value : BagType.values()) {
                    ItemStackHandler handler = new ItemStackHandler(value.size * 9);
                    bagTypeItemStackHandlerHashMap.put(value, handler);
                }
            } else {
                CompoundTag compound = tag.m_128469_(CONTAINER_TAG);
                for (BagType value : BagType.values()) {
                    ItemStackHandler handler = new ItemStackHandler(value.size * 9);
                    if (compound.m_128425_(value.name, 10)) {
                        handler.deserializeNBT(compound.m_128469_(value.name));
                    }
                    bagTypeItemStackHandlerHashMap.put(value, handler);
                }
            }
        }
        return bagTypeItemStackHandlerHashMap;
    }

    public static void setContainer(ItemStack stack, Map<BagType, ItemStackHandler> handlers) {
        if (stack.m_150930_((Item)MkItems.CULINARY_HUB.get())) {
            CompoundTag orCreateTag = stack.m_41784_();
            CompoundTag compound = orCreateTag.m_128469_(CONTAINER_TAG);
            handlers.forEach((bagType, itemStackHandler) -> compound.m_128365_(bagType.name, (Tag)itemStackHandler.serializeNBT()));
            orCreateTag.m_128365_(CONTAINER_TAG, (Tag)compound);
        }
    }

    public static ItemStackHandler getContainer(ItemStack stack) {
        CompoundTag tag;
        ItemStackHandler handler = new ItemStackHandler(COOK_BAG_SIZE);
        if (stack.m_150930_((Item)MkItems.CULINARY_HUB.get()) && (tag = stack.m_41783_()) != null && tag.m_128425_(CONTAINER_TAG, 10)) {
            handler.deserializeNBT(tag.m_128469_(CONTAINER_TAG));
        }
        return handler;
    }

    public static void setContainer(ItemStack stack, ItemStackHandler itemStackHandler) {
        if (stack.m_150930_((Item)MkItems.CULINARY_HUB.get())) {
            stack.m_41784_().m_128365_(CONTAINER_TAG, (Tag)itemStackHandler.serializeNBT());
        }
    }

    public static boolean openCookBagGuiFromSideTab(Player player, int tabIndex) {
        if (player instanceof ServerPlayer) {
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)ItemCulinaryHub.getGuiProviderFromSideTab(tabIndex), buffer -> buffer.m_130055_(player.m_21205_()));
        }
        return true;
    }

    private static MenuProvider getGuiProviderFromSideTab(int tabIndex) {
        if (tabIndex == 0) {
            return ItemCulinaryHub.getCookBagConfigContainer();
        }
        return ItemCulinaryHub.getCookBagContainer();
    }

    private static MenuProvider getCookBagContainer() {
        return new MenuProvider(){

            public Component m_5446_() {
                return Component.m_237113_((String)"Maid Cook Container");
            }

            public CookBagAbstractContainer createMenu(int index, Inventory playerInventory, Player player) {
                return new CookBagContainer(index, playerInventory, player.m_21205_());
            }
        };
    }

    private static MenuProvider getCookBagConfigContainer() {
        return new MenuProvider(){

            public Component m_5446_() {
                return Component.m_237113_((String)"Maid Cook Config Container");
            }

            public CookBagAbstractContainer createMenu(int index, Inventory playerInventory, Player player) {
                return new CookBagConfigContainer(index, playerInventory, player.m_21205_());
            }
        };
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level worldIn = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Player player = context.m_43723_();
        InteractionHand hand = context.m_43724_();
        BlockEntity te = worldIn.m_7702_(pos);
        if (hand != InteractionHand.MAIN_HAND) {
            return super.m_6225_(context);
        }
        if (player == null || te == null) {
            return super.m_6225_(context);
        }
        for (IChestType allChestType : ChestManager.getAllChestTypes()) {
            String bindMode;
            if (!allChestType.isChest(te) || !allChestType.canOpenByPlayer(te, player)) continue;
            ItemStack stack = player.m_21205_();
            List<BlockPos> bindModePoses = ItemCulinaryHub.getBindModePoses(stack, bindMode = ItemCulinaryHub.getBindMode(stack));
            if (bindModePoses.size() >= 3 && !bindModePoses.contains(pos)) {
                if (context.m_43725_().f_46443_) {
                    player.m_213846_((Component)Component.m_237115_((String)"message.maidsoulkitchen.culinary_hub.bine_type_max"));
                }
                return InteractionResult.m_19078_((boolean)worldIn.f_46443_);
            }
            if (bindMode.isEmpty()) continue;
            ItemCulinaryHub.actionModePos(stack, bindMode, pos);
            return InteractionResult.m_19078_((boolean)worldIn.f_46443_);
        }
        return super.m_6225_(context);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        if (handIn == InteractionHand.MAIN_HAND && playerIn instanceof ServerPlayer) {
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)playerIn), (MenuProvider)this, buffer -> buffer.m_130055_(playerIn.m_21205_()));
            return InteractionResultHolder.m_19090_((Object)playerIn.m_21205_());
        }
        return super.m_7203_(worldIn, playerIn, handIn);
    }

    public Component m_5446_() {
        return Component.m_237113_((String)"Cook Bag Container");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return new CookBagConfigContainer(pContainerId, pPlayerInventory, pPlayer.m_21205_());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (!Screen.m_96638_()) {
            tooltip.add((Component)Component.m_237119_());
            tooltip.add((Component)Component.m_237115_((String)"tooltips.maidsoulkitchen.culinary_hub.desc.usage").m_130940_(ChatFormatting.GREEN));
            tooltip.add((Component)Component.m_237115_((String)"tooltips.maidsoulkitchen.culinary_hub.desc.usage.0").m_130940_(ChatFormatting.GRAY));
        } else {
            tooltip.add((Component)Component.m_237119_());
            tooltip.add((Component)Component.m_237115_((String)"tooltips.maidsoulkitchen.culinary_hub.desc.usage").m_130940_(ChatFormatting.GREEN));
            tooltip.add((Component)Component.m_237115_((String)"tooltips.maidsoulkitchen.culinary_hub.desc.usage.1").m_130940_(ChatFormatting.GRAY));
            tooltip.add((Component)Component.m_237115_((String)"tooltips.maidsoulkitchen.culinary_hub.desc.usage.2").m_130940_(ChatFormatting.GRAY));
            tooltip.add((Component)Component.m_237115_((String)"tooltips.maidsoulkitchen.culinary_hub.desc.usage.3").m_130940_(ChatFormatting.GRAY));
        }
        Map<BagType, List<BlockPos>> bindPoses = ItemCulinaryHub.getBindPoses(stack);
        ArrayList leftBindBagTypes = new ArrayList();
        bindPoses.forEach((type, poses) -> {
            if (poses.isEmpty() && type != BagType.INGREDIENT_ADDITION && type != BagType.START_ADDITION) {
                leftBindBagTypes.add(type);
            }
        });
        if (bindPoses.isEmpty() || leftBindBagTypes.size() == BagType.values().length - 2) {
            tooltip.add((Component)Component.m_237119_());
            tooltip.add((Component)Component.m_237115_((String)"tooltips.maidsoulkitchen.culinary_hub.desc.warn").m_130940_(ChatFormatting.YELLOW));
            tooltip.add((Component)Component.m_237115_((String)"tooltips.maidsoulkitchen.culinary_hub.desc.warn.empty").m_130940_(ChatFormatting.GRAY));
        } else if (!leftBindBagTypes.isEmpty()) {
            MutableComponent leftComponent1 = Component.m_237119_();
            boolean first = true;
            for (BagType value : leftBindBagTypes) {
                if (first) {
                    leftComponent1.m_7220_((Component)Component.m_237115_((String)("gui.maidsoulkitchen.culinary_hub.config.bind_mode." + value.translateKey)).m_130940_(ChatFormatting.GRAY));
                    first = false;
                    continue;
                }
                leftComponent1.m_7220_((Component)Component.m_237113_((String)"\u3001").m_7220_((Component)Component.m_237115_((String)("gui.maidsoulkitchen.culinary_hub.config.bind_mode." + value.translateKey)).m_130940_(ChatFormatting.GRAY)));
            }
            MutableComponent leftComponent = Component.m_237113_((String)"[").m_7220_((Component)leftComponent1).m_7220_((Component)Component.m_237113_((String)"]").m_130940_(ChatFormatting.GRAY));
            tooltip.add((Component)Component.m_237119_());
            tooltip.add((Component)Component.m_237115_((String)"tooltips.maidsoulkitchen.culinary_hub.desc.warn").m_130940_(ChatFormatting.YELLOW));
            tooltip.add((Component)Component.m_237110_((String)"tooltips.maidsoulkitchen.culinary_hub.desc.warn.left", (Object[])new Object[]{leftComponent}).m_130940_(ChatFormatting.GRAY));
        }
    }
}

