/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.task.cook.v1.barbequesdelight;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitEntities;
import com.github.wallev.maidsoulkitchen.init.MkEntities;
import com.github.wallev.maidsoulkitchen.task.cook.handler.MaidRecipesManager;
import com.github.wallev.maidsoulkitchen.task.cook.v1.barbequesdelight.TaskBdGrill;
import com.google.common.collect.ImmutableMap;
import com.mao.barbequesdelight.content.block.GrillBlockEntity;
import com.mao.barbequesdelight.content.recipe.GrillingRecipe;
import com.mao.barbequesdelight.init.registrate.BBQDItems;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public class MaidGrillMakeTask
extends Behavior<EntityMaid> {
    private final TaskBdGrill task;
    private final MaidRecipesManager<GrillingRecipe<?>> maidRecipesManager;
    private final List<ItemStack> grillStacks = new ArrayList<ItemStack>();

    public MaidGrillMakeTask(TaskBdGrill task, MaidRecipesManager<GrillingRecipe<?>> maidRecipesManager) {
        super((Map)ImmutableMap.of((Object)((MemoryModuleType)InitEntities.TARGET_POS.get()), (Object)MemoryStatus.VALUE_PRESENT), 1200);
        this.task = task;
        this.maidRecipesManager = maidRecipesManager;
    }

    protected boolean checkExtraStartConditions(ServerLevel worldIn, EntityMaid maid) {
        Brain brain = maid.m_6274_();
        return brain.m_21952_((MemoryModuleType)InitEntities.TARGET_POS.get()).map(targetPos -> {
            Vec3 targetV3d = targetPos.m_7024_();
            return !(maid.m_20238_(targetV3d) > Math.pow(this.task.getCloseEnoughDist(), 2.0));
        }).orElse(false);
    }

    protected boolean canStillUse(ServerLevel worldIn, EntityMaid maid, long pGameTime) {
        return maid.m_6274_().m_21874_((MemoryModuleType)InitEntities.TARGET_POS.get());
    }

    protected void start(ServerLevel worldIn, EntityMaid maid, long pGameTime) {
        super.m_6735_(worldIn, (LivingEntity)maid, pGameTime);
        maid.m_6274_().m_21952_((MemoryModuleType)InitEntities.TARGET_POS.get()).ifPresent(posWrapper -> {
            BlockEntity blockEntity = worldIn.m_7702_(posWrapper.m_6675_());
            if (blockEntity instanceof GrillBlockEntity) {
                GrillBlockEntity grillBlockEntity = (GrillBlockEntity)blockEntity;
                if (!this.maidRecipesManager.getRecipesIngredients().isEmpty()) {
                    Pair<List<Integer>, List<List<ItemStack>>> recipeIngredient = this.maidRecipesManager.getRecipeIngredient();
                    this.grillStacks.addAll((Collection)((List)recipeIngredient.getSecond()).get(0));
                }
                this.maidRecipesManager.getCookInv().syncInv();
            }
        });
    }

    protected void tick(ServerLevel worldIn, EntityMaid maid, long pGameTime) {
        maid.m_6274_().m_21952_((MemoryModuleType)InitEntities.TARGET_POS.get()).ifPresent(posWrapper -> {
            BlockEntity blockEntity = worldIn.m_7702_(posWrapper.m_6675_());
            if (blockEntity instanceof GrillBlockEntity) {
                GrillBlockEntity.ItemEntry[] itemEntries;
                GrillBlockEntity grillBlockEntity = (GrillBlockEntity)blockEntity;
                IItemHandlerModifiable outputInv = this.maidRecipesManager.getOutputInv();
                boolean nothing = true;
                for (GrillBlockEntity.ItemEntry itemEntry : itemEntries = grillBlockEntity.entries) {
                    ItemStack grillStack;
                    ItemStack leftStack;
                    ItemStack stack = itemEntry.stack;
                    if (stack.m_150930_(BBQDItems.BURNT_FOOD.m_5456_())) {
                        leftStack = ItemHandlerHelper.insertItemStacked((IItemHandler)outputInv, (ItemStack)stack.m_41777_(), (boolean)false);
                        stack.m_41774_(stack.m_41613_() - leftStack.m_41613_());
                        grillBlockEntity.inventoryChanged();
                        nothing = false;
                        continue;
                    }
                    if (!stack.m_41619_()) {
                        if (itemEntry.canFlip()) {
                            itemEntry.flip(grillBlockEntity);
                            maid.m_6674_(InteractionHand.MAIN_HAND);
                        }
                        if (itemEntry.flipped && itemEntry.time >= itemEntry.duration) {
                            leftStack = ItemHandlerHelper.insertItemStacked((IItemHandler)outputInv, (ItemStack)stack.m_41777_(), (boolean)false);
                            stack.m_41774_(stack.m_41613_() - leftStack.m_41613_());
                            grillBlockEntity.inventoryChanged();
                        }
                        nothing = false;
                        continue;
                    }
                    if (this.grillStacks.isEmpty() || (grillStack = this.grillStacks.get(0)).m_41619_() || !itemEntry.addItem(grillBlockEntity, grillStack.m_255036_(1))) continue;
                    maid.m_6674_(InteractionHand.MAIN_HAND);
                    grillBlockEntity.inventoryChanged();
                    grillStack.m_41774_(1);
                    nothing = false;
                }
                if (nothing) {
                    this.stop(worldIn, maid, pGameTime);
                    this.maidRecipesManager.getCookInv().syncInv();
                    return;
                }
            }
        });
    }

    protected void stop(ServerLevel worldIn, EntityMaid maid, long pGameTime) {
        super.m_6732_(worldIn, (LivingEntity)maid, pGameTime);
        maid.m_6274_().m_21936_(MemoryModuleType.f_26370_);
        maid.m_6274_().m_21936_((MemoryModuleType)InitEntities.TARGET_POS.get());
        maid.m_6274_().m_21936_((MemoryModuleType)MkEntities.WORK_POS.get());
        this.grillStacks.clear();
    }
}

