/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.task.cook.v1.brewinandchewin;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.wallev.maidsoulkitchen.task.cook.handler.MaidRecipesManager;
import com.github.wallev.maidsoulkitchen.task.cook.v1.brewinandchewin.TaskBncKeg;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.NotNull;
import umpaz.brewinandchewin.common.block.entity.KegBlockEntity;
import umpaz.brewinandchewin.common.crafting.KegFermentingRecipe;

public class KegFermentingRecipesManager
extends MaidRecipesManager<KegFermentingRecipe> {
    private Map<Integer, List<Integer>> temperateListIngredients = new HashMap<Integer, List<Integer>>();
    private int extraTryTime = 0;

    public KegFermentingRecipesManager(EntityMaid maid, TaskBncKeg task) {
        super(maid, task, false);
    }

    public boolean hasRecipeIngredients() {
        return !this.temperateListIngredients.isEmpty();
    }

    public boolean hasRecipeIngredientsWithTemp(int temp) {
        if (!this.temperateListIngredients.isEmpty()) {
            for (Integer integer : this.temperateListIngredients.keySet()) {
                if (!KegBlockEntity.isValidTemp((int)temp, (int)integer)) continue;
                this.extraTryTime = 0;
                return true;
            }
            if (this.extraTryTime++ > 20) {
                this.temperateListIngredients.clear();
                return false;
            }
        }
        return false;
    }

    public Pair<List<Integer>, List<List<ItemStack>>> getRecipeIngredient(int temp) {
        List orDefault;
        int tempTemp = -1;
        for (Integer integer : this.temperateListIngredients.keySet()) {
            if (!KegBlockEntity.isValidTemp((int)temp, (int)integer)) continue;
            tempTemp = integer;
            break;
        }
        if ((orDefault = this.temperateListIngredients.getOrDefault(tempTemp, Collections.emptyList())).isEmpty()) {
            return Pair.of(Collections.emptyList(), Collections.emptyList());
        }
        int remove = (Integer)orDefault.remove(0);
        if (orDefault.isEmpty()) {
            this.temperateListIngredients.remove(temp);
        }
        if (this.temperateListIngredients.isEmpty()) {
            Pair ingredients = (Pair)this.recipesIngredients.get(remove);
            this.recipesIngredients.clear();
            return ingredients;
        }
        return (Pair)this.recipesIngredients.get(remove);
    }

    @Override
    @NotNull
    protected List<Pair<List<Integer>, List<Item>>> getRecIngreMake(Map<Item, Integer> available) {
        if (this.temperateListIngredients == null) {
            this.temperateListIngredients = new HashMap<Integer, List<Integer>>();
        }
        ArrayList<Pair<List<Integer>, List<Item>>> _make = new ArrayList<Pair<List<Integer>, List<Item>>>();
        int index = 0;
        for (KegFermentingRecipe r : this.currentRecs) {
            Pair<List<Integer>, List<Item>> maxCount = this.getAmountIngredient(r, available);
            if (((List)maxCount.getFirst()).isEmpty()) continue;
            _make.add((Pair<List<Integer>, List<Item>>)Pair.of((Object)((List)maxCount.getFirst()), (Object)((List)maxCount.getSecond())));
            if (this.temperateListIngredients.containsKey(r.getTemperature())) {
                this.temperateListIngredients.get(r.getTemperature()).add(index);
            } else {
                this.temperateListIngredients.put(r.getTemperature(), Lists.newArrayList((Object[])new Integer[]{index}));
            }
            ++index;
        }
        this.repeat(_make, available, this.repeatTimes);
        return _make;
    }

    @Override
    protected Pair<List<Integer>, List<Item>> getAmountIngredient(KegFermentingRecipe recipe, Map<Item, Integer> available) {
        boolean hasIngredient;
        TaskBncKeg.MaidKegRecipe maidKettleRecipe = TaskBncKeg.KEG_RECIPE_INGREDIENTS.get(recipe);
        ArrayList<Item> invIngredient = new ArrayList<Item>();
        HashMap<Item, Integer> itemTimes = new HashMap<Item, Integer>();
        boolean[] single = new boolean[]{false};
        boolean hasFluidItem = false;
        int fluidItemAmount = 0;
        Item fluidItem = ItemStack.f_41583_.m_41720_();
        for (ItemStack itemStack : maidKettleRecipe.inFluids()) {
            hasIngredient = false;
            for (Item item : available.keySet()) {
                if (!itemStack.m_150930_(item) || available.get(item) < itemStack.m_41613_()) continue;
                invIngredient.add(item);
                hasIngredient = true;
                if (item.m_41459_() == 1) {
                    single[0] = true;
                    itemTimes.put(item, 1);
                } else {
                    itemTimes.merge(item, 1, Integer::sum);
                }
                fluidItemAmount = itemStack.m_41613_();
                fluidItem = item;
                single[0] = true;
                break;
            }
            if (!hasIngredient) continue;
            hasFluidItem = true;
            break;
        }
        if (!maidKettleRecipe.inFluids().isEmpty() && !hasFluidItem) {
            return Pair.of(Collections.emptyList(), Collections.emptyList());
        }
        for (Ingredient ingredient : maidKettleRecipe.inItems()) {
            hasIngredient = false;
            for (Item item : available.keySet()) {
                ItemStack stack = item.m_7968_();
                if (!ingredient.test(stack)) continue;
                invIngredient.add(item);
                hasIngredient = true;
                if (stack.m_41741_() == 1) {
                    single[0] = true;
                    itemTimes.put(item, 1);
                    break;
                }
                itemTimes.merge(item, 1, Integer::sum);
                break;
            }
            if (hasIngredient) continue;
            return Pair.of(Collections.emptyList(), Collections.emptyList());
        }
        if (itemTimes.entrySet().stream().anyMatch(entry -> (Integer)available.get(entry.getKey()) < (Integer)entry.getValue())) {
            return Pair.of(Collections.emptyList(), Collections.emptyList());
        }
        int maxCount = 64;
        if (single[0]) {
            maxCount = 1;
        } else {
            for (Item item : itemTimes.keySet()) {
                maxCount = Math.min(maxCount, item.m_7968_().m_41741_());
                maxCount = Math.min(maxCount, available.get(item) / (Integer)itemTimes.get(item));
            }
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        if (!maidKettleRecipe.inFluids().isEmpty()) {
            arrayList.add(0, fluidItemAmount);
            available.put(fluidItem, available.get(fluidItem) - fluidItemAmount);
        } else {
            arrayList.add(0, 0);
            invIngredient.add(0, ItemStack.f_41583_.m_41720_());
        }
        for (Item item : invIngredient.stream().skip(1L).toList()) {
            arrayList.add(maxCount);
            available.put(item, available.get(item) - maxCount);
        }
        return Pair.of(arrayList, invIngredient);
    }
}

