/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.task.cook.v1.cuisine;

import com.github.tartaricacid.touhoulittlemaid.api.entity.data.TaskDataKey;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.util.ItemsUtil;
import com.github.wallev.maidsoulkitchen.api.task.v1.cook.ICookTask;
import com.github.wallev.maidsoulkitchen.entity.data.inner.task.CookData;
import com.github.wallev.maidsoulkitchen.init.touhoulittlemaid.RegisterData;
import com.github.wallev.maidsoulkitchen.task.TaskInfo;
import com.github.wallev.maidsoulkitchen.task.ai.MaidCookMoveTask;
import com.github.wallev.maidsoulkitchen.task.cook.handler.MaidRecipesManager;
import com.github.wallev.maidsoulkitchen.task.cook.v1.cuisine.MaidCuisineMakeTask;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import dev.xkmc.cuisinedelight.content.block.CuisineSkilletBlockEntity;
import dev.xkmc.cuisinedelight.content.recipe.BaseCuisineRecipe;
import dev.xkmc.cuisinedelight.content.recipe.CuisineRecipeMatch;
import dev.xkmc.cuisinedelight.init.registrate.CDBlocks;
import dev.xkmc.cuisinedelight.init.registrate.CDItems;
import dev.xkmc.cuisinedelight.init.registrate.CDMisc;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;

public class TaskCdCuisineSkillet
implements ICookTask<CuisineSkilletBlockEntity, BaseCuisineRecipe<?>> {
    @Override
    public boolean isCookBE(BlockEntity blockEntity) {
        return blockEntity instanceof CuisineSkilletBlockEntity;
    }

    @Override
    public RecipeType<BaseCuisineRecipe<?>> getRecipeType() {
        return (RecipeType)CDMisc.RT_CUISINE.get();
    }

    @Override
    public boolean shouldMoveTo(ServerLevel serverLevel, EntityMaid maid, CuisineSkilletBlockEntity blockEntity, MaidRecipesManager<BaseCuisineRecipe<?>> recManager) {
        CombinedInvWrapper maidAvailableInv = maid.getAvailableInv(true);
        return !blockEntity.isCooking() && blockEntity.canCook() && ItemsUtil.findStackSlot((IItemHandler)maidAvailableInv, stack -> stack.m_150930_((Item)CDItems.SPATULA.get())) > -1 && ItemsUtil.findStackSlot((IItemHandler)maidAvailableInv, stack -> stack.m_150930_((Item)CDItems.PLATE.get())) > -1 && !recManager.getRecipesIngredients().isEmpty();
    }

    @Override
    public void processCookMake(ServerLevel serverLevel, EntityMaid maid, CuisineSkilletBlockEntity blockEntity, MaidRecipesManager<BaseCuisineRecipe<?>> recManager) {
    }

    public ResourceLocation getUid() {
        return TaskInfo.CD_CUISINE_SKILLET.uid;
    }

    public ItemStack getIcon() {
        return CDBlocks.SKILLET.asStack();
    }

    @Override
    public TaskDataKey<CookData> getCookDataKey() {
        return RegisterData.CUISINE_SKILLET;
    }

    @Override
    public NonNullList<Ingredient> getIngredients(Recipe<?> recipe) {
        NonNullList nonNullList = NonNullList.m_122779_();
        List<Ingredient> list = ((BaseCuisineRecipe)recipe).list.stream().map(CuisineRecipeMatch::ingredient).toList();
        nonNullList.addAll(list);
        return nonNullList;
    }

    @Override
    public List<Pair<Integer, BehaviorControl<? super EntityMaid>>> createBrainTasks(EntityMaid maid) {
        if (maid.f_19853_.f_46443_) {
            return Collections.emptyList();
        }
        MaidRecipesManager<BaseCuisineRecipe<?>> cookingPotRecipeMaidRecipesManager = this.getRecipesManager(maid);
        MaidCookMoveTask maidCookMoveTask = new MaidCookMoveTask(this, cookingPotRecipeMaidRecipesManager);
        MaidCuisineMakeTask maidCookMakeTask = new MaidCuisineMakeTask(this, cookingPotRecipeMaidRecipesManager);
        return Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)5, maidCookMoveTask), Pair.of((Object)6, (Object)((Object)maidCookMakeTask))});
    }
}

