/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.task.farm;

import com.github.tartaricacid.touhoulittlemaid.api.entity.data.TaskDataKey;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.wallev.maidsoulkitchen.api.TaskBookEntryType;
import com.github.wallev.maidsoulkitchen.api.event.MaidMkTaskEnableEvent;
import com.github.wallev.maidsoulkitchen.api.task.IAddonFarmTask;
import com.github.wallev.maidsoulkitchen.api.task.IFakePlayerTask;
import com.github.wallev.maidsoulkitchen.api.task.v1.farm.ICompatFarm;
import com.github.wallev.maidsoulkitchen.entity.data.inner.task.FruitData;
import com.github.wallev.maidsoulkitchen.entity.passive.IAddonMaid;
import com.github.wallev.maidsoulkitchen.init.touhoulittlemaid.RegisterData;
import com.github.wallev.maidsoulkitchen.inventory.container.maid.FruitFarmConfigContainer;
import com.github.wallev.maidsoulkitchen.task.TaskInfo;
import com.github.wallev.maidsoulkitchen.task.ai.MaidCompatFarmPlantTask;
import com.github.wallev.maidsoulkitchen.task.ai.MaidCompatFruitMoveTask;
import com.github.wallev.maidsoulkitchen.task.farm.handler.v1.IFarmHandlerManager;
import com.github.wallev.maidsoulkitchen.task.farm.handler.v1.fruit.FruitHandler;
import com.github.wallev.maidsoulkitchen.task.farm.handler.v1.fruit.FruitHandlerManager;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class TaskFruitFarm
implements ICompatFarm<FruitHandler, FruitData>,
IFakePlayerTask,
IAddonFarmTask {
    @Override
    public List<Pair<Integer, BehaviorControl<? super EntityMaid>>> createBrainTasks(EntityMaid maid) {
        if (maid.f_19853_.f_46443_) {
            return Lists.newArrayList();
        }
        MaidCompatFruitMoveTask<FruitHandler> maidFarmMoveTask = new MaidCompatFruitMoveTask<FruitHandler>(maid, this, 0.6f);
        MaidCompatFarmPlantTask<FruitHandler> maidFarmPlantTask = new MaidCompatFarmPlantTask<FruitHandler>(maid, this, maidFarmMoveTask.getCompatFarmHandler());
        return Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)5, maidFarmMoveTask), Pair.of((Object)6, maidFarmPlantTask)});
    }

    @Override
    public IFarmHandlerManager<FruitHandler>[] getManagerHandlerValues() {
        return FruitHandlerManager.values();
    }

    @Override
    public boolean canHarvest(EntityMaid maid, BlockPos cropPos, BlockState cropState, FruitHandler handler) {
        return handler != null && !IAddonMaid.BLACK_LIST.contains(cropState.m_60734_()) && handler.canHarvest(maid, cropPos, cropState);
    }

    @Override
    public void harvest(EntityMaid maid, BlockPos cropPos, BlockState cropState, FruitHandler handler) {
        IFakePlayerTask.maidRightClick(maid, cropPos);
    }

    @Override
    public double getCloseEnoughDist() {
        return 6.0;
    }

    @Override
    public FruitData getDefaultData() {
        return new FruitData();
    }

    public ResourceLocation getUid() {
        return TaskInfo.FRUIT_FARM.uid;
    }

    public ItemStack getIcon() {
        return Items.f_42410_.m_7968_();
    }

    @Override
    public boolean isEnable(EntityMaid maid) {
        MaidMkTaskEnableEvent maidMkTaskEnableEvent = new MaidMkTaskEnableEvent(maid, this);
        MinecraftForge.EVENT_BUS.post((Event)maidMkTaskEnableEvent);
        return maidMkTaskEnableEvent.isEnable();
    }

    @Override
    public TaskBookEntryType getBookEntryType() {
        return TaskBookEntryType.FRUIT_FARM;
    }

    public MenuProvider getTaskConfigGuiProvider(EntityMaid maid) {
        final int entityId = maid.m_19879_();
        return new MenuProvider(){

            public Component m_5446_() {
                return Component.m_237113_((String)"Maid Fruit Farm Config Container");
            }

            public AbstractContainerMenu m_7208_(int index, Inventory playerInventory, Player player) {
                return new FruitFarmConfigContainer(index, playerInventory, entityId);
            }
        };
    }

    @Override
    public TaskDataKey<FruitData> getCookDataKey() {
        return RegisterData.FRUIT_FARM;
    }
}

