/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.mixinmanager.legacy;

import com.github.wallev.maidsoulkitchen.MaidsoulKitchen;
import com.github.wallev.maidsoulkitchen.mixinmanager.legacy.JsonConfigBoolean;
import com.github.wallev.maidsoulkitchen.mixinmanager.legacy.config.TaskRegisterConfig;
import com.github.wallev.maidsoulkitchen.mixinmanager.legacy.manager.TaskMixinRegister;
import com.github.wallev.maidsoulkitchen.modclazzchecker.manager.Mods;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.Logger;

public class MixinManagerDev {
    private static final String MIXIN_PACKAGE = "com.github.wallev.maidsoulkitchen.mixin";
    private static final String FILE_NAME = "maidsoulkitchen-mixins.json";
    private static final String CONFIG_FILE_PATH = String.format("./%s/%s", "config", "maidsoulkitchen-mixins.json");
    public static final Map<String, JsonConfigBoolean> MIXIN_CONFIG = new HashMap<String, JsonConfigBoolean>();

    private static void putMixin(String mixinClass, boolean defaultValue, Mods mod) {
        MIXIN_CONFIG.put(mixinClass, new JsonConfigBoolean(mixinClass, (Boolean)defaultValue, mod));
    }

    private static void buildConfig() {
        MIXIN_CONFIG.clear();
        MixinManagerDev.putMixin("farmersdelight.CookingPotBlockEntityMixin", true, Mods.FD);
        MixinManagerDev.putMixin("minersdelight.CopperPotBlockEntityMixin", true, Mods.MD);
        MixinManagerDev.putMixin("youkaishomecoming.BasePotBlockEntityMixin", true, Mods.YHCD);
    }

    protected static boolean isMixinEnabled(String mixinClassName) {
        String mixinClassName1 = mixinClassName.replace(String.format("%s.", MIXIN_PACKAGE), "");
        JsonConfigBoolean mixinConfig = MIXIN_CONFIG.get(mixinClassName1);
        if (mixinConfig == null) {
            return true;
        }
        return mixinConfig.canLoaded();
    }

    protected static void loadMixinSettings() {
        File file = new File(CONFIG_FILE_PATH);
        Gson gson = new Gson();
        if (file.exists()) {
            try {
                FileReader fileReader = new FileReader(file);
                Type mapType = new TypeToken<Map<String, Boolean>>(){}.getType();
                Map existMixinList = (Map)gson.fromJson((Reader)fileReader, mapType);
                existMixinList.forEach((mixinClassName, mixinConfig) -> MIXIN_CONFIG.get(mixinClassName).set((Boolean)mixinConfig));
                fileReader.close();
            }
            catch (Exception e) {
                MaidsoulKitchen.LOGGER.warn("Could not load {} Mixin Configs, creating new config. ERROR: {}", (Object)"maidsoulkitchen", (Object)e.getLocalizedMessage());
            }
        } else {
            MaidsoulKitchen.LOGGER.warn("{} Mixin Configs not found, creating new config.", (Object)"maidsoulkitchen");
        }
        MixinManagerDev.saveMixinSettings();
    }

    public static void saveMixinSettings() {
        Gson gson = new Gson();
        File file = new File(CONFIG_FILE_PATH);
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdir();
        }
        try {
            JsonObject mixinFileData = new JsonObject();
            MIXIN_CONFIG.forEach((mixinClassName, mixinConfig) -> mixinFileData.addProperty(mixinClassName, mixinConfig.get()));
            FileWriter fileWriter = new FileWriter(file);
            fileWriter.write(gson.toJson((JsonElement)mixinFileData));
            fileWriter.close();
        }
        catch (IOException e) {
            MaidsoulKitchen.LOGGER.warn("Could not save {} Mixin Configs: {}", (Object)"maidsoulkitchen", (Object)e.getLocalizedMessage());
        }
    }

    static {
        MixinManagerDev.buildConfig();
        Config.init();
    }

    public static class Config {
        public static TaskRegisterConfig taskRegisterConfig = TaskMixinRegister.create();
        private static final String FILE_NAME = "custom_fruit_handlers.json";
        private static final String CONFIG_FILE_PATH = String.format("./%s/%s/%s", "config", "maidsoulkitchen", "custom_fruit_handlers.json");

        public static void init() {
        }

        public static void load() {
            File file = new File(CONFIG_FILE_PATH);
            if (!file.exists()) {
                return;
            }
            try {
                String json = Files.readString(file.toPath());
                JsonObject jsonData = JsonParser.parseString((String)json).getAsJsonObject();
                TaskRegisterConfig.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonData);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            Config.save();
        }

        public static void save() {
            File file = new File(CONFIG_FILE_PATH);
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdir();
            }
            try {
                JsonObject jsonData = TaskRegisterConfig.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)taskRegisterConfig).resultOrPartial(arg_0 -> ((Logger)MaidsoulKitchen.LOGGER).error(arg_0)).map(jsonElement -> jsonElement.getAsJsonObject()).orElse(null);
                FileWriter fileWriter = new FileWriter(file);
                fileWriter.write(new Gson().toJson((JsonElement)jsonData));
                fileWriter.close();
            }
            catch (IOException e) {
                MaidsoulKitchen.LOGGER.warn("Could not save {} custon_fruit_handlers Configs: {}", (Object)"maidsoulkitchen", (Object)e.getLocalizedMessage());
            }
        }
    }
}

