/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.modclazzchecker.core.classana.clazz;

import com.github.wallev.maidsoulkitchen.MaidsoulKitchen;
import com.github.wallev.maidsoulkitchen.modclazzchecker.core.ModClazzChecker;
import com.github.wallev.maidsoulkitchen.modclazzchecker.core.classana.IMskMixinInterface;
import com.github.wallev.maidsoulkitchen.modclazzchecker.core.classana.clazz.ClassAnalysisResult;
import com.github.wallev.maidsoulkitchen.modclazzchecker.core.classana.clazz.LogEntry;
import com.github.wallev.maidsoulkitchen.modclazzchecker.core.classana.clazz.LogLevel;
import com.github.wallev.maidsoulkitchen.modclazzchecker.core.classana.clazz.MultiClassAnalysisResult;
import com.github.wallev.maidsoulkitchen.modclazzchecker.core.classana.clazz.TaskClazzInfo;
import com.github.wallev.maidsoulkitchen.modclazzchecker.core.manager.BaseClazzCheckManager;
import com.github.wallev.maidsoulkitchen.modclazzchecker.core.util.ModUtil;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;

public class VerifyExistence {
    private static final Marker MARKER = MarkerManager.getMarker((String)"VerifyExistence");

    public static Map<String, Boolean> verify(TaskClazzInfo taskClazzInfo, BaseClazzCheckManager<?, ?> checkManager) throws IOException {
        MultiClassAnalysisResult multiClassAnalysisResult = new MultiClassAnalysisResult();
        HashMap<String, Boolean> taskResult = new HashMap<String, Boolean>();
        Map<String, List<String>> mixinList = taskClazzInfo.taskMixinMap().getMixinList();
        HashMap<String, ClazzInfo> allClazzInfo = new HashMap<String, ClazzInfo>();
        for (String string : taskClazzInfo.allClazzs()) {
            ClazzInfo clazzInfo = ClazzInfo.create(string);
            if (clazzInfo == null) continue;
            allClazzInfo.put(string, clazzInfo);
        }
        for (Map.Entry entry : taskClazzInfo.clazzInfoMap().entrySet()) {
            String taskUid = (String)entry.getKey();
            TaskClazzInfo.ClazzTaskInfo value = (TaskClazzInfo.ClazzTaskInfo)entry.getValue();
            Object task = checkManager.taskInfoByUid(taskUid);
            if (task == null || !task.canLoadWithoutCheckClazz()) continue;
            Object bindMod = task.getBindMod();
            TaskClazzInfo.ClazzInfo clazzInfo = value.clazzInfo();
            ClassAnalysisResult result = new ClassAnalysisResult(taskUid, bindMod.modId(), ModUtil.getModVersion(bindMod.modId()));
            result.classes.addAll(clazzInfo.classes());
            result.methods.addAll(clazzInfo.methods());
            result.fields.addAll(clazzInfo.fields());
            result.mixins.addAll(mixinList.getOrDefault(taskUid, List.of()));
            boolean verifyResult = VerifyExistence.verify(result, allClazzInfo);
            multiClassAnalysisResult.addClassResult(result);
            taskResult.put(taskUid, verifyResult);
            if (verifyResult) continue;
            checkManager.addErrorTask(taskUid);
        }
        Path path = multiClassAnalysisResult.exportToFile(allClazzInfo, checkManager);
        ModClazzChecker.LOGGER.info("The task analysis report has been exported to: {}", (Object)path.toAbsolutePath());
        return taskResult;
    }

    public static boolean verify(ClassAnalysisResult result, Map<String, ClazzInfo> allClazzInfo) {
        boolean contains;
        ClazzInfo clazzInfo;
        String className;
        boolean result0 = true;
        for (String mixin : result.mixins) {
            boolean applied = IMskMixinInterface.applyInterfaceMixin(mixin);
            if (applied) {
                result.mixinExistence.put(mixin, true);
                continue;
            }
            result0 = false;
            result.mixinExistence.put(mixin, false);
            result.addLog(new LogEntry(LogLevel.ERROR, "Mixin failed: " + mixin));
        }
        for (String className2 : result.classes) {
            ClazzInfo clazzInfo2 = allClazzInfo.get(className2);
            if (clazzInfo2 != null) {
                result.classExistence.put(className2, true);
                continue;
            }
            result0 = false;
            result.classExistence.put(className2, false);
            result.addLog(new LogEntry(LogLevel.WARNING, "The class does not exist: " + className2));
        }
        for (String methodSignature : result.methods) {
            String[] parts = methodSignature.split("#");
            if (parts.length != 2) {
                result.methodExistence.put(methodSignature, false);
                result.addLog(new LogEntry(LogLevel.WARNING, "Invalid method signature: " + methodSignature));
                continue;
            }
            className = parts[0];
            String methodAllName = parts[1];
            clazzInfo = allClazzInfo.get(className);
            if (clazzInfo != null) {
                List<String> allMethods = clazzInfo.methods;
                contains = allMethods.stream().anyMatch(m -> m.endsWith(methodAllName));
                result.methodExistence.put(methodSignature, contains);
                if (contains) continue;
                result0 = false;
                result.addLog(new LogEntry(LogLevel.WARNING, "The method does not exist: " + methodSignature));
                continue;
            }
            result0 = false;
            result.classExistence.put(className, false);
            result.addLog(new LogEntry(LogLevel.WARNING, "The class does not exist: " + className));
        }
        for (String fieldSignature : result.fields) {
            String[] parts = fieldSignature.split("#");
            if (parts.length != 2) {
                result.fieldExistence.put(fieldSignature, false);
                result.addLog(new LogEntry(LogLevel.WARNING, "Invalid field signature: " + fieldSignature));
                continue;
            }
            className = parts[0];
            String fieldName = parts[1];
            clazzInfo = allClazzInfo.get(className);
            if (clazzInfo != null) {
                List<String> allFields = clazzInfo.fields();
                contains = allFields.contains(fieldName);
                result.fieldExistence.put(fieldSignature, contains);
                if (contains) continue;
                result0 = false;
                result.addLog(new LogEntry(LogLevel.WARNING, "The field does not exist: " + fieldSignature));
                continue;
            }
            result0 = false;
            result.fieldExistence.put(fieldSignature, false);
            result.addLog(new LogEntry(LogLevel.WARNING, "The class doesn't exist and the field can't be validated:" + className));
        }
        return result0;
    }

    private static List<String> getAllMethodsIncludingInherited(Class<?> targetClass) {
        final LinkedHashSet members = new LinkedHashSet();
        LinkedList classesToProcess = new LinkedList();
        HashSet<Class> processedClasses = new HashSet<Class>();
        classesToProcess.add(targetClass);
        while (!classesToProcess.isEmpty()) {
            Class currentClass = (Class)classesToProcess.pop();
            if (currentClass == null || processedClasses.contains(currentClass)) continue;
            processedClasses.add(currentClass);
            boolean read = true;
            final String className = currentClass.getName().replace('.', '/');
            try (InputStream is = targetClass.getClassLoader().getResourceAsStream(className + ".class");){
                if (is != null) {
                    ClassReader classReader = new ClassReader(is);
                    classReader.accept(new ClassVisitor(589824){

                        public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
                            members.add(className + "#" + name + descriptor);
                            return super.visitMethod(access, name, descriptor, signature, exceptions);
                        }
                    }, 2);
                } else {
                    read = false;
                }
            }
            catch (IOException e) {
                read = false;
            }
            if (!read) {
                try {
                    ClassReader classReader = new ClassReader(className);
                    classReader.accept(new ClassVisitor(589824){

                        public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
                            members.add(className + "#" + name + descriptor);
                            return super.visitMethod(access, name, descriptor, signature, exceptions);
                        }
                    }, 2);
                }
                catch (IOException e) {
                    MaidsoulKitchen.LOGGER.error(MARKER, "{} class not found", (Object)className);
                    e.printStackTrace();
                }
            }
            if (currentClass.getSuperclass() != null) {
                classesToProcess.add(currentClass.getSuperclass());
            }
            classesToProcess.addAll(Arrays.asList(currentClass.getInterfaces()));
        }
        return new ArrayList<String>(members);
    }

    private static List<String> getAllFieldsIncludingInherited(Class<?> targetClass) {
        final LinkedHashSet fields = new LinkedHashSet();
        for (Class<?> currentClass = targetClass; currentClass != null; currentClass = currentClass.getSuperclass()) {
            boolean read = true;
            String className = currentClass.getName().replace('.', '/');
            try (InputStream is = targetClass.getClassLoader().getResourceAsStream(className + ".class");){
                if (is != null) {
                    ClassReader classReader = new ClassReader(is);
                    classReader.accept(new ClassVisitor(589824){

                        public FieldVisitor visitField(int access, String name, String descriptor, String signature, Object value) {
                            fields.add(name);
                            return super.visitField(access, name, descriptor, signature, value);
                        }
                    }, 2);
                } else {
                    read = false;
                }
            }
            catch (IOException e) {
                read = false;
            }
            if (read) continue;
            try {
                ClassReader classReader = new ClassReader(className);
                classReader.accept(new ClassVisitor(589824){

                    public FieldVisitor visitField(int access, String name, String descriptor, String signature, Object value) {
                        fields.add(name);
                        return super.visitField(access, name, descriptor, signature, value);
                    }
                }, 2);
                continue;
            }
            catch (IOException e) {
                MaidsoulKitchen.LOGGER.error(MARKER, "{} class not found", (Object)className);
                e.printStackTrace();
            }
        }
        return new ArrayList<String>(fields);
    }

    public record ClazzInfo(List<String> methods, List<String> fields) {
        public static ClazzInfo create(String clazzName) {
            try {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                Class<?> aClass = Class.forName(clazzName, false, classLoader);
                List<String> allMethods = VerifyExistence.getAllMethodsIncludingInherited(aClass);
                List<String> allFields = VerifyExistence.getAllFieldsIncludingInherited(aClass);
                return new ClazzInfo(allMethods, allFields);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }
    }
}

