/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.client.gui.widget.button;

import com.github.tartaricacid.touhoulittlemaid.api.client.gui.ITooltipButton;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.wallev.maidsoulkitchen.api.task.cook.ICookTask;
import com.github.wallev.maidsoulkitchen.entity.data.inner.task.cook.v0.CookData;
import com.github.wallev.maidsoulkitchen.network.NetworkHandler;
import com.github.wallev.maidsoulkitchen.task.cook.common.rule.rec.mkrec.MKRecipe;
import com.github.wallev.maidsoulkitchen.util.DevUtil;
import com.github.wallev.maidsoulkitchen.vhelper.client.chat.VComponent;
import com.github.wallev.maidsoulkitchen.vhelper.client.resources.VResourceLocation;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.StateSwitchingButton;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class RecButton
extends StateSwitchingButton
implements ITooltipButton {
    private static final ResourceLocation TEXTURE = VResourceLocation.create("maidsoulkitchen", "textures/gui/cook_guide.png");
    public final VirtualSlot virtualSlot;
    protected final EntityMaid maid;
    protected final ICookTask<?, ?> cookTask;
    protected final CookData cookData;
    protected final List<MKRecipe<?>> recipes;
    protected final ItemStack stack;

    public RecButton(EntityMaid maid, ICookTask<?, ?> cookTask, CookData cookData, List<MKRecipe<?>> recipes, int pX, int pY) {
        super(pX, pY, 20, 20, RecButton.containersRecs(cookData, recipes));
        this.m_94624_(179, 25, 22, 0, TEXTURE);
        this.maid = maid;
        this.cookTask = cookTask;
        this.recipes = recipes;
        this.cookData = cookData;
        this.stack = recipes.get(0).output();
        this.virtualSlot = new VirtualSlot(this.stack);
    }

    private static boolean containersRecs(CookData cookData, List<MKRecipe<?>> recipes) {
        for (MKRecipe<?> recipe : recipes) {
            if (!cookData.getRecs().contains(recipe.idStr())) continue;
            return true;
        }
        return false;
    }

    public void toggleState() {
        this.f_94609_ = !this.f_94609_;
        this.f_93623_ = true;
    }

    protected boolean m_93680_(double pMouseX, double pMouseY) {
        return super.m_93680_(pMouseX, pMouseY);
    }

    public boolean superClicked(double pMouseX, double pMouseY) {
        return super.m_93680_(pMouseX, pMouseY);
    }

    public boolean debugClicked() {
        if (DevUtil.isDevEnv() && Screen.m_96637_()) {
            this.debugGiveItem();
            return true;
        }
        return false;
    }

    private void debugGiveItem() {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        MKRecipe<?> recipe = this.recipes.get(0);
        if (!recipe.inFluids().isEmpty()) {
            stacks.add(recipe.inFluids().get(0));
        }
        List<ItemStack> list = recipe.inItems().stream().map(item -> {
            ItemStack[] items = item.ingredient.m_43908_();
            return items.length > 0 ? items[0] : ItemStack.f_41583_;
        }).toList();
        stacks.addAll(list);
        NetworkHandler.C2S.giveRecipeIngredient(stacks);
    }

    public void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.f_94609_ = RecButton.containersRecs(this.cookData, this.recipes);
        super.m_87963_(graphics, mouseX, mouseY, partialTick);
        RenderSystem.enableDepthTest();
        graphics.m_280480_(this.stack, this.m_252754_() + 2, this.m_252907_() + 2);
        RenderSystem.disableDepthTest();
        this.renderShadow(graphics);
    }

    private void renderShadow(GuiGraphics graphics) {
        if (this.cookData.mode().equals(CookData.Mode.WHITELIST.name)) {
            graphics.m_280509_(this.m_252754_(), this.m_252907_(), this.m_252754_() + 20, this.m_252907_() + 20, 1358559737);
        } else {
            graphics.m_280509_(this.m_252754_(), this.m_252907_(), this.m_252754_() + 20, this.m_252907_() + 20, 0x50000010);
        }
    }

    public boolean m_7972_(int pButton) {
        return pButton == 0 || pButton == 1;
    }

    public boolean isTooltipHovered() {
        return this.f_93623_ && this.m_274382_();
    }

    public void renderTooltip(GuiGraphics guiGraphics, Minecraft minecraft, int pMouseX, int pMouseY) {
        this.renderItemStackTooltips(minecraft, guiGraphics, pMouseX, pMouseY);
    }

    public void m_5716_(double pMouseX, double pMouseY) {
        this.arAndSyncRec();
    }

    protected void arAndSyncRec() {
        List<String> strRecs = this.recipes.stream().map(MKRecipe::idStr).toList();
        if (this.f_94609_) {
            this.cookData.removeRecs(strRecs);
        } else {
            this.cookData.addRecs(strRecs);
        }
    }

    private void renderItemStackTooltips(Minecraft mc, GuiGraphics pGuiGraphics, int pMouseX, int pMouseY) {
        this.renderTooltipWithImage(this.stack, mc, pGuiGraphics, pMouseX, pMouseY);
    }

    private void renderTooltipWithImage(ItemStack stack, Minecraft mc, GuiGraphics pGuiGraphics, int pMouseX, int pMouseY) {
        List stackTooltip = Screen.m_280152_((Minecraft)mc, (ItemStack)stack);
        if (this.recipes.size() > 1) {
            boolean whiteMode = this.cookData.mode().equals("whitelist");
            List<String> list = whiteMode ? this.cookData.whitelistRecs() : this.cookData.blacklistRecs();
            int has = 0;
            for (MKRecipe<?> recipe : this.recipes) {
                boolean canCook = list.contains(recipe.idStr());
                if (!canCook) continue;
                ++has;
            }
            boolean canCook = whiteMode ? has > 0 : has == 0;
            MutableComponent cookModeMge = VComponent.translatable("gui.maidsoulkitchen.btn.cook_guide.warn.now_type").m_7220_((Component)VComponent.translatable(String.format("gui.maidsoulkitchen.btn.cook_guide.type.%s", !whiteMode ? "blacklist" : "whitelist"))).m_130940_(ChatFormatting.GOLD);
            stackTooltip.add(cookModeMge);
            MutableComponent canCookMge = VComponent.translatable("gui.maidsoulkitchen.btn.cook_guide.can_cook").m_7220_((Component)VComponent.translatable(String.format("gui.maidsoulkitchen.btn.cook_guide.can_cook.%s", canCook ? "true" : "false"))).m_130940_(canCook ? ChatFormatting.DARK_GREEN : ChatFormatting.DARK_RED);
            stackTooltip.add(canCookMge);
            MutableComponent recipeSelectedMage = VComponent.translatable("gui.maidsoulkitchen.btn.cook_guide.selected_recs", has, this.recipes.size()).m_130940_(ChatFormatting.GRAY);
            stackTooltip.add(recipeSelectedMage);
            pGuiGraphics.renderComponentTooltip(mc.f_91062_, stackTooltip, pMouseX, pMouseY, stack);
        } else {
            MKRecipe<?> recipe = this.recipes.get(0);
            if (mc.f_91066_.f_92125_) {
                stackTooltip.add(stackTooltip.size() - 1, VComponent.literal(String.format("RecipeId: %s", recipe.id())).m_130940_(ChatFormatting.DARK_GRAY));
            }
            boolean modeRandom = !this.cookData.mode().equals(CookData.Mode.WHITELIST.name);
            Optional<TooltipComponent> recClientAmountTooltip = this.getRecClientAmountTooltip(recipe, modeRandom, false, this.cookData, this.maid);
            pGuiGraphics.renderTooltip(mc.f_91062_, stackTooltip, recClientAmountTooltip, stack, pMouseX, pMouseY);
        }
    }

    public Optional<TooltipComponent> getRecClientAmountTooltip(MKRecipe<?> recipe, boolean modeIsBlacklist, boolean overSize, CookData cookData, EntityMaid maid) {
        return this.cookTask.recSerializerManager.getRecClientAmountTooltip(recipe, modeIsBlacklist, overSize, cookData, maid);
    }

    public static class VirtualSlot
    extends Slot {
        private static final Container EMPTY_INV = new SimpleContainer(0);
        private final ItemStack result;

        public VirtualSlot(ItemStack result) {
            super(EMPTY_INV, 0, 0, 0);
            this.result = result;
        }

        public ItemStack m_7993_() {
            return this.result;
        }

        public boolean m_6659_() {
            return false;
        }

        public boolean m_8010_(@NotNull Player playerIn) {
            return false;
        }

        public boolean m_5857_(@NotNull ItemStack stack) {
            return false;
        }

        public boolean m_280329_() {
            return false;
        }

        public boolean m_6657_() {
            return false;
        }

        public boolean m_150651_(@NotNull Player pPlayer) {
            return false;
        }
    }
}

