/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.modclazzchecker.core.manager;

import com.github.wallev.maidsoulkitchen.modclazzchecker.core.classana.IMods;
import com.github.wallev.maidsoulkitchen.modclazzchecker.core.classana.ITaskInfo;
import com.github.wallev.maidsoulkitchen.modclazzchecker.core.classana.ModGroup;
import com.github.wallev.maidsoulkitchen.modclazzchecker.core.classana.clazz.ClassAnalyzerManager;
import com.github.wallev.maidsoulkitchen.modclazzchecker.core.classana.clazz.TaskClazzInfo;
import com.github.wallev.maidsoulkitchen.modclazzchecker.core.lang.TaskErrorLang;
import com.github.wallev.maidsoulkitchen.modclazzchecker.core.lang.TaskErrorLangRead;
import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.objectweb.asm.Type;

public abstract class BaseClazzCheckManager<T extends ITaskInfo<M>, M extends IMods> {
    private final Map<String, TaskErrorLang> errorTaskLangMap = new HashMap<String, TaskErrorLang>();
    private final String modId;
    private final String issueUrl;
    private final String modPackage;
    private final String mixinPackage;
    private final Set<String> mcGroups;
    private final Set<String> blackGroups;
    private final Codec<T> taskCodec;
    private final Codec<M> modsCodec;
    private final Set<String> errorTasks;
    private boolean reported;
    private String fileName;

    public BaseClazzCheckManager(String modId, String issueUrl, String modPackage, String mixinPackage) {
        this.mcGroups = Sets.newHashSet(ModGroup.MC.groups);
        this.blackGroups = Sets.newHashSet(ModGroup.BLACK.groups);
        this.errorTasks = new HashSet<String>();
        this.reported = false;
        this.fileName = "mod_task_clazz.json";
        this.modId = modId;
        this.issueUrl = issueUrl;
        this.modPackage = modPackage;
        this.mixinPackage = mixinPackage;
        this.taskCodec = this.createTaskInfoCodec();
        this.modsCodec = this.createModsCodec();
        this.mcGroups.addAll(this.getExtractMcGroups());
        this.blackGroups.add(modPackage);
        this.blackGroups.addAll(this.getExtractBlackGroups());
    }

    public void writeModTaskClazz(Path rootOutputFolder) throws Exception {
        ClassAnalyzerManager.writeModTaskClazz(rootOutputFolder, this);
    }

    public TaskClazzInfo readModTaskClazzFromFile() {
        return ClassAnalyzerManager.readModTaskClazzFromFile(this);
    }

    public Map<String, Boolean> readModTaskClazz(TaskClazzInfo taskClazzInfo) throws IOException {
        return ClassAnalyzerManager.readModTaskClazz(taskClazzInfo, this);
    }

    public Map<String, Boolean> readModTaskClazz() throws IOException {
        return ClassAnalyzerManager.readModTaskClazz(this);
    }

    public void readErrorTaskLang() {
        TaskErrorLangRead.init(this);
    }

    public String getFileName() {
        return this.fileName;
    }

    protected void setFileName(String fileName) {
        this.fileName = fileName;
    }

    protected Codec<T> getTaskCodec() {
        return this.taskCodec;
    }

    public final Codec<ITaskInfo<?>> getTaskCodecO() {
        return this.getTaskCodec();
    }

    protected abstract Codec<T> createTaskInfoCodec();

    protected Codec<M> getModsCodec() {
        return this.modsCodec;
    }

    public final Codec<IMods> getModsCodecO() {
        return this.getModsCodec();
    }

    protected abstract Codec<M> createModsCodec();

    public String getModId() {
        return this.modId;
    }

    public String getMixinPackage() {
        return this.mixinPackage;
    }

    @Nullable
    public abstract T taskInfoByKey(String var1);

    @Nullable
    public abstract T taskInfoByUid(String var1);

    public abstract T defaultTaskInf();

    public abstract M modsByKey(String var1);

    public abstract List<Type> getTaskClazzAnnotationType();

    public abstract Type getTaskClazzMixinAnnotationType();

    public abstract Type getErrorTaskLangAnnotationType();

    public String getModPackage() {
        return this.modPackage;
    }

    public Set<String> getMcGroups() {
        return this.mcGroups;
    }

    public Set<String> getBlackGroups() {
        return this.blackGroups;
    }

    protected Set<String> getExtractMcGroups() {
        return new HashSet<String>();
    }

    protected Set<String> getExtractBlackGroups() {
        return Sets.newHashSet((Object[])new String[]{this.modPackage});
    }

    public String getIssueUrl() {
        return this.issueUrl;
    }

    public Set<String> getErrorTasks() {
        return this.errorTasks;
    }

    public void addErrorTask(String task) {
        this.errorTasks.add(task);
    }

    public boolean needReportErrorTasks() {
        return !this.reported && !this.errorTasks.isEmpty();
    }

    public void markReported() {
        this.reported = true;
    }

    public Set<String> getExtractMod() {
        return new HashSet<String>();
    }

    public Set<String> getCompatMods() {
        return new HashSet<String>();
    }

    public void addErrorTaskLang(String uid, TaskErrorLang errorTaskLang) {
        this.errorTaskLangMap.put(uid, errorTaskLang);
    }

    public TaskErrorLang getErrorTaskLang(ITaskInfo<?> taskInfo) {
        return this.errorTaskLangMap.get(taskInfo.getUidStr());
    }
}

