/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2modularblock;

import dev.xkmc.l2modularblock.BlockImplementor;
import dev.xkmc.l2modularblock.DelegateBlock;
import dev.xkmc.l2modularblock.mult.AnimateTickBlockMethod;
import dev.xkmc.l2modularblock.mult.AttackBlockMethod;
import dev.xkmc.l2modularblock.mult.CreateBlockStateBlockMethod;
import dev.xkmc.l2modularblock.mult.DefaultStateBlockMethod;
import dev.xkmc.l2modularblock.mult.FallOnBlockMethod;
import dev.xkmc.l2modularblock.mult.NeighborUpdateBlockMethod;
import dev.xkmc.l2modularblock.mult.OnClickBlockMethod;
import dev.xkmc.l2modularblock.mult.OnPlaceBlockMethod;
import dev.xkmc.l2modularblock.mult.OnReplacedBlockMethod;
import dev.xkmc.l2modularblock.mult.PlacementBlockMethod;
import dev.xkmc.l2modularblock.mult.RandomTickBlockMethod;
import dev.xkmc.l2modularblock.mult.ScheduleTickBlockMethod;
import dev.xkmc.l2modularblock.mult.SetPlacedByBlockMethod;
import dev.xkmc.l2modularblock.mult.ShapeUpdateBlockMethod;
import dev.xkmc.l2modularblock.mult.ToolTipBlockMethod;
import dev.xkmc.l2modularblock.one.AnalogOutputBlockMethod;
import dev.xkmc.l2modularblock.one.BlockEntityBlockMethod;
import dev.xkmc.l2modularblock.one.BlockPowerBlockMethod;
import dev.xkmc.l2modularblock.one.EntityInsideBlockMethod;
import dev.xkmc.l2modularblock.one.GetBlockItemBlockMethod;
import dev.xkmc.l2modularblock.one.LightBlockMethod;
import dev.xkmc.l2modularblock.one.MirrorRotateBlockMethod;
import dev.xkmc.l2modularblock.one.RenderShapeBlockMethod;
import dev.xkmc.l2modularblock.one.ShapeBlockMethod;
import dev.xkmc.l2modularblock.one.SpecialDropBlockMethod;
import dev.xkmc.l2modularblock.tile_api.BlockContainer;
import dev.xkmc.l2modularblock.type.BlockMethod;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class DelegateBlockImpl
extends DelegateBlock {
    private static final ThreadLocal<BlockImplementor> TEMP = new ThreadLocal();
    BlockImplementor impl;

    protected DelegateBlockImpl(BlockBehaviour.Properties p, BlockMethod ... impl) {
        super(DelegateBlockImpl.handler(new BlockImplementor(p).addImpls(impl)));
        this.m_49959_(this.impl.reduce(DefaultStateBlockMethod.class, this.m_49966_(), (state, def) -> def.getDefaultState((BlockState)state)));
    }

    private static BlockBehaviour.Properties handler(BlockImplementor bi) {
        if (TEMP.get() != null) {
            throw new RuntimeException("concurrency error");
        }
        TEMP.set(bi);
        return bi.props;
    }

    public final boolean m_7899_(BlockState bs) {
        return this.impl.one(BlockPowerBlockMethod.class).isPresent();
    }

    public final int m_6782_(BlockState blockState, Level worldIn, BlockPos pos) {
        return this.impl.one(AnalogOutputBlockMethod.class).map(e -> e.getAnalogOutputSignal(blockState, worldIn, pos)).orElse(0);
    }

    public boolean m_7278_(BlockState state) {
        return this.impl.one(AnalogOutputBlockMethod.class).map(e -> e.hasAnalogOutputSignal(state)).orElse(false);
    }

    public final int getLightEmission(BlockState bs, BlockGetter w, BlockPos pos) {
        return this.impl.one(LightBlockMethod.class).map(e -> e.getLightValue(bs, w, pos)).orElse(super.getLightEmission(bs, w, pos));
    }

    public final BlockState m_5573_(BlockPlaceContext context) {
        return this.impl.reduce(PlacementBlockMethod.class, this.m_49966_(), (state, impl) -> impl.getStateForPlacement((BlockState)state, context));
    }

    public final int m_6378_(BlockState bs, BlockGetter r, BlockPos pos, Direction d) {
        return this.impl.one(BlockPowerBlockMethod.class).map(e -> e.getSignal(bs, r, pos, d)).orElse(0);
    }

    public final BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return this.impl.one(MirrorRotateBlockMethod.class).map(e -> e.mirror(state, mirrorIn)).orElse(state);
    }

    public final InteractionResult m_6227_(BlockState bs, Level w, BlockPos pos, Player pl, InteractionHand h, BlockHitResult r) {
        return this.impl.execute(OnClickBlockMethod.class).map(e -> e.onClick(bs, w, pos, pl, h, r)).filter(e -> e != InteractionResult.PASS).findFirst().orElse(InteractionResult.PASS);
    }

    public final void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity entity;
        this.impl.forEach(OnReplacedBlockMethod.class, e -> e.onReplaced(state, worldIn, pos, newState, isMoving));
        if (this.impl.one(BlockEntityBlockMethod.class).isPresent() && state.m_60734_() != newState.m_60734_() && (entity = worldIn.m_7702_(pos)) != null) {
            if (entity instanceof Container) {
                Containers.m_19002_((Level)worldIn, (BlockPos)pos, (Container)((Container)entity));
                worldIn.m_46717_(pos, (Block)this);
            } else if (entity instanceof BlockContainer) {
                BlockContainer blockContainer = (BlockContainer)entity;
                for (Container c : blockContainer.getContainers()) {
                    Containers.m_19002_((Level)worldIn, (BlockPos)pos, (Container)c);
                }
                worldIn.m_46717_(pos, (Block)this);
            }
            worldIn.m_46747_(pos);
        }
    }

    public final BlockState m_6843_(BlockState state, Rotation rot) {
        return this.impl.one(MirrorRotateBlockMethod.class).map(e -> e.rotate(state, rot)).orElse(state);
    }

    protected final void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        this.impl = TEMP.get();
        TEMP.set(null);
        this.impl.forEach(CreateBlockStateBlockMethod.class, e -> e.createBlockStateDefinition(builder));
    }

    public final void m_6861_(BlockState state, Level world, BlockPos pos, Block nei_block, BlockPos nei_pos, boolean moving) {
        this.impl.forEach(NeighborUpdateBlockMethod.class, e -> e.neighborChanged(this, state, world, pos, nei_block, nei_pos, moving));
        super.m_6861_(state, world, pos, nei_block, nei_pos, moving);
    }

    public final void m_213898_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        this.impl.forEach(RandomTickBlockMethod.class, e -> e.randomTick(state, world, pos, random));
    }

    public final void m_213897_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        this.impl.forEach(ScheduleTickBlockMethod.class, e -> e.tick(state, world, pos, random));
    }

    @OnlyIn(value=Dist.CLIENT)
    public final void m_214162_(BlockState state, Level world, BlockPos pos, RandomSource r) {
        this.impl.forEach(AnimateTickBlockMethod.class, e -> e.animateTick(state, world, pos, r));
    }

    public final void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        this.impl.one(EntityInsideBlockMethod.class).ifPresent(e -> e.entityInside(state, level, pos, entity));
    }

    public final VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return this.impl.one(ShapeBlockMethod.class).map(e -> e.getCollisionShape(state, level, pos, ctx)).orElseGet(() -> super.m_5939_(state, level, pos, ctx));
    }

    public final VoxelShape m_7947_(BlockState state, BlockGetter level, BlockPos pos) {
        return this.impl.one(ShapeBlockMethod.class).map(e -> e.getBlockSupportShape(state, level, pos)).orElseGet(() -> super.m_7947_(state, level, pos));
    }

    public final VoxelShape m_5909_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return this.impl.one(ShapeBlockMethod.class).map(e -> e.getVisualShape(state, level, pos, ctx)).orElseGet(() -> super.m_5909_(state, level, pos, ctx));
    }

    public final VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return this.impl.one(ShapeBlockMethod.class).map(e -> e.getShape(state, level, pos, ctx)).orElseGet(() -> super.m_5940_(state, level, pos, ctx));
    }

    public final void m_142072_(Level level, BlockState state, BlockPos pos, Entity entity, float height) {
        if (this.impl.reduce(FallOnBlockMethod.class, true, (a, e) -> a & e.fallOn(level, state, pos, entity, height)).booleanValue()) {
            super.m_142072_(level, state, pos, entity, height);
        }
    }

    public final ItemStack m_7397_(BlockGetter world, BlockPos pos, BlockState state) {
        return this.impl.one(GetBlockItemBlockMethod.class).map(e -> e.getCloneItemStack(world, pos, state)).orElse(super.m_7397_(world, pos, state));
    }

    public final List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        return this.impl.one(SpecialDropBlockMethod.class).map(e -> e.getDrops(state, builder)).orElse(super.m_49635_(state, builder));
    }

    public final void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        this.impl.forEach(SetPlacedByBlockMethod.class, e -> e.setPlacedBy(level, pos, state, entity, stack));
    }

    @OnlyIn(value=Dist.CLIENT)
    public final RenderShape m_7514_(BlockState state) {
        return this.impl.one(RenderShapeBlockMethod.class).map(e -> e.getRenderShape(state)).orElseGet(() -> super.m_7514_(state));
    }

    public final void m_6256_(BlockState state, Level level, BlockPos pos, Player player) {
        this.impl.execute(AttackBlockMethod.class).filter(u -> u.attack(state, level, pos, player)).findFirst();
    }

    public final BlockState m_7417_(BlockState selfState, Direction from, BlockState sourceState, LevelAccessor level, BlockPos selfPos, BlockPos sourcePos) {
        return this.impl.reduce(ShapeUpdateBlockMethod.class, selfState, (currentState, e) -> e.updateShape(this, (BlockState)currentState, selfState, from, sourceState, level, selfPos, sourcePos));
    }

    public final void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> list, TooltipFlag flag) {
        this.impl.forEach(ToolTipBlockMethod.class, e -> e.appendHoverText(stack, level, list, flag));
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState old, boolean moving) {
        this.impl.forEach(OnPlaceBlockMethod.class, e -> e.onPlace(state, level, pos, old, moving));
    }

    public final BlockImplementor getImpl() {
        return this.impl;
    }
}

