/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.task.cook.common.inv.item;

import com.github.wallev.maidsoulkitchen.task.cook.common.inv.item.ItemDefinition;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ItemInventory {
    private final Map<Item, Long> items = new HashMap<Item, Long>();
    private final Map<ItemDefinition, Long> stacks = new HashMap<ItemDefinition, Long>();
    private final Map<Item, LinkedList<ItemStack>> itemsMap = new HashMap<Item, LinkedList<ItemStack>>();
    private final Map<ItemDefinition, LinkedList<ItemStack>> stacksMap = new HashMap<ItemDefinition, LinkedList<ItemStack>>();
    private boolean dirty = false;

    public void add(ItemStack stack) {
        if (stack.m_41619_()) {
            return;
        }
        Item item = stack.m_41720_();
        long count = stack.m_41613_();
        ItemDefinition itemDefinition = ItemDefinition.of(stack);
        this.items.merge(item, count, Long::sum);
        this.stacks.merge(itemDefinition, count, Long::sum);
        this.itemsMap.computeIfAbsent(item, k -> new LinkedList()).add(stack);
        this.stacksMap.computeIfAbsent(itemDefinition, k -> new LinkedList()).add(stack);
    }

    public void update() {
        if (this.dirty) {
            boolean b = false;
            this.stacksMap.values().forEach(list -> {
                ItemStack itemStack2;
                IntArrayList removeList = new IntArrayList();
                int i = 0;
                for (ItemStack itemStack2 : list) {
                    if (itemStack2 == null || itemStack2.m_41619_()) {
                        removeList.add(i);
                    }
                    ++i;
                }
                int lastRemoveIndex = 0;
                itemStack2 = removeList.iterator();
                while (itemStack2.hasNext()) {
                    int j = (Integer)itemStack2.next();
                    list.remove(j - lastRemoveIndex++);
                }
                boolean a = true;
            });
            boolean a = true;
            this.itemsMap.values().forEach(list -> {
                ItemStack itemStack2;
                IntArrayList removeList = new IntArrayList();
                int i = 0;
                for (ItemStack itemStack2 : list) {
                    if (itemStack2 == null || itemStack2.m_41619_()) {
                        removeList.add(i);
                    }
                    ++i;
                }
                int lastRemoveIndex = 0;
                itemStack2 = removeList.iterator();
                while (itemStack2.hasNext()) {
                    int j = (Integer)itemStack2.next();
                    list.remove(j - lastRemoveIndex++);
                }
                boolean c = true;
            });
            this.dirty = false;
        }
    }

    public long getItemCount(Item item) {
        return this.items.get(item);
    }

    public long getItemCount(ItemStack itemStack) {
        return this.stacks.get(ItemDefinition.of(itemStack));
    }

    public LinkedList<ItemStack> getItemStacks(Item item) {
        return this.itemsMap.get(item);
    }

    public LinkedList<ItemStack> getItemStacks(ItemDefinition definition) {
        return this.stacksMap.get(definition);
    }

    public LinkedList<ItemStack> getItemStacks(ItemStack itemStack) {
        return this.getItemStacks(itemStack.m_41720_());
    }

    public LinkedList<ItemStack> getItemStacksWithNbt(ItemStack itemStack) {
        return this.getItemStacks(ItemDefinition.of(itemStack));
    }

    public Map<Item, Long> getItems() {
        return this.items;
    }

    public Map<ItemDefinition, Long> getStacks() {
        return this.stacks;
    }

    public Map<Item, LinkedList<ItemStack>> getItemsMap() {
        return this.itemsMap;
    }

    public Map<ItemDefinition, LinkedList<ItemStack>> getStacksMap() {
        return this.stacksMap;
    }

    public void markDirty() {
        this.dirty = true;
    }

    public void clear() {
        this.dirty = false;
        this.items.clear();
        this.stacks.clear();
        this.itemsMap.clear();
        this.stacksMap.clear();
    }
}

