/*
 * Decompiled with CFR 0.152.
 */
package net.hecco.bountifulfares.block.custom;

import net.hecco.bountifulfares.item.BFItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ArtisanCookiesBlock
extends Block {
    public static final int MAX_COUNT = 3;
    public static final IntegerProperty COUNT = IntegerProperty.create((String)"count", (int)0, (int)3);
    public static final int DEFAULT_COMPARATOR_OUTPUT = ArtisanCookiesBlock.getComparatorOutput(0);
    public static final VoxelShape[] SHAPES = new VoxelShape[]{Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)2.0, (double)12.0), Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)4.0, (double)12.0), Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)6.0, (double)12.0), Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0)};

    public ArtisanCookiesBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)COUNT, (Comparable)Integer.valueOf(0)));
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPES[(Integer)state.getValue((Property)COUNT)];
    }

    public InteractionResult use(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack itemStack = player.getItemInHand(hand);
        if (itemStack.is(BFItems.ARTISAN_COOKIE) && (Integer)state.getValue((Property)COUNT) < 3) {
            return InteractionResult.PASS;
        }
        if (world.isClientSide && ArtisanCookiesBlock.tryEat((LevelAccessor)world, pos, state, player, hand).consumesAction()) {
            return InteractionResult.SUCCESS;
        }
        return ArtisanCookiesBlock.tryEat((LevelAccessor)world, pos, state, player, hand);
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        BlockState blockState = ctx.getLevel().getBlockState(ctx.getClickedPos());
        if (blockState.is((Block)this)) {
            if ((Integer)blockState.getValue((Property)COUNT) < 3) {
                return (BlockState)super.withPropertiesOf(blockState).setValue((Property)COUNT, (Comparable)Integer.valueOf((Integer)blockState.getValue((Property)COUNT) + 1));
            }
            return null;
        }
        return super.getStateForPlacement(ctx);
    }

    public boolean canBeReplaced(BlockState state, BlockPlaceContext context) {
        return !context.isSecondaryUseActive() && context.getItemInHand().getItem() == this.asItem() || super.canBeReplaced(state, context);
    }

    protected static InteractionResult tryEat(LevelAccessor world, BlockPos pos, BlockState state, Player player, InteractionHand hand) {
        if (!player.canEat(false)) {
            return InteractionResult.PASS;
        }
        player.getFoodData().eat(3, 0.3f);
        int count = (Integer)state.getValue((Property)COUNT);
        world.gameEvent((Entity)player, GameEvent.EAT, pos);
        if (!player.getItemInHand(hand).is(BFItems.ARTISAN_COOKIE)) {
            if (count > 0) {
                world.setBlock(pos, (BlockState)state.setValue((Property)COUNT, (Comparable)Integer.valueOf(count - 1)), 3);
                world.playSound(null, pos, SoundEvents.GENERIC_EAT, SoundSource.BLOCKS, 0.5f, 1.0f);
            } else {
                world.removeBlock(pos, false);
                world.gameEvent((Entity)player, GameEvent.BLOCK_DESTROY, pos);
                world.playSound(null, pos, SoundEvents.GENERIC_EAT, SoundSource.BLOCKS, 0.5f, 1.0f);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        return direction == Direction.DOWN && !state.canSurvive((LevelReader)world, pos) ? Blocks.AIR.defaultBlockState() : super.updateShape(state, direction, neighborState, world, pos, neighborPos);
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        return world.getBlockState(pos.below()).isSolid();
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{COUNT});
    }

    public int getAnalogOutputSignal(BlockState state, Level world, BlockPos pos) {
        return ArtisanCookiesBlock.getComparatorOutput((Integer)state.getValue((Property)COUNT));
    }

    public static int getComparatorOutput(int COUNT) {
        return (7 - COUNT * 2) * 2;
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public boolean isPathfindable(BlockState state, BlockGetter world, BlockPos pos, PathComputationType type) {
        return false;
    }
}

