/*
 * Decompiled with CFR 0.152.
 */
package net.hecco.bountifulfares.block.custom;

import net.hecco.bountifulfares.block.BFBlocks;
import net.hecco.bountifulfares.block.entity.DyeableCeramicBlockEntity;
import net.hecco.bountifulfares.block.interfaces.DyeableCeramicBlockInterface;
import net.hecco.bountifulfares.item.BFItems;
import net.hecco.bountifulfares.sounds.BFSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeverBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CeramicLeverBlock
extends LeverBlock
implements DyeableCeramicBlockInterface {
    public CeramicLeverBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    public InteractionResult use(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack itemStack = player.getItemInHand(hand);
        if (itemStack.is(BFItems.ARTISAN_BRUSH) && itemStack.getTagElement("display") != null) {
            int brushColor = itemStack.getTagElement("display").getInt("color");
            world.removeBlock(pos, false);
            world.setBlockAndUpdate(pos, this.withPropertiesOf(state));
            world.playSound(player, player.getX(), player.getY(), player.getZ(), SoundEvents.DYE_USE, SoundSource.BLOCKS, 1.0f, 0.8f + world.random.nextFloat() / 3.0f);
            BlockEntity blockEntity = world.getBlockEntity(pos);
            if (blockEntity instanceof DyeableCeramicBlockEntity) {
                DyeableCeramicBlockEntity ceramicTilesBlockEntity = (DyeableCeramicBlockEntity)blockEntity;
                if (ceramicTilesBlockEntity.color != brushColor) {
                    ceramicTilesBlockEntity.color = brushColor;
                    ceramicTilesBlockEntity.setChanged();
                    return InteractionResult.SUCCESS;
                }
            }
        }
        if (world.isClientSide) {
            BlockState blockState = (BlockState)state.cycle((Property)POWERED);
            if (((Boolean)blockState.getValue((Property)POWERED)).booleanValue()) {
                CeramicLeverBlock.spawnParticles(blockState, (LevelAccessor)world, pos, 1.0f);
            }
            return InteractionResult.SUCCESS;
        }
        BlockState blockState = this.pull(state, world, pos);
        SoundEvent f = (Boolean)blockState.getValue((Property)POWERED) != false ? BFSounds.CERAMIC_LEVER_ON : BFSounds.CERAMIC_LEVER_OFF;
        world.playSound(null, pos, f, SoundSource.BLOCKS, 0.8f, 1.0f);
        world.gameEvent((Entity)player, (Boolean)blockState.getValue((Property)POWERED) != false ? GameEvent.BLOCK_ACTIVATE : GameEvent.BLOCK_DEACTIVATE, pos);
        return InteractionResult.CONSUME;
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        switch ((AttachFace)state.getValue((Property)FACE)) {
            case FLOOR: {
                return Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)2.0, (double)12.0);
            }
            case WALL: {
                switch ((Direction)state.getValue((Property)FACING)) {
                    case EAST: {
                        return Block.box((double)0.0, (double)4.0, (double)4.0, (double)2.0, (double)12.0, (double)12.0);
                    }
                    case WEST: {
                        return Block.box((double)14.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0, (double)12.0);
                    }
                    case SOUTH: {
                        return Block.box((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)2.0);
                    }
                }
                return Block.box((double)4.0, (double)4.0, (double)14.0, (double)12.0, (double)12.0, (double)16.0);
            }
        }
        return Block.box((double)4.0, (double)14.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    }

    private static void spawnParticles(BlockState state, LevelAccessor world, BlockPos pos, float alpha) {
        Direction direction = ((Direction)state.getValue((Property)FACING)).getOpposite();
        Direction direction2 = CeramicLeverBlock.getConnectedDirection((BlockState)state).getOpposite();
        double d = (double)pos.getX() + 0.5 + 0.1 * (double)direction.getStepX() + 0.2 * (double)direction2.getStepX();
        double e = (double)pos.getY() + 0.5 + 0.1 * (double)direction.getStepY() + 0.2 * (double)direction2.getStepY();
        double f = (double)pos.getZ() + 0.5 + 0.1 * (double)direction.getStepZ() + 0.2 * (double)direction2.getStepZ();
        world.addParticle((ParticleOptions)new DustParticleOptions(DustParticleOptions.REDSTONE_PARTICLE_COLOR, alpha), d, e, f, 0.0, 0.0, 0.0);
    }

    public ItemStack getCloneItemStack(BlockGetter world, BlockPos pos, BlockState state) {
        if (DyeableCeramicBlockEntity.getColor(world, pos) != 0xFFFFFF) {
            ItemStack stack = super.getCloneItemStack(world, pos, state);
            return this.pickBlock(world, pos, stack);
        }
        return new ItemStack((ItemLike)BFBlocks.CERAMIC_LEVER);
    }
}

