/*
 * Decompiled with CFR 0.152.
 */
package net.hecco.bountifulfares.block.custom;

import net.hecco.bountifulfares.block.BFBlocks;
import net.hecco.bountifulfares.block.entity.DyeableCeramicBlockEntity;
import net.hecco.bountifulfares.block.interfaces.DyeableCeramicBlockInterface;
import net.hecco.bountifulfares.item.BFItems;
import net.hecco.bountifulfares.sounds.BFSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BasePressurePlateBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class CeramicPressurePlateBlock
extends BasePressurePlateBlock
implements DyeableCeramicBlockInterface {
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;

    public CeramicPressurePlateBlock(BlockBehaviour.Properties settings, BlockSetType blockSetType) {
        super(settings, blockSetType);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    protected int getPressedTime() {
        return 2;
    }

    protected int getSignalForState(BlockState state) {
        return (Boolean)state.getValue((Property)POWERED) != false ? 15 : 0;
    }

    protected BlockState setSignalForState(BlockState state, int rsOut) {
        return (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(rsOut > 0));
    }

    protected int getSignalStrength(Level world, BlockPos pos) {
        Class<Entity> var10000 = Entity.class;
        return CeramicPressurePlateBlock.getEntityCount((Level)world, (AABB)TOUCH_AABB.move(pos), var10000) > 0 ? 15 : 0;
    }

    public InteractionResult use(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack itemStack = player.getItemInHand(hand);
        if (itemStack.is(BFItems.ARTISAN_BRUSH) && itemStack.getTagElement("display") != null) {
            int brushColor = itemStack.getTagElement("display").getInt("color");
            world.removeBlock(pos, false);
            world.setBlockAndUpdate(pos, this.withPropertiesOf(state));
            world.playSound(player, player.getX(), player.getY(), player.getZ(), SoundEvents.DYE_USE, SoundSource.BLOCKS, 1.0f, 0.8f + world.random.nextFloat() / 3.0f);
            BlockEntity blockEntity = world.getBlockEntity(pos);
            if (blockEntity instanceof DyeableCeramicBlockEntity) {
                DyeableCeramicBlockEntity ceramicTilesBlockEntity = (DyeableCeramicBlockEntity)blockEntity;
                if (ceramicTilesBlockEntity.color != brushColor) {
                    ceramicTilesBlockEntity.color = brushColor;
                    ceramicTilesBlockEntity.setChanged();
                    return InteractionResult.SUCCESS;
                }
            }
        }
        return super.use(state, world, pos, player, hand, hit);
    }

    private void updateCeramicPlateState(@Nullable Entity entity, Level world, BlockPos pos, BlockState state, int output) {
        boolean bl2;
        int i = this.getSignalStrength(world, pos);
        boolean bl = output > 0;
        boolean bl3 = bl2 = i > 0;
        if (output != i) {
            BlockState blockState = this.setSignalForState(state, i);
            world.setBlock(pos, blockState, 2);
            this.updateNeighbours(world, pos);
            world.setBlocksDirty(pos, state, blockState);
        }
        if (!bl2 && bl) {
            world.playSound(null, pos, BFSounds.CERAMIC_LEVER_OFF, SoundSource.BLOCKS);
            world.gameEvent(entity, GameEvent.BLOCK_DEACTIVATE, pos);
            state.getValue((Property)POWERED);
        } else if (bl2 && !bl) {
            world.playSound(null, pos, BFSounds.CERAMIC_LEVER_ON, SoundSource.BLOCKS);
            world.gameEvent(entity, GameEvent.BLOCK_ACTIVATE, pos);
        }
        if (bl2) {
            world.scheduleTick(new BlockPos((Vec3i)pos), (Block)this, this.getPressedTime());
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{POWERED});
    }

    public ItemStack getCloneItemStack(BlockGetter world, BlockPos pos, BlockState state) {
        if (DyeableCeramicBlockEntity.getColor(world, pos) != 0xFFFFFF) {
            ItemStack stack = super.getCloneItemStack(world, pos, state);
            return this.pickBlock(world, pos, stack);
        }
        return new ItemStack((ItemLike)BFBlocks.CERAMIC_PRESSURE_PLATE);
    }

    public BlockState getAppearance(BlockState state, BlockAndTintGetter renderView, BlockPos pos, Direction side, @Nullable BlockState sourceState, @Nullable BlockPos sourcePos) {
        return super.getAppearance(state, renderView, pos, side, sourceState, sourcePos);
    }
}

